/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.main_stack.identity_management_layer.mainflow;

import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.main_stack.MainStackManager;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.backup_restoration.BackupRestorationViewModel;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.keycloak.KeycloakModel;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.mainflow.IdentityManagementFlow;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.sync.IdentitySyncModel;
import io.olvid.windows.messenger.keycloak.KeycloakUtils;
import io.olvid.windows.messenger.keycloak.pojos.ConfigurationPojo;
import io.olvid.windows.messenger.keycloak.protocol.EnrollementProtocol;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.livedata.cache.DbCache;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.notification_pattern.NotificationListener;
import io.olvid.windows.messenger.misc.state_pattern.FlowStackContext;
import io.olvid.windows.messenger.start_up.AppRuntimeHelper;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class IdentityManagementFlowModel
implements NotificationListener<EnrollementProtocol.KeycloakEnrollementOutputNotification> {
    private final StringProperty title = new SimpleStringProperty();
    private final StringProperty helpPrompt = new SimpleStringProperty();
    private final StringProperty hyperlinkText = new SimpleStringProperty();
    private final StringProperty hyperlinkUri = new SimpleStringProperty();
    private final StringProperty subText = new SimpleStringProperty();
    private ObjectProperty<Object[]> subTextParam = new SimpleObjectProperty(null);
    private final AppLogger logger = new AppLogger(this.getClass());
    private final StringProperty identityFirstName;
    private final StringProperty identityLastName;
    private final StringProperty identityPosition;
    private final StringProperty identityCompany;
    private final BooleanProperty emptyOwnedIdentities;
    private final LiveData<List<OwnedIdentityInfo>> ownedIdentities;
    private ConfigurationPojo configurationPojo;
    private String keycloakConfigurationUrl;
    private final FlowStackContext<IdentityManagementFlow> context;
    private final KeycloakModel keycloakModel = new KeycloakModel(this);
    private final BackupRestorationViewModel backupRestorationViewModel;
    public final IdentitySyncModel identitySyncModel;

    public IdentityManagementFlowModel(FlowStackContext<IdentityManagementFlow> context) {
        this.ownedIdentities = DbCache.getInstance().ownedIdentitiesInfo;
        this.context = context;
        this.identitySyncModel = new IdentitySyncModel(context);
        this.identityCompany = new SimpleStringProperty();
        this.identityFirstName = new SimpleStringProperty();
        this.identityLastName = new SimpleStringProperty();
        this.identityPosition = new SimpleStringProperty();
        this.emptyOwnedIdentities = new SimpleBooleanProperty();
        this.backupRestorationViewModel = new BackupRestorationViewModel(context, this.isEmptyOwnedIdentities());
        this.isEmptyOwnedIdentities();
    }

    public boolean isEmptyOwnedIdentities() {
        return !Api.getOwnedIdentityApi().hasOwnedIdentities();
    }

    public ConfigurationPojo setAndLoadConfiguration(String url) {
        if (url != null && !url.isEmpty()) {
            this.keycloakConfigurationUrl = url;
            return this.loadConfiguration();
        }
        return null;
    }

    public ConfigurationPojo loadConfiguration() {
        if (this.keycloakConfigurationUrl != null && !this.keycloakConfigurationUrl.isEmpty()) {
            this.configurationPojo = KeycloakUtils.getConfigurationFromUri(this.keycloakConfigurationUrl);
            if (this.configurationPojo == null) {
                this.logger.warning("loadConfiguration couldn't load configuration from url : " + this.keycloakConfigurationUrl);
            } else {
                return this.configurationPojo;
            }
        }
        return null;
    }

    public LiveData<List<OwnedIdentityInfo>> getOwnedIdentities() {
        return this.ownedIdentities;
    }

    public void reset() {
        this.identityFirstName.setValue("");
        this.identityLastName.setValue("");
        this.identityPosition.setValue("");
        this.identityCompany.setValue("");
        this.keycloakModel.reset();
        this.backupRestorationViewModel.reset();
        this.identitySyncModel.reset();
    }

    public StringProperty identityFirstNameProperty() {
        return this.identityFirstName;
    }

    public StringProperty identityLastNameProperty() {
        return this.identityLastName;
    }

    public StringProperty identityPositionProperty() {
        return this.identityPosition;
    }

    public StringProperty identityCompanyProperty() {
        return this.identityCompany;
    }

    public String keycloakConfigurationUrl() {
        return this.keycloakConfigurationUrl;
    }

    public KeycloakModel getKeycloakModel() {
        return this.keycloakModel;
    }

    public BackupRestorationViewModel getBackupRestorationViewModel() {
        return this.backupRestorationViewModel;
    }

    public String getTitle() {
        return (String)this.title.get();
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title.set((Object)title);
    }

    public StringProperty helpPromptProperty() {
        return this.helpPrompt;
    }

    public void setHelpPrompt(String helpPrompt) {
        this.helpPrompt.set((Object)helpPrompt);
    }

    public StringProperty hyperlinkTextProperty() {
        return this.hyperlinkText;
    }

    public void setHyperlinkText(String hyperlinkText) {
        this.hyperlinkText.set((Object)hyperlinkText);
    }

    public String getHyperlinkUri() {
        return (String)this.hyperlinkUri.get();
    }

    public StringProperty hyperlinkUriProperty() {
        return this.hyperlinkUri;
    }

    public void setHyperlinkUri(String hyperlinkUri) {
        this.hyperlinkUri.set((Object)hyperlinkUri);
    }

    public StringProperty subTextProperty() {
        return this.subText;
    }

    public void setSubText(String subText) {
        this.subText.setValue(subText);
    }

    public FlowStackContext<IdentityManagementFlow> getFlowContext() {
        return this.context;
    }

    @Override
    public void onReceived(EnrollementProtocol.KeycloakEnrollementOutputNotification enrollementNotification) {
        this.logger.debug("IdentityManagementFlowModel::onReceived received enrollement notification : %s", enrollementNotification.getNotificationType());
        EnrollementProtocol.KeycloakEnrollementOutputNotification keycloakEnrollementOutputNotification = enrollementNotification;
        Objects.requireNonNull(keycloakEnrollementOutputNotification);
        EnrollementProtocol.KeycloakEnrollementOutputNotification keycloakEnrollementOutputNotification2 = keycloakEnrollementOutputNotification;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EnrollementProtocol.WaitingForAuthenticationUrl.class, EnrollementProtocol.WaitingUserForAuthentication.class, EnrollementProtocol.WaitingForOwnedDetails.class, EnrollementProtocol.Binding.class, EnrollementProtocol.WaitingIdentityToBind.class, EnrollementProtocol.EnrollementSuccess.class, EnrollementProtocol.EnrollementFailed.class}, (Object)keycloakEnrollementOutputNotification2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                EnrollementProtocol.WaitingForAuthenticationUrl ignored = (EnrollementProtocol.WaitingForAuthenticationUrl)keycloakEnrollementOutputNotification2;
                ViewControllerHelper.smartUIUpdate(() -> {
                    this.keycloakModel.errorCodeLabel.setValue("");
                    this.keycloakModel.authenticationInProgress.set(true);
                    this.keycloakModel.manualRedirectInputEnabled.set(false);
                    this.keycloakModel.failed.set(false);
                    this.keycloakModel.redirectUserInput.set(null);
                    this.keycloakModel.keycloakProtocolStateLabel.setValue(ViewControllerHelper.getString("waiting_for_url_label"));
                });
                break;
            }
            case 1: {
                EnrollementProtocol.WaitingUserForAuthentication waitingUserForAuthentication = (EnrollementProtocol.WaitingUserForAuthentication)keycloakEnrollementOutputNotification2;
                ViewControllerHelper.smartUIUpdate(() -> {
                    this.keycloakModel.errorCodeLabel.setValue("");
                    this.keycloakModel.keycloakProtocolStateLabel.setValue(ViewControllerHelper.getString("waiting_for_user_authentication_label"));
                });
                this.keycloakModel.setAuthenticationUrl(waitingUserForAuthentication.authUrl());
                try {
                    AppRuntimeHelper.launchBrowser(this.keycloakModel.getAuthenticationUrl());
                    this.context.pushState(IdentityManagementFlow.KEYCLOAK, IdentityManagementFlow.KeycloakState.KEYCLOAK_AUTHENTICATION_IN_PROGRESS);
                }
                catch (IOException ioException) {
                    this.logger.error("IdentityManagementFlowModel::KeycloakProtocolNotificationListener Couldn't start browser....", ioException);
                }
                break;
            }
            case 2: {
                EnrollementProtocol.WaitingForOwnedDetails ignored = (EnrollementProtocol.WaitingForOwnedDetails)keycloakEnrollementOutputNotification2;
                ViewControllerHelper.smartUIUpdate(() -> {
                    this.keycloakModel.errorCodeLabel.setValue("");
                    this.keycloakModel.keycloakProtocolStateLabel.setValue(ViewControllerHelper.getString("fetching_owned_identity_details_label"));
                });
                break;
            }
            case 3: {
                EnrollementProtocol.Binding ignored = (EnrollementProtocol.Binding)keycloakEnrollementOutputNotification2;
                ViewControllerHelper.smartUIUpdate(() -> {
                    this.keycloakModel.errorCodeLabel.setValue("");
                    this.keycloakModel.keycloakProtocolStateLabel.setValue(ViewControllerHelper.getString("binding_identity_label"));
                });
                break;
            }
            case 4: {
                EnrollementProtocol.WaitingIdentityToBind waitingIdentityToBind = (EnrollementProtocol.WaitingIdentityToBind)keycloakEnrollementOutputNotification2;
                ViewControllerHelper.smartUIUpdate(() -> {
                    this.identityFirstName.set((Object)waitingIdentityToBind.firstName());
                    this.identityLastName.set((Object)waitingIdentityToBind.lastName());
                    this.identityCompany.set((Object)waitingIdentityToBind.company());
                    this.identityPosition.set((Object)waitingIdentityToBind.position());
                    this.keycloakModel.keycloakProtocolStateLabel.setValue(null);
                });
                this.context.pushState(IdentityManagementFlow.KEYCLOAK, IdentityManagementFlow.KeycloakState.KEYCLOAK_SHOW_DETAILS);
                break;
            }
            case 5: {
                EnrollementProtocol.EnrollementSuccess enrollementSuccess = (EnrollementProtocol.EnrollementSuccess)keycloakEnrollementOutputNotification2;
                SelectedOwnedIdentitySingleton.getInstance().updateCurrentIdentity(enrollementSuccess.ownedIdentity());
                ViewControllerHelper.smartUIUpdate(this::reset);
                MainStackManager.displayedLayerState.pushState(MainStackManager.DisplayedLayerWrapper.of(MainStackManager.DisplayedLayer.MAIN));
                this.context.clearContext();
                this.context.pushState(IdentityManagementFlow.IDENTITY_CREATION, IdentityManagementFlow.IdentityCreationState.ON_BOARDING);
                break;
            }
            case 6: {
                EnrollementProtocol.EnrollementFailed enrollementFailed = (EnrollementProtocol.EnrollementFailed)keycloakEnrollementOutputNotification2;
                ViewControllerHelper.smartUIUpdate(() -> {
                    this.keycloakModel.keycloakProtocolStateLabel.setValue(ViewControllerHelper.getString("keycloak_protocol_failed_label"));
                    this.keycloakModel.authenticationInProgress.set(false);
                    this.keycloakModel.failed.set(true);
                    switch (enrollementFailed.reason()) {
                        case RFC_INTERNAL_ERROR: 
                        case RFC_INVALID_AUTH_STATE: 
                        case RFC_AUTHENTICATION_REQUIRED: 
                        case RFC_INVALID_DETAILS_SIGNATURE: 
                        case RFC_IDENTITY_NOT_MANAGED: {
                            this.keycloakModel.errorCodeLabel.setValue(ViewControllerHelper.getString("keycloak_identity_internal_error_label"));
                            break;
                        }
                        case RFC_BAD_REDIRECT_URL: {
                            this.keycloakModel.errorCodeLabel.setValue(ViewControllerHelper.getString("keycloak_authentication_failed_bad_redirect"));
                            break;
                        }
                        case RFC_NETWORK_ERROR: {
                            this.keycloakModel.errorCodeLabel.setValue(ViewControllerHelper.getString("keycloak_network_error_label"));
                            break;
                        }
                        case RFC_BAD_RESPONSE: 
                        case RFC_SERVER_ERROR: {
                            this.keycloakModel.errorCodeLabel.setValue(ViewControllerHelper.getString("keycloak_bad_response_label"));
                            break;
                        }
                        case RFC_IDENTITY_ALREADY_UPLOADED: {
                            this.keycloakModel.errorCodeLabel.setValue(ViewControllerHelper.getString("on_boarding_flow_keycloak_already_uploaded"));
                            break;
                        }
                        case RFC_IDENTITY_REVOKED: {
                            this.keycloakModel.errorCodeLabel.setValue(ViewControllerHelper.getString("keycloak_binding_error_identity_revoked_text_label"));
                            break;
                        }
                        case RFC_INTTERUPTED: {
                            this.logger.debug("IdentityManagementFlowModel::onReceived  protocol interrupted (prolly by user)");
                        }
                    }
                });
            }
        }
    }

    public ObjectProperty<Object[]> getSubTextParam() {
        return this.subTextParam;
    }

    public void setSubTextParam(ObjectProperty<Object[]> subTextParam) {
        this.subTextParam = subTextParam;
    }
}

