/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.main_stack.identity_management_layer.mainflow;

import io.olvid.windows.messenger.misc.Either;
import io.olvid.windows.messenger.misc.state_pattern.IFlow;
import io.olvid.windows.messenger.misc.state_pattern.IFlowState;
import java.util.List;

public enum IdentityManagementFlow implements IFlow<IdentityManagementFlow>
{
    IDENTITY_CREATION,
    KEYCLOAK,
    SYNC_SOURCE,
    SYNC_TARGET,
    BACKUP;


    @Override
    public List<IFlowState<IdentityManagementFlow, ?>> getStates() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> List.of(IdentityCreationState.values());
            case 1 -> List.of(KeycloakState.values());
            case 2 -> List.of(SyncSourceState.values());
            case 3 -> List.of(SyncTargetState.values());
            case 4 -> List.of(RestoreBackupState.values());
        };
    }

    public static enum IdentityCreationState implements IdentityManagementFlowState<IdentityCreationState>
    {
        ON_BOARDING,
        NEW_USER,
        IDENTITY_CREATION,
        KNOWN_USER;


        @Override
        public List<Either<IdentityManagementFlow, IdentityCreationState>> getNextSteps() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> List.of(Either.right(KNOWN_USER), Either.right(IDENTITY_CREATION), Either.left(KEYCLOAK), Either.left(SYNC_SOURCE));
                case 1 -> List.of(Either.left(KEYCLOAK));
                case 3 -> List.of(Either.left(SYNC_TARGET), Either.left(BACKUP), Either.left(KEYCLOAK));
                case 2 -> List.of(Either.left(KEYCLOAK));
            };
        }

        @Override
        public boolean hasPrevious() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> false;
                case 1, 2, 3 -> true;
            };
        }

        @Override
        public boolean countSubFlowsAsRemainingSteps() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 2 -> false;
                case 0, 1, 3 -> true;
            };
        }
    }

    public static enum KeycloakState implements IFlowState<IdentityManagementFlow, KeycloakState>
    {
        KEYCLOAK_CONFIGURATION_MANUAL,
        KEYCLOAK_CONFIGURATION,
        KEYCLOAK_AUTHENTICATION_IN_PROGRESS,
        KEYCLOAK_SHOW_DETAILS,
        KEYCLOAK_SELECT_IDENTITY,
        SUCCESS;


        @Override
        public List<Either<IdentityManagementFlow, KeycloakState>> getNextSteps() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> List.of(Either.right(KEYCLOAK_CONFIGURATION));
                case 1 -> List.of(Either.right(KEYCLOAK_AUTHENTICATION_IN_PROGRESS));
                case 2 -> List.of(Either.right(KEYCLOAK_SHOW_DETAILS));
                case 3 -> List.of(Either.right(KEYCLOAK_SELECT_IDENTITY), Either.right(SUCCESS));
                case 4 -> List.of(Either.right(SUCCESS));
                case 5 -> List.of();
            };
        }

        @Override
        public boolean hasPrevious() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 1, 4 -> true;
                case 2, 3, 5 -> false;
            };
        }
    }

    public static enum SyncSourceState implements IFlowState<IdentityManagementFlow, SyncSourceState>
    {
        SHOW_TRANSFER_RESTRICTED_DISCLAIMER,
        SHOW_CODE,
        ENTER_CODE,
        CHOOSE_ACTIVE_DEVICE,
        CONFIRM_NEW_DEVICE,
        CONFIRMATION;


        @Override
        public List<Either<IdentityManagementFlow, SyncSourceState>> getNextSteps() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> List.of(Either.right(SHOW_CODE));
                case 1 -> List.of(Either.right(ENTER_CODE));
                case 2 -> List.of(Either.right(CHOOSE_ACTIVE_DEVICE), Either.right(CONFIRM_NEW_DEVICE));
                case 3, 4 -> List.of(Either.right(CONFIRMATION));
                case 5 -> List.of();
            };
        }

        @Override
        public boolean hasPrevious() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1, 2, 3, 4 -> false;
                case 0, 5 -> true;
            };
        }
    }

    public static enum SyncTargetState implements IFlowState<IdentityManagementFlow, SyncTargetState>
    {
        CHOOSE_NAME,
        ENTER_CODE,
        SHOW_CODE,
        AUTHENTICATION_REQUIRED,
        SUCCESS,
        FAILURE;


        @Override
        public List<Either<IdentityManagementFlow, SyncTargetState>> getNextSteps() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> List.of(Either.right(ENTER_CODE));
                case 1 -> List.of(Either.right(SHOW_CODE));
                case 2 -> List.of(Either.right(AUTHENTICATION_REQUIRED), Either.right(SUCCESS), Either.right(FAILURE));
                case 3 -> List.of(Either.right(SUCCESS), Either.right(FAILURE));
                case 4, 5 -> List.of();
            };
        }

        @Override
        public boolean hasPrevious() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 1 -> true;
                case 2, 3, 4, 5 -> false;
            };
        }
    }

    public static enum RestoreBackupState implements IFlowState<IdentityManagementFlow, RestoreBackupState>
    {
        ENTER_KEY,
        ENTER_KEY_LEGACY,
        SELECT_FILE,
        FILE_CONFIRMATION,
        DEVICE_BACKUP_SELECTION,
        PROFILE_BACKUP_SELECTION,
        KEYCLOAK_AUTHENTICATION,
        WARNING_MULTIDEVICE_LICENSE,
        RESTORE_OTHER_PROFILE_CHOICE;


        @Override
        public List<Either<IdentityManagementFlow, RestoreBackupState>> getNextSteps() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> List.of(Either.right(DEVICE_BACKUP_SELECTION), Either.left(IDENTITY_CREATION));
                case 1 -> List.of(Either.left(IDENTITY_CREATION));
                case 2 -> List.of(Either.right(FILE_CONFIRMATION));
                case 3 -> List.of(Either.right(ENTER_KEY_LEGACY), Either.right(ENTER_KEY));
                case 4 -> List.of(Either.right(PROFILE_BACKUP_SELECTION), Either.right(SELECT_FILE), Either.right(ENTER_KEY));
                case 5 -> List.of(Either.right(KEYCLOAK_AUTHENTICATION), Either.right(WARNING_MULTIDEVICE_LICENSE), Either.right(RESTORE_OTHER_PROFILE_CHOICE));
                case 6 -> List.of(Either.right(WARNING_MULTIDEVICE_LICENSE), Either.right(RESTORE_OTHER_PROFILE_CHOICE));
                case 7 -> List.of(Either.right(RESTORE_OTHER_PROFILE_CHOICE), Either.left(IDENTITY_CREATION));
                case 8 -> List.of(Either.right(DEVICE_BACKUP_SELECTION), Either.left(IDENTITY_CREATION));
            };
        }

        @Override
        public boolean hasPrevious() {
            return true;
        }

        @Override
        public boolean countSubFlowsAsRemainingSteps() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> true;
                case 1 -> true;
                case 2 -> true;
                case 3 -> true;
                case 4 -> true;
                case 5 -> true;
                case 6 -> false;
                case 7 -> false;
                case 8 -> true;
            };
        }
    }

    static interface IdentityManagementFlowState<S extends IdentityManagementFlowState<S>>
    extends IFlowState<IdentityManagementFlow, S> {
    }
}

