/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.main_stack.identity_management_layer.mainflow;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.fx.custom_components.drag_and_drop.DropAreaController;
import io.olvid.windows.messenger.fx.framework.annotations.FXMLView;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.framework.view_controller.ViewControllerManager;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.main_stack.MainStackManager;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.DisplayTextModel;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.OnBoardingController;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.ProgressIndicator;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.RestaureProfileController;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.backup_restoration.subcontroller.BackupRestorationKeycloakAuthenticationController;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.backup_restoration.subcontroller.BackupRestorationMultiDeviceWarningController;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.backup_restoration.subcontroller.DeviceBackupSelectionViewController;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.backup_restoration.subcontroller.ProfileBackupSelectionViewController;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.backup_restoration.subcontroller.ProfileRestoredController;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.backup_restoration.subcontroller.legacy.BackupFileConfirmationController;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.backup_restoration.subcontroller.legacy.BackupFileNeededController;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.backup_restoration.subcontroller.legacy.BackupKeyController;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.creation.IdentityCreationViewController;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.keycloak.KeycloakBindingSelectionController;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.keycloak.KeycloakConfigurationSummaryViewController;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.keycloak.KeycloakManualInputConfiguration;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.keycloak.OnBoardingKeycloakAuthenticationInProgressController;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.keycloak.OwnedIdentityToBindSelectionController;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.mainflow.IdentityManagementFlow;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.mainflow.IdentityManagementFlowModel;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.sync.ActiveDeviceSelectionController;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.sync.ChooseDeviceNameController;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.sync.ConfirmNewDeviceController;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.sync.ConfirmProfileActivationController;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.sync.EnterSasController;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.sync.EnterSessionNumberController;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.sync.RestrictedTransferAuthenticationRequiredController;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.sync.ShowCodeViewController;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.sync.ShowSessionNumberViewController;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.sync.SyncActivationStateController;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.sync.TransferRestrictedDisclaimerController;
import io.olvid.windows.messenger.keycloak.listeners.KeycloakConfigurationUrlListener;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.misc.notification_pattern.NotificationListener;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.TcpMessageNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.TcpServerNC;
import io.olvid.windows.messenger.misc.state_pattern.FlowStackContext;
import io.olvid.windows.messenger.misc.state_pattern.IFlowState;
import io.olvid.windows.messenger.start_up.AppRuntimeHelper;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;

@FXMLView(path="fx/main_stack/identity_management_layer/container_base_view.fxml")
public class IdentitiesManagementFlowController
extends BaseViewController {
    @FXML
    private Pane root;
    @FXML
    private Hyperlink hyperlink;
    @FXML
    private Text title;
    @FXML
    private Label help_prompt;
    @FXML
    private Text sub_text;
    @FXML
    private StackPane progress_container;
    @FXML
    private StackPane container;
    @FXML
    private Button back_button;
    @FXML
    private Button close_button;
    private final ProgressIndicator progressIndicator = new ProgressIndicator();
    private DropAreaController droparea;
    private final IdentityManagementFlowModel model;
    private LiveDataListener<FlowStackContext.State<IdentityManagementFlow>> flowStateListener;
    private final NotificationListener<TcpMessageNotification> onKeycloakConfigurationReceived;
    private static final FlowStackContext<IdentityManagementFlow> identityCreationFlowContext = new FlowStackContext();
    private final ViewControllerManager<FlowStackContext.State<IdentityManagementFlow>> viewManager = new ViewControllerManager(ViewControllerManager.ManagementMode.LAZY);

    public IdentitiesManagementFlowController() {
        this.model = new IdentityManagementFlowModel(identityCreationFlowContext);
        this.loadFxml();
        this.onKeycloakConfigurationReceived = new KeycloakConfigurationUrlListener(this.model, identityCreationFlowContext);
        this.addKeycloakNotificationListener();
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        this.back_button.setOnMouseClicked(this::handleBackButton);
        this.close_button.setOnMouseClicked(this::handleCloseButton);
        AsyncTaskExecutor.submitTask(() -> this.computeAndPushInitialState(true));
        this.bindUi();
        this.bindText();
        Map<FlowStackContext.State<IdentityManagementFlow>, Callable<BaseViewController>> factoryMap = this.createInnersViewsControllers();
        this.droparea = DropAreaController.addDropArea(this.model.getBackupRestorationViewModel(), this.root, true, Optional.empty());
        this.droparea.onLayoutDetached();
        this.viewManager.registerChildrenControllers(factoryMap);
        this.flowStateListener = this::getIdentityManagementFlowStateLiveDataListener;
        identityCreationFlowContext.getCurrentStateLiveData().addListener(this.flowStateListener);
        this.model.getBackupRestorationViewModel().selectedFileProperty().addListener((observable, selectedFileOldValue, selectedFileNewValue) -> {
            if (selectedFileNewValue != null) {
                identityCreationFlowContext.pushState(IdentityManagementFlow.BACKUP, IdentityManagementFlow.RestoreBackupState.FILE_CONFIRMATION);
            }
        });
        this.sub_text.visibleProperty().bind((ObservableValue)this.model.subTextProperty().isEmpty().not());
        this.sub_text.managedProperty().bind((ObservableValue)this.sub_text.visibleProperty());
        this.title.visibleProperty().bind((ObservableValue)this.model.titleProperty().isEmpty().not());
        this.title.managedProperty().bind((ObservableValue)this.title.visibleProperty());
    }

    private void addKeycloakNotificationListener() {
        NCRegistry.getTCPServerNC().subscribe(TcpServerNC.TcpMessageNotificationEnumType.KEYCLOAK_CONFIGURATION_URI, this.onKeycloakConfigurationReceived);
    }

    private Map<FlowStackContext.State<IdentityManagementFlow>, Callable<BaseViewController>> createInnersViewsControllers() {
        HashMap<FlowStackContext.State<IdentityManagementFlow>, Callable<BaseViewController>> factoryMap = new HashMap<FlowStackContext.State<IdentityManagementFlow>, Callable<BaseViewController>>();
        this.registerBackupFlow(factoryMap);
        this.registerIdentityCreationFlow(factoryMap);
        this.registerKeycloakFlow(factoryMap);
        this.registerSyncFlow(factoryMap);
        return factoryMap;
    }

    private void registerBackupFlow(Map<FlowStackContext.State<IdentityManagementFlow>, Callable<BaseViewController>> factoryMap) {
        factoryMap.put(new FlowStackContext.State<IdentityManagementFlow>(IdentityManagementFlow.BACKUP, IdentityManagementFlow.RestoreBackupState.ENTER_KEY), () -> new BackupKeyController(this.model.getBackupRestorationViewModel(), identityCreationFlowContext, this.root, this::close, false));
        factoryMap.put(new FlowStackContext.State<IdentityManagementFlow>(IdentityManagementFlow.BACKUP, IdentityManagementFlow.RestoreBackupState.ENTER_KEY_LEGACY), () -> new BackupKeyController(this.model.getBackupRestorationViewModel(), identityCreationFlowContext, this.root, this::close, true));
        factoryMap.put(new FlowStackContext.State<IdentityManagementFlow>(IdentityManagementFlow.BACKUP, IdentityManagementFlow.RestoreBackupState.SELECT_FILE), () -> new BackupFileNeededController(this.model.getBackupRestorationViewModel()));
        factoryMap.put(new FlowStackContext.State<IdentityManagementFlow>(IdentityManagementFlow.BACKUP, IdentityManagementFlow.RestoreBackupState.FILE_CONFIRMATION), () -> {
            BackupFileConfirmationController confirmationController = new BackupFileConfirmationController(this.model.getBackupRestorationViewModel(), identityCreationFlowContext);
            if (this.model.isEmptyOwnedIdentities()) {
                confirmationController.getButton_validate().setOnAction(event -> identityCreationFlowContext.pushState(IdentityManagementFlow.BACKUP, IdentityManagementFlow.RestoreBackupState.ENTER_KEY_LEGACY));
            } else {
                confirmationController.getButton_validate().setOnAction(event -> identityCreationFlowContext.pushState(IdentityManagementFlow.BACKUP, IdentityManagementFlow.RestoreBackupState.ENTER_KEY));
            }
            return confirmationController;
        });
        factoryMap.put(new FlowStackContext.State<IdentityManagementFlow>(IdentityManagementFlow.BACKUP, IdentityManagementFlow.RestoreBackupState.DEVICE_BACKUP_SELECTION), () -> new DeviceBackupSelectionViewController(identityCreationFlowContext, this.model.getBackupRestorationViewModel()));
        factoryMap.put(new FlowStackContext.State<IdentityManagementFlow>(IdentityManagementFlow.BACKUP, IdentityManagementFlow.RestoreBackupState.PROFILE_BACKUP_SELECTION), () -> new ProfileBackupSelectionViewController(identityCreationFlowContext, this.model.getBackupRestorationViewModel()));
        factoryMap.put(new FlowStackContext.State<IdentityManagementFlow>(IdentityManagementFlow.BACKUP, IdentityManagementFlow.RestoreBackupState.KEYCLOAK_AUTHENTICATION), () -> new BackupRestorationKeycloakAuthenticationController(this.model.getBackupRestorationViewModel()));
        factoryMap.put(new FlowStackContext.State<IdentityManagementFlow>(IdentityManagementFlow.BACKUP, IdentityManagementFlow.RestoreBackupState.WARNING_MULTIDEVICE_LICENSE), () -> new BackupRestorationMultiDeviceWarningController(this.model.getBackupRestorationViewModel(), identityCreationFlowContext));
        factoryMap.put(new FlowStackContext.State<IdentityManagementFlow>(IdentityManagementFlow.BACKUP, IdentityManagementFlow.RestoreBackupState.RESTORE_OTHER_PROFILE_CHOICE), () -> new ProfileRestoredController(this.model.getBackupRestorationViewModel(), identityCreationFlowContext));
    }

    private void registerIdentityCreationFlow(Map<FlowStackContext.State<IdentityManagementFlow>, Callable<BaseViewController>> factoryMap) {
        factoryMap.put(new FlowStackContext.State<IdentityManagementFlow>(IdentityManagementFlow.IDENTITY_CREATION, IdentityManagementFlow.IdentityCreationState.ON_BOARDING), () -> new OnBoardingController(identityCreationFlowContext));
        factoryMap.put(new FlowStackContext.State<IdentityManagementFlow>(IdentityManagementFlow.IDENTITY_CREATION, IdentityManagementFlow.IdentityCreationState.KNOWN_USER), () -> new RestaureProfileController(identityCreationFlowContext));
        factoryMap.put(new FlowStackContext.State<IdentityManagementFlow>(IdentityManagementFlow.IDENTITY_CREATION, IdentityManagementFlow.IdentityCreationState.IDENTITY_CREATION), () -> new IdentityCreationViewController(identityCreationFlowContext, this.model));
    }

    private void registerKeycloakFlow(Map<FlowStackContext.State<IdentityManagementFlow>, Callable<BaseViewController>> factoryMap) {
        KeycloakManualInputConfiguration keycloakManualInputConfiguration = new KeycloakManualInputConfiguration(this.model);
        factoryMap.put(new FlowStackContext.State<IdentityManagementFlow>(IdentityManagementFlow.KEYCLOAK, IdentityManagementFlow.KeycloakState.KEYCLOAK_CONFIGURATION_MANUAL), () -> keycloakManualInputConfiguration);
        factoryMap.put(new FlowStackContext.State<IdentityManagementFlow>(IdentityManagementFlow.KEYCLOAK, IdentityManagementFlow.KeycloakState.KEYCLOAK_CONFIGURATION), () -> new KeycloakConfigurationSummaryViewController(this.model));
        factoryMap.put(new FlowStackContext.State<IdentityManagementFlow>(IdentityManagementFlow.KEYCLOAK, IdentityManagementFlow.KeycloakState.KEYCLOAK_AUTHENTICATION_IN_PROGRESS), () -> new OnBoardingKeycloakAuthenticationInProgressController(this.model.getKeycloakModel()));
        factoryMap.put(new FlowStackContext.State<IdentityManagementFlow>(IdentityManagementFlow.KEYCLOAK, IdentityManagementFlow.KeycloakState.KEYCLOAK_SHOW_DETAILS), () -> new KeycloakBindingSelectionController(identityCreationFlowContext, this.model, this.root));
        factoryMap.put(new FlowStackContext.State<IdentityManagementFlow>(IdentityManagementFlow.KEYCLOAK, IdentityManagementFlow.KeycloakState.KEYCLOAK_SELECT_IDENTITY), () -> new OwnedIdentityToBindSelectionController(identityCreationFlowContext, this.model));
    }

    private void registerSyncFlow(Map<FlowStackContext.State<IdentityManagementFlow>, Callable<BaseViewController>> factoryMap) {
        factoryMap.put(new FlowStackContext.State<IdentityManagementFlow>(IdentityManagementFlow.SYNC_TARGET, IdentityManagementFlow.SyncTargetState.CHOOSE_NAME), () -> new ChooseDeviceNameController(this.model.identitySyncModel));
        factoryMap.put(new FlowStackContext.State<IdentityManagementFlow>(IdentityManagementFlow.SYNC_TARGET, IdentityManagementFlow.SyncTargetState.ENTER_CODE), () -> new EnterSessionNumberController(this.model.identitySyncModel));
        factoryMap.put(new FlowStackContext.State<IdentityManagementFlow>(IdentityManagementFlow.SYNC_TARGET, IdentityManagementFlow.SyncTargetState.SHOW_CODE), () -> new ShowCodeViewController(this.model.identitySyncModel));
        factoryMap.put(new FlowStackContext.State<IdentityManagementFlow>(IdentityManagementFlow.SYNC_TARGET, IdentityManagementFlow.SyncTargetState.AUTHENTICATION_REQUIRED), () -> new RestrictedTransferAuthenticationRequiredController(this.model));
        factoryMap.put(new FlowStackContext.State<IdentityManagementFlow>(IdentityManagementFlow.SYNC_TARGET, IdentityManagementFlow.SyncTargetState.SUCCESS), () -> new SyncActivationStateController(this.model.identitySyncModel));
        factoryMap.put(new FlowStackContext.State<IdentityManagementFlow>(IdentityManagementFlow.SYNC_SOURCE, IdentityManagementFlow.SyncSourceState.SHOW_TRANSFER_RESTRICTED_DISCLAIMER), () -> new TransferRestrictedDisclaimerController(this.model.identitySyncModel));
        factoryMap.put(new FlowStackContext.State<IdentityManagementFlow>(IdentityManagementFlow.SYNC_SOURCE, IdentityManagementFlow.SyncSourceState.SHOW_CODE), () -> new ShowSessionNumberViewController(this.model.identitySyncModel));
        factoryMap.put(new FlowStackContext.State<IdentityManagementFlow>(IdentityManagementFlow.SYNC_SOURCE, IdentityManagementFlow.SyncSourceState.ENTER_CODE), () -> new EnterSasController(this.model.identitySyncModel));
        factoryMap.put(new FlowStackContext.State<IdentityManagementFlow>(IdentityManagementFlow.SYNC_SOURCE, IdentityManagementFlow.SyncSourceState.CHOOSE_ACTIVE_DEVICE), () -> new ActiveDeviceSelectionController(this.model.identitySyncModel));
        factoryMap.put(new FlowStackContext.State<IdentityManagementFlow>(IdentityManagementFlow.SYNC_SOURCE, IdentityManagementFlow.SyncSourceState.CONFIRM_NEW_DEVICE), () -> new ConfirmNewDeviceController(this.model.identitySyncModel));
        factoryMap.put(new FlowStackContext.State<IdentityManagementFlow>(IdentityManagementFlow.SYNC_SOURCE, IdentityManagementFlow.SyncSourceState.CONFIRMATION), () -> new ConfirmProfileActivationController(this.model.identitySyncModel));
    }

    private void getIdentityManagementFlowStateLiveDataListener(FlowStackContext.State<IdentityManagementFlow> newValue, FlowStackContext.State<IdentityManagementFlow> oldValue) {
        if (newValue == null || newValue.equals(oldValue)) {
            return;
        }
        IdentityManagementFlow flow = newValue.flow();
        ViewControllerHelper.smartUIUpdate(() -> {
            this.back_button.setVisible(newValue.state().hasPrevious());
            this.close_button.setVisible(!this.model.isEmptyOwnedIdentities());
            this.viewManager.replaceView(newValue, (Pane)this.container, null, null);
            switch (flow) {
                case IDENTITY_CREATION: {
                    this.handleIdentityCreationFlow(newValue);
                    break;
                }
                case KEYCLOAK: {
                    this.handleKeycloakflow(newValue);
                    break;
                }
                case SYNC_SOURCE: {
                    this.handleSyncSource(newValue);
                    this.updateDroparea(false);
                    break;
                }
                case SYNC_TARGET: {
                    this.handleSyncTarget(newValue);
                    break;
                }
                case BACKUP: {
                    this.handleBackupFlow(newValue);
                }
            }
            this.updateProgressIndicator();
        });
    }

    private void handleIdentityCreationFlow(FlowStackContext.State<IdentityManagementFlow> newValue) {
        IFlowState<IdentityManagementFlow, ?> iFlowState = newValue.state();
        if (iFlowState instanceof IdentityManagementFlow.IdentityCreationState) {
            IdentityManagementFlow.IdentityCreationState creationState = (IdentityManagementFlow.IdentityCreationState)iFlowState;
            switch (creationState) {
                case ON_BOARDING: {
                    this.setTextModel(OnBoardingController.DISPLAY_TEXT_MODEL);
                    break;
                }
                case NEW_USER: {
                    break;
                }
                case IDENTITY_CREATION: {
                    this.setTextModel(IdentityCreationViewController.DISPLAY_TEXT_MODEL);
                    break;
                }
                case KNOWN_USER: {
                    this.setTextModel(RestaureProfileController.DISPLAY_TEXT_MODEL);
                }
            }
            this.updateDroparea(false);
        }
    }

    private void handleKeycloakflow(FlowStackContext.State<IdentityManagementFlow> newValue) {
        IFlowState<IdentityManagementFlow, ?> iFlowState = newValue.state();
        if (iFlowState instanceof IdentityManagementFlow.KeycloakState) {
            IdentityManagementFlow.KeycloakState keycloakState = (IdentityManagementFlow.KeycloakState)iFlowState;
            switch (keycloakState) {
                case KEYCLOAK_CONFIGURATION_MANUAL: {
                    this.setTextModel(KeycloakManualInputConfiguration.DISPLAY_TEXT_MODEL);
                    break;
                }
                case KEYCLOAK_CONFIGURATION: {
                    this.model.getBackupRestorationViewModel().setSelectedFile(null);
                    this.setTextModel(KeycloakConfigurationSummaryViewController.DISPLAY_TEXT_MODEL);
                    break;
                }
                case KEYCLOAK_AUTHENTICATION_IN_PROGRESS: {
                    this.setTextModel(RestrictedTransferAuthenticationRequiredController.AUTHENTICATION_REQUIRED_DISPLAY_TEXT_MODEL);
                    break;
                }
                case KEYCLOAK_SHOW_DETAILS: {
                    this.setTextModel(KeycloakBindingSelectionController.DISPLAY_TEXT_MODEL);
                    break;
                }
                case KEYCLOAK_SELECT_IDENTITY: {
                    this.setTextModel(OwnedIdentityToBindSelectionController.DISPLAY_TEXT_MODEL);
                    break;
                }
            }
        }
        this.updateDroparea(false);
    }

    private void handleBackupFlow(FlowStackContext.State<IdentityManagementFlow> newValue) {
        IFlowState<IdentityManagementFlow, ?> iFlowState = newValue.state();
        if (iFlowState instanceof IdentityManagementFlow.RestoreBackupState) {
            IdentityManagementFlow.RestoreBackupState restoreBackupState = (IdentityManagementFlow.RestoreBackupState)iFlowState;
            switch (restoreBackupState) {
                case SELECT_FILE: {
                    this.model.getBackupRestorationViewModel().setSelectedFile(null);
                    this.setTextModel(BackupFileNeededController.DISPLAY_TEXT_MODEL);
                    break;
                }
                case FILE_CONFIRMATION: {
                    this.setTextModel(BackupFileConfirmationController.DISPLAY_TEXT_MODEL);
                    break;
                }
                case ENTER_KEY: {
                    this.setTextModel(BackupKeyController.DISPLAY_TEXT_MODEL);
                    break;
                }
                case DEVICE_BACKUP_SELECTION: {
                    this.setTextModel(DeviceBackupSelectionViewController.DISPLAY_TEXT_MODEL);
                    break;
                }
                case PROFILE_BACKUP_SELECTION: {
                    this.setTextModel(ProfileBackupSelectionViewController.DISPLAY_TEXT_MODEL);
                    break;
                }
                case KEYCLOAK_AUTHENTICATION: {
                    this.setTextModel(BackupRestorationKeycloakAuthenticationController.DISPLAY_TEXT_MODEL);
                    break;
                }
                case WARNING_MULTIDEVICE_LICENSE: {
                    this.setTextModel(BackupRestorationMultiDeviceWarningController.DISPLAY_TEXT_MODEL);
                    break;
                }
            }
            this.updateDroparea(true);
        }
    }

    private void handleSyncTarget(FlowStackContext.State<IdentityManagementFlow> newValue) {
        IFlowState<IdentityManagementFlow, ?> iFlowState = newValue.state();
        if (iFlowState instanceof IdentityManagementFlow.SyncTargetState) {
            IdentityManagementFlow.SyncTargetState state = (IdentityManagementFlow.SyncTargetState)iFlowState;
            switch (state) {
                case CHOOSE_NAME: {
                    this.setTextModel(ChooseDeviceNameController.DISPLAY_TEXT_MODEL);
                    break;
                }
                case ENTER_CODE: {
                    this.setTextModel(EnterSessionNumberController.RECIPIENT_DISPLAY_TEXT_MODEL);
                    break;
                }
                case SHOW_CODE: {
                    this.setTextModel(ShowCodeViewController.TARGET_DISPLAY_TEXT_MODEL);
                    break;
                }
                case AUTHENTICATION_REQUIRED: {
                    this.setTextModel(RestrictedTransferAuthenticationRequiredController.AUTHENTICATION_REQUIRED_DISPLAY_TEXT_MODEL);
                    break;
                }
                case SUCCESS: {
                    this.setTextModel(SyncActivationStateController.DISPLAY_TEXT_MODEL);
                    break;
                }
            }
        }
    }

    private void handleSyncSource(FlowStackContext.State<IdentityManagementFlow> newValue) {
        IFlowState<IdentityManagementFlow, ?> iFlowState = newValue.state();
        if (iFlowState instanceof IdentityManagementFlow.SyncSourceState) {
            IdentityManagementFlow.SyncSourceState state = (IdentityManagementFlow.SyncSourceState)iFlowState;
            switch (state) {
                case SHOW_TRANSFER_RESTRICTED_DISCLAIMER: {
                    this.setTextModel(TransferRestrictedDisclaimerController.RESTRICTED_DISPLAY_TEXT_MODEL);
                    break;
                }
                case SHOW_CODE: {
                    this.setTextModel(ShowCodeViewController.SOURCE_DISPLAY_TEXT_MODEL);
                    break;
                }
                case ENTER_CODE: {
                    this.setTextModel(EnterSasController.SOURCE_DISPLAY_TEXT_MODEL);
                    break;
                }
                case CHOOSE_ACTIVE_DEVICE: {
                    this.setTextModel(ActiveDeviceSelectionController.DISPLAY_TEXT_MODEL);
                    break;
                }
                case CONFIRM_NEW_DEVICE: {
                    this.setTextModel(ConfirmNewDeviceController.DISPLAY_TEXT_MODEL);
                    break;
                }
                case CONFIRMATION: {
                    this.setTextModel(ConfirmProfileActivationController.DISPLAY_TEXT_MODEL);
                }
            }
        }
    }

    private void updateProgressIndicator() {
        int cur = identityCreationFlowContext.getCurrentPosition();
        int remaining = identityCreationFlowContext.getMaxRemainingSteps();
        this.progressIndicator.setNbStep(cur + remaining + 1);
        this.progressIndicator.setCurrentStep(cur);
    }

    private void updateDroparea(boolean activate) {
        if (activate) {
            this.droparea.onLayoutAttached();
        } else {
            this.droparea.onLayoutDetached();
        }
    }

    private void bindUi() {
        this.sub_text.managedProperty().bind((ObservableValue)this.sub_text.visibleProperty());
        this.sub_text.visibleProperty().bind((ObservableValue)this.sub_text.textProperty().isNotEmpty());
        this.progress_container.getChildren().add((Object)this.progressIndicator.getRoot());
        this.progress_container.managedProperty().bind((ObservableValue)this.progress_container.visibleProperty());
        this.progress_container.visibleProperty().bind((ObservableValue)this.progressIndicator.getRoot().visibleProperty());
        this.hyperlink.managedProperty().bind((ObservableValue)this.hyperlink.visibleProperty());
        this.hyperlink.visibleProperty().bind((ObservableValue)this.hyperlink.textProperty().isNotEmpty());
        this.help_prompt.managedProperty().bind((ObservableValue)this.help_prompt.visibleProperty());
        this.help_prompt.visibleProperty().bind((ObservableValue)this.help_prompt.textProperty().isNotEmpty());
    }

    private void setTextModel(DisplayTextModel displayTextModel) {
        this.model.setHelpPrompt(displayTextModel.helpPrompt());
        this.model.setHyperlinkText(displayTextModel.hyperlinkText());
        this.model.setSubText(displayTextModel.subText());
        this.model.setHyperlinkUri(displayTextModel.hyperlinkUrl());
        this.model.setTitle(displayTextModel.title());
    }

    private void bindText() {
        this.hyperlink.textProperty().bind((ObservableValue)this.bindI18Key(this.model.hyperlinkTextProperty()));
        this.title.textProperty().bind((ObservableValue)this.bindI18Key(this.model.titleProperty()));
        this.help_prompt.textProperty().bind((ObservableValue)this.bindI18Key(this.model.helpPromptProperty()));
        this.sub_text.textProperty().bind((ObservableValue)this.bindI18Key(this.model.subTextProperty()));
        this.hyperlink.onActionProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> {
            if (this.model.getHyperlinkUri() == null) {
                return null;
            }
            return event -> {
                try {
                    AppRuntimeHelper.launchBrowser(ViewControllerHelper.getString(this.model.getHyperlinkUri()));
                }
                catch (IOException | IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
            };
        }, (Observable[])new Observable[]{this.model.hyperlinkUriProperty()}));
    }

    private StringBinding bindI18Key(StringProperty stringProperty) {
        return Bindings.createStringBinding(() -> {
            if (stringProperty.get() == null) {
                return "";
            }
            return ViewControllerHelper.getString((String)stringProperty.get());
        }, (Observable[])new Observable[]{stringProperty});
    }

    @Override
    public Region getLayout() {
        return this.root;
    }

    @Override
    public void onLayoutAttached() {
    }

    @Override
    public void onLayoutDetached() {
    }

    private void handleCloseButton(MouseEvent event) {
        if (event.getButton() != MouseButton.PRIMARY) {
            return;
        }
        this.close();
    }

    private void close() {
        this.model.reset();
        identityCreationFlowContext.clearContext();
        identityCreationFlowContext.pushState(IdentityManagementFlow.IDENTITY_CREATION, IdentityManagementFlow.IdentityCreationState.ON_BOARDING);
        MainStackManager.displayedLayerState.pushState(MainStackManager.DisplayedLayerWrapper.of(MainStackManager.DisplayedLayer.MAIN));
    }

    private void handleBackButton(MouseEvent event) {
        if (event.getButton() != MouseButton.PRIMARY) {
            return;
        }
        if (!identityCreationFlowContext.goToPreviousState()) {
            this.computeAndPushInitialState(false);
        }
    }

    private void computeAndPushInitialState(boolean withKeycloackConfCheck) {
        IdentityManagementFlow newIdMgtFlow = null;
        IdentityManagementFlow.KeycloakState newIdMgtFlowState = null;
        MainStackManager.DisplayedLayerWrapper newLayerState = null;
        if (withKeycloackConfCheck && this.model.keycloakConfigurationUrl() != null && !this.model.keycloakConfigurationUrl().isEmpty()) {
            newIdMgtFlow = IdentityManagementFlow.KEYCLOAK;
            newIdMgtFlowState = IdentityManagementFlow.KeycloakState.KEYCLOAK_CONFIGURATION;
            newLayerState = MainStackManager.DisplayedLayerWrapper.of(MainStackManager.DisplayedLayer.OWNED_IDENTITY_MANAGEMENT);
        }
        if (this.model.isEmptyOwnedIdentities() && newIdMgtFlowState == null) {
            newLayerState = MainStackManager.DisplayedLayerWrapper.of(MainStackManager.DisplayedLayer.OWNED_IDENTITY_MANAGEMENT);
        } else if (newIdMgtFlowState == null) {
            newLayerState = MainStackManager.DisplayedLayerWrapper.of(MainStackManager.DisplayedLayer.MAIN);
        }
        identityCreationFlowContext.pushState(IdentityManagementFlow.IDENTITY_CREATION, IdentityManagementFlow.IdentityCreationState.ON_BOARDING);
        MainStackManager.displayedLayerState.pushState(newLayerState);
    }
}

