/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.main_stack.identity_management_layer.keycloak;

import io.olvid.windows.messenger.keycloak.KeycloakManager;
import io.olvid.windows.messenger.keycloak.pojos.ConfigurationPojo;
import io.olvid.windows.messenger.keycloak.protocol.EnrollementProtocol;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.notification_pattern.NotificationListener;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.TcpMessageNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.TcpServerNC;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class KeycloakModel {
    final StringProperty olvidServerUrl = new SimpleStringProperty();
    final StringProperty identityProviderUrl = new SimpleStringProperty();
    final StringProperty serverClientIdValue = new SimpleStringProperty();
    final StringProperty serverClientSecretValue = new SimpleStringProperty();
    private final BooleanProperty configurationValid = new SimpleBooleanProperty(true);
    private final BooleanProperty authentificationValid = new SimpleBooleanProperty(true);
    private final StringProperty authenticationUrl = new SimpleStringProperty();
    public final StringProperty keycloakProtocolStateLabel = new SimpleStringProperty();
    public final StringProperty errorCodeLabel = new SimpleStringProperty();
    public final StringProperty redirectUserInput = new SimpleStringProperty();
    public final BooleanProperty failed = new SimpleBooleanProperty(false);
    public final BooleanProperty authenticationInProgress = new SimpleBooleanProperty(false);
    public final BooleanProperty manualRedirectInputEnabled = new SimpleBooleanProperty(false);
    NotificationListener<EnrollementProtocol.KeycloakEnrollementOutputNotification> keycloakEnrollementOutputNotificationListener;

    public KeycloakModel(NotificationListener<EnrollementProtocol.KeycloakEnrollementOutputNotification> keycloakEnrollementOutputNotificationListener) {
        AppLogger.d("KeycloakModel::KeycloakModel()");
        this.keycloakEnrollementOutputNotificationListener = keycloakEnrollementOutputNotificationListener;
    }

    public BooleanProperty configurationValidProperty() {
        return this.configurationValid;
    }

    public StringProperty getIdentityProviderUrlProperty() {
        return this.identityProviderUrl;
    }

    public StringProperty getServerClientIdProperty() {
        return this.serverClientIdValue;
    }

    public StringProperty getServerClientSecretProperty() {
        return this.serverClientSecretValue;
    }

    public String getAuthenticationUrl() {
        return (String)this.authenticationUrl.get();
    }

    public void setAuthenticationUrl(String authenticationUrl) {
        this.authenticationUrl.set((Object)authenticationUrl);
    }

    public void setConfigurationValid(boolean configurationValid) {
        this.configurationValid.set(configurationValid);
    }

    public void sendRedirectInput() {
        TcpMessageNotification tcpMessageNotification = new TcpMessageNotification(TcpServerNC.TcpMessageNotificationEnumType.KEYCLOAK_AUTHENTICATION_REDIRECT_URI.messageId, ((String)this.redirectUserInput.get()).trim());
        NCRegistry.getTCPServerNC().postNotification(tcpMessageNotification);
    }

    public void reset() {
        this.olvidServerUrl.setValue("");
        this.identityProviderUrl.setValue("");
        this.serverClientIdValue.setValue("");
        this.serverClientSecretValue.setValue("");
        this.authenticationUrl.setValue("");
        this.configurationValid.set(true);
        this.authentificationValid.set(true);
        this.keycloakProtocolStateLabel.setValue("");
        this.errorCodeLabel.setValue("");
        this.stopEnrollementProtocol();
    }

    public void setConfiguration(ConfigurationPojo configurationKeycloakPojo) {
        this.olvidServerUrl.setValue(configurationKeycloakPojo.getServer());
        this.identityProviderUrl.setValue(configurationKeycloakPojo.getKeycloak().getServer());
        this.serverClientIdValue.setValue(configurationKeycloakPojo.getKeycloak().getClientId());
        this.serverClientSecretValue.setValue(configurationKeycloakPojo.getKeycloak().getClientSecret());
    }

    public void startEnrollementProtocol() {
        KeycloakManager.getInstance().startEnrollementProtocol((String)this.getIdentityProviderUrlProperty().get(), (String)this.getServerClientIdProperty().get(), Optional.ofNullable((String)this.getServerClientSecretProperty().get()), this.keycloakEnrollementOutputNotificationListener);
    }

    public void stopEnrollementProtocol() {
        KeycloakManager.getInstance().stopEnrollementProtocol();
    }
}

