/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.main_stack.identity_management_layer.keycloak;

import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.DisplayTextModel;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.mainflow.IdentityManagementFlowModel;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.TcpMessageNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.TcpServerNC;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class KeycloakManualInputConfiguration
extends BaseViewController {
    public static final DisplayTextModel DISPLAY_TEXT_MODEL = DisplayTextModel.ofOnlyIds(null, null, "on_boarding_flow_keycloak_configuration_link_title", null, null);
    public final IdentityManagementFlowModel identityManagementFlowModel;
    public final VBox root;
    public final Label centerLabel;
    public final TextField input;
    public final Button nextButton;
    public final Label error;

    public KeycloakManualInputConfiguration(IdentityManagementFlowModel identityManagementFlowModel) {
        this.identityManagementFlowModel = identityManagementFlowModel;
        this.root = new VBox();
        this.root.alignmentProperty().set((Object)Pos.CENTER);
        this.centerLabel = new Label(ViewControllerHelper.getString("on_boarding_flow_keycloak_configuration_link"));
        this.centerLabel.getStyleClass().addAll((Object[])new String[]{"body-1", "black-text"});
        VBox.setMargin((Node)this.centerLabel, (Insets)new Insets(40.0, 0.0, 16.0, 0.0));
        this.input = new TextField();
        VBox.setMargin((Node)this.input, (Insets)new Insets(0.0, 0.0, 40.0, 0.0));
        this.input.getStyleClass().addAll((Object[])new String[]{"body-1"});
        this.input.setPromptText(ViewControllerHelper.getString("on_boarding_flow_keycloak_configuration_link_example"));
        SvgSizeable buttonIcon = new SvgSizeable();
        buttonIcon.getStyleClass().addAll((Object[])new String[]{"icon-large", "svg-chevron", "icon-white"});
        this.nextButton = new Button();
        this.nextButton.defaultButtonProperty().set(true);
        this.nextButton.setMnemonicParsing(false);
        this.nextButton.getStyleClass().addAll((Object[])new String[]{"gradient-primary-icon-button"});
        this.nextButton.setGraphic((Node)buttonIcon);
        StackPane buttonContainer = new StackPane();
        buttonContainer.getChildren().add((Object)this.nextButton);
        StackPane.setAlignment((Node)this.nextButton, (Pos)Pos.CENTER_RIGHT);
        this.error = new Label();
        this.error.getStyleClass().addAll((Object[])new String[]{"error-text"});
        this.root.getChildren().addAll((Object[])new Node[]{this.centerLabel, this.input, this.error, buttonContainer});
        this.initialize();
        this.bindSceneProperty();
    }

    public void initialize() {
        this.error.visibleProperty().bind((ObservableValue)this.identityManagementFlowModel.getKeycloakModel().configurationValidProperty().not());
        this.centerLabel.setText(ViewControllerHelper.getString("on_boarding_flow_keycloak_configuration_link"));
        this.input.setPromptText(ViewControllerHelper.getString("on_boarding_flow_keycloak_configuration_link_example"));
        this.error.setText(ViewControllerHelper.getString("on_boarding_flow_keycloak_configuration_error"));
        this.nextButton.setOnAction(event -> {
            TcpMessageNotification tcpMessageNotification = new TcpMessageNotification(TcpServerNC.TcpMessageNotificationEnumType.KEYCLOAK_CONFIGURATION_URI.messageId, this.input.getText().trim());
            NCRegistry.getTCPServerNC().postNotification(tcpMessageNotification);
        });
        this.nextButton.disableProperty().bind((ObservableValue)this.input.textProperty().isEmpty());
    }

    @Override
    public Region getLayout() {
        return this.root;
    }

    @Override
    public void onLayoutAttached() {
        this.input.setText("");
    }

    @Override
    public void onLayoutDetached() {
        this.input.setText("");
    }
}

