/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.main_stack.identity_management_layer.keycloak;

import io.olvid.windows.messenger.fx.custom_components.loader.LoadingScreenController;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.DisplayTextModel;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.mainflow.IdentityManagementFlow;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.mainflow.IdentityManagementFlowModel;
import io.olvid.windows.messenger.keycloak.KeycloakManager;
import io.olvid.windows.messenger.misc.state_pattern.FlowStackContext;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;

public class KeycloakBindingSelectionController
extends BaseViewController {
    public static final DisplayTextModel DISPLAY_TEXT_MODEL = DisplayTextModel.ofOnlyIds("on_boarding_flow_keycloak_binding_title", null, "on_boarding_flow_keycloak_binding_description", null, null);
    private final Pane parent;
    StackPane root = new StackPane();
    public final VBox subContainer = new VBox();
    public final HBox firstLastNameContainer = new HBox();
    public final TextField identityFirstNameValue = new TextField();
    public final TextField identityLastNameValue = new TextField();
    public final HBox positionCompanyContainer = new HBox();
    public final TextField identityCompanyValue = new TextField();
    public final TextField identityPosition = new TextField();
    public final Label bindExplanationLabel = new Label(ViewControllerHelper.getString("on_boarding_flow_keycloak_binding_fusion_explanation"));
    public final VBox ownedIdentitiesListViewContainer = new VBox();
    public final Button bindNewIdentityButton = new Button();
    public final Button selectOwnedIdentityButton = new Button();
    public final Label bindingErrorLabel = new Label();
    public final Label bindingProgressLabel = new Label();
    final IdentityManagementFlowModel identityManagementFlowModel;

    public KeycloakBindingSelectionController(FlowStackContext<IdentityManagementFlow> flowContext, IdentityManagementFlowModel identityManagementFlowModel, Pane parent) {
        this.identityManagementFlowModel = identityManagementFlowModel;
        this.parent = parent;
        VBox detailsContainer = new VBox();
        detailsContainer.setSpacing(16.0);
        this.firstLastNameContainer.setSpacing(16.0);
        this.firstLastNameContainer.getChildren().addAll((Object[])new Node[]{this.identityFirstNameValue, this.identityLastNameValue});
        HBox.setHgrow((Node)this.identityFirstNameValue, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)this.identityLastNameValue, (Priority)Priority.ALWAYS);
        this.positionCompanyContainer.setSpacing(16.0);
        this.positionCompanyContainer.getChildren().addAll((Object[])new Node[]{this.identityPosition, this.identityCompanyValue});
        HBox.setHgrow((Node)this.identityPosition, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)this.identityCompanyValue, (Priority)Priority.ALWAYS);
        detailsContainer.getChildren().addAll((Object[])new Node[]{this.firstLastNameContainer, this.positionCompanyContainer});
        VBox buttonContainer = new VBox();
        buttonContainer.setAlignment(Pos.CENTER);
        buttonContainer.setSpacing(12.0);
        Region sep = new Region();
        this.bindNewIdentityButton.setAlignment(Pos.CENTER);
        this.bindNewIdentityButton.setContentDisplay(ContentDisplay.CENTER);
        this.bindNewIdentityButton.getStyleClass().add((Object)"primary-button");
        this.bindNewIdentityButton.setText(ViewControllerHelper.getString("on_boarding_flow_keycloak_binding_create"));
        this.bindNewIdentityButton.setPadding(new Insets(8.0, 8.0, 8.0, 8.0));
        this.selectOwnedIdentityButton.setAlignment(Pos.CENTER);
        this.selectOwnedIdentityButton.setContentDisplay(ContentDisplay.CENTER);
        this.selectOwnedIdentityButton.getStyleClass().add((Object)"grey-button-1");
        this.selectOwnedIdentityButton.setText(ViewControllerHelper.getString("on_boarding_flow_keycloak_binding_existing"));
        this.selectOwnedIdentityButton.setPadding(new Insets(8.0, 8.0, 8.0, 8.0));
        buttonContainer.getChildren().addAll((Object[])new Node[]{this.bindNewIdentityButton, this.selectOwnedIdentityButton});
        HBox.setHgrow((Node)sep, (Priority)Priority.ALWAYS);
        this.bindExplanationLabel.setTextAlignment(TextAlignment.CENTER);
        this.bindExplanationLabel.getStyleClass().add((Object)"body-1");
        this.bindExplanationLabel.setWrapText(true);
        this.bindingProgressLabel.getStyleClass().add((Object)"body-1");
        this.bindingErrorLabel.getStyleClass().addAll((Object[])new String[]{"error-text"});
        this.subContainer.setAlignment(Pos.CENTER);
        this.subContainer.getChildren().addAll((Object[])new Node[]{detailsContainer, this.bindExplanationLabel, this.bindingProgressLabel, this.bindingErrorLabel, buttonContainer});
        this.subContainer.setSpacing(12.0);
        this.root.getChildren().add((Object)this.subContainer);
        this.root.setMaxHeight(450.0);
        StackPane.setAlignment((Node)this.subContainer, (Pos)Pos.CENTER);
        this.bind();
        this.identityFirstNameValue.setEditable(false);
        this.identityLastNameValue.setEditable(false);
        this.identityCompanyValue.setEditable(false);
        this.identityPosition.setEditable(false);
        this.bindNewIdentityButton.setOnAction(this::bindNewButtonHandler);
        this.selectOwnedIdentityButton.setOnAction(this::selectButtonHandler);
        this.bindSceneProperty();
    }

    private void bind() {
        this.identityFirstNameValue.textProperty().bindBidirectional((Property)this.identityManagementFlowModel.identityFirstNameProperty());
        this.identityLastNameValue.textProperty().bindBidirectional((Property)this.identityManagementFlowModel.identityLastNameProperty());
        this.identityCompanyValue.textProperty().bindBidirectional((Property)this.identityManagementFlowModel.identityCompanyProperty());
        this.identityPosition.textProperty().bindBidirectional((Property)this.identityManagementFlowModel.identityPositionProperty());
        this.bindingProgressLabel.textProperty().bind((ObservableValue)this.identityManagementFlowModel.getKeycloakModel().keycloakProtocolStateLabel);
        this.bindExplanationLabel.managedProperty().bind((ObservableValue)this.bindExplanationLabel.visibleProperty());
        this.bindExplanationLabel.visibleProperty().bind((ObservableValue)Bindings.isNotEmpty((ObservableList)this.ownedIdentitiesListViewContainer.getChildren()));
        this.bindExplanationLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
            String companyNameFromModel = (String)this.identityManagementFlowModel.identityCompanyProperty().get();
            String compagnyNameString = companyNameFromModel == null || companyNameFromModel.isBlank() ? "" : companyNameFromModel;
            return String.format(ViewControllerHelper.getString("on_boarding_flow_keycloak_binding_fusion_explanation"), compagnyNameString);
        }, (Observable[])new Observable[]{this.identityManagementFlowModel.identityCompanyProperty()}));
        this.bindingErrorLabel.textProperty().bind((ObservableValue)this.identityManagementFlowModel.getKeycloakModel().errorCodeLabel);
        this.bindingErrorLabel.visibleProperty().bind((ObservableValue)this.identityManagementFlowModel.getKeycloakModel().failed);
        this.bindNewIdentityButton.minWidthProperty().bind((ObservableValue)this.firstLastNameContainer.widthProperty());
        this.bindNewIdentityButton.setTextAlignment(TextAlignment.CENTER);
        this.selectOwnedIdentityButton.minWidthProperty().bind((ObservableValue)this.firstLastNameContainer.widthProperty());
        this.selectOwnedIdentityButton.setTextAlignment(TextAlignment.CENTER);
    }

    private void unbind() {
        this.identityFirstNameValue.textProperty().unbind();
        this.identityLastNameValue.textProperty().unbind();
        this.identityCompanyValue.textProperty().unbind();
        this.identityPosition.textProperty().unbind();
        this.bindExplanationLabel.textProperty().unbind();
        this.bindingErrorLabel.visibleProperty().unbind();
        this.bindingErrorLabel.textProperty().unbind();
        this.bindingProgressLabel.textProperty().unbind();
    }

    @Override
    public Region getLayout() {
        return this.root;
    }

    @Override
    public void onLayoutAttached() {
        this.bind();
        this.bindNewIdentityButton.setDisable(false);
    }

    @Override
    public void onLayoutDetached() {
        this.unbind();
    }

    private void bindNewButtonHandler(ActionEvent event) {
        this.bindNewIdentityButton.setDisable(true);
        LoadingScreenController.runAsyncTaskWithLoader(() -> KeycloakManager.getInstance().shareIdentityToBind(Optional.empty()), this.parent);
    }

    private void selectButtonHandler(ActionEvent actionEvent) {
        this.identityManagementFlowModel.getFlowContext().pushState(IdentityManagementFlow.KEYCLOAK, IdentityManagementFlow.KeycloakState.KEYCLOAK_SELECT_IDENTITY);
    }
}

