/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.main_stack.identity_management_layer.backup_restoration.subcontroller.legacy;

import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.DisplayTextModel;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.backup_restoration.BackupRestorationViewModel;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.start_up.AppRuntimeHelper;
import java.io.File;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.stage.FileChooser;

public class BackupFileNeededController
extends BaseViewController {
    private final Button uploadButton = new Button(ViewControllerHelper.getString("on_boarding_flow_backup_flow_upload_file"));
    public static final DisplayTextModel DISPLAY_TEXT_MODEL = DisplayTextModel.ofOnlyIds("on_boarding_flow_backup_flow_drag_file", "on_boarding_flow_backup_flow_how_get", null, "on_boarding_flow_backup_flow_know_more", "on_boarding_flow_backup_flow_know_more_url");
    private final BackupRestorationViewModel model;

    public BackupFileNeededController(BackupRestorationViewModel model) {
        this.model = model;
        this.uploadButton.getStyleClass().addAll((Object[])new String[]{"gradient-primary-button", "upload-button"});
        SvgSizeable svg = new SvgSizeable();
        svg.getStyleClass().addAll((Object[])new String[]{"icon-medium", "svg-upload", "icon-white"});
        this.uploadButton.setGraphic((Node)svg);
        this.uploadButton.setGraphicTextGap(14.0);
        this.uploadButton.setContentDisplay(ContentDisplay.RIGHT);
        this.uploadButton.setOnAction(this::selectFile);
        StackPane.setMargin((Node)this.uploadButton, (Insets)new Insets(0.0, 0.0, 40.0, 0.0));
    }

    private void selectFile(ActionEvent event) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(ViewControllerHelper.getString("on_boarding_flow_backup_flow_file_chooser_title"));
        String homePath = AppRuntimeHelper.USER_HOME_DIR_ABSOLUTE_PATH;
        File homeFile = homePath == null ? null : new File(homePath);
        fileChooser.setInitialDirectory(homeFile);
        File backupFile = fileChooser.showOpenDialog(ViewControllerHelper.MAIN_STAGE.getOwner());
        if (backupFile != null && backupFile.exists()) {
            try {
                this.model.setSelectedFile(backupFile);
            }
            catch (Exception e) {
                AppLogger.e("BackupRestorationController::selectBackupFileButtonCLicked Something went wrong opening backup file...", e);
            }
        }
    }

    @Override
    public Region getLayout() {
        return this.uploadButton;
    }

    @Override
    public void onLayoutAttached() {
    }

    @Override
    public void onLayoutDetached() {
    }
}

