/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.main_stack.identity_management_layer.backup_restoration.subcontroller.legacy;

import io.olvid.windows.messenger.fx.custom_components.file.ClosablePreviewContainerController;
import io.olvid.windows.messenger.fx.custom_components.file.FilePreview;
import io.olvid.windows.messenger.fx.custom_components.file.PreviewUtils;
import io.olvid.windows.messenger.fx.framework.annotations.FXMLView;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.DisplayTextModel;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.backup_restoration.BackupRestorationViewModel;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.mainflow.IdentityManagementFlow;
import io.olvid.windows.messenger.misc.state_pattern.FlowStackContext;
import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;

@FXMLView(path="fx/main_stack/identity_management_layer/backup/backup_file.fxml")
public class BackupFileConfirmationController
extends BaseViewController {
    private final BackupRestorationViewModel model;
    @FXML
    private Pane root;
    @FXML
    private Button button_validate;
    @FXML
    private StackPane file_item_container;
    @FXML
    private Node validate_container;
    @FXML
    private Node pane_container;
    public static final DisplayTextModel DISPLAY_TEXT_MODEL = DisplayTextModel.ofOnlyIds("on_boarding_flow_backup_flow_title_take_your_save_key", "on_boarding_flow_backup_flow_how_get_key", null, "on_boarding_flow_backup_flow_know_more", "on_boarding_flow_backup_flow_know_more_url");
    private final ClosablePreviewContainerController closablePreviewContainerController = new ClosablePreviewContainerController();
    private final FilePreview fileItemController;
    private final FlowStackContext<IdentityManagementFlow> context;

    public BackupFileConfirmationController(BackupRestorationViewModel model, FlowStackContext<IdentityManagementFlow> context) {
        this.model = model;
        this.fileItemController = new FilePreview((DoubleExpression)new SimpleDoubleProperty(300.0));
        this.context = context;
        this.fileItemController.actionButton.setVisible(false);
        this.loadFxml();
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        super.initialize(location, resources);
        this.closablePreviewContainerController.setInnerNode((Region)this.fileItemController);
        this.file_item_container.getChildren().add((Object)this.closablePreviewContainerController.getLayout());
        this.updatePreviewData((File)this.model.selectedFileProperty().get());
        this.model.selectedFileProperty().addListener((observable, oldValue, newValue) -> this.updatePreviewData((File)newValue));
        this.closablePreviewContainerController.getCloseButton().setOnAction(event -> {
            this.model.setSelectedFile(null);
            this.context.goToPreviousState();
        });
        this.fileItemController.getStyleClass().add((Object)"file-preview-backup");
        PreviewUtils.setStyleOnNode((Node)this.fileItemController.actionIcon, "icon-medium", "icon-grey");
    }

    private void updatePreviewData(File newValue) {
        if (newValue != null) {
            this.fileItemController.iconAndDescription.title.setText(newValue.getName());
            this.fileItemController.iconAndDescription.setSubtitle(PreviewUtils.convertFileSize(newValue.length()));
            PreviewUtils.setStyleOnNode((Node)this.fileItemController.iconAndDescription.iconSvg, PreviewUtils.getIconStyleClass(PreviewUtils.toFileExtension(newValue)), PreviewUtils.getIconColorStyleClass(PreviewUtils.toFileExtension(newValue)));
            PreviewUtils.setStyleOnNode((Node)this.fileItemController.iconAndDescription.iconCircle, PreviewUtils.getIconCircleStyleClass(PreviewUtils.toFileExtension(newValue)), "icon-circle");
        }
    }

    @Override
    public Region getLayout() {
        return this.root;
    }

    @Override
    public void onLayoutAttached() {
    }

    @Override
    public void onLayoutDetached() {
    }

    public Button getButton_validate() {
        return this.button_validate;
    }
}

