/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.main_stack.identity_management_layer.backup_restoration.subcontroller;

import io.olvid.windows.messenger.fx.custom_components.loader.RingProgressIndicator;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.generic_types.list_view.AbstractListCell;
import io.olvid.windows.messenger.fx.generic_types.list_view.StandardPanelListController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.DisplayTextModel;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.backup_restoration.BackupRestorationViewModel;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.mainflow.IdentityManagementFlow;
import io.olvid.windows.messenger.fx.settings.backups.management.DeviceBackupListCell;
import io.olvid.windows.messenger.livedata.info.backup.DeviceBackupInfo;
import io.olvid.windows.messenger.misc.state_pattern.FlowStackContext;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableIntegerValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;
import javafx.util.Callback;

public class DeviceBackupSelectionViewController
extends BaseViewController {
    public static DisplayTextModel DISPLAY_TEXT_MODEL = DisplayTextModel.ofOnlyIds("on_boarding_select_profile_title_label", null, null, null, null);
    public final Label descriptionLabel = new Label();
    public final VBox rootContainer = new VBox();
    private final StandardPanelListController<DeviceBackupInfo> deviceBackupListViewController;
    public final HBox labelContainer = new HBox();
    public final Label profilNotListedLabel = new Label(ViewControllerHelper.getString("on_boarding_flow_backup_profile_not_listed_label"));
    public final Hyperlink tryAnotherKeyHyperlink = new Hyperlink(ViewControllerHelper.getString("on_boarding_flow_backup_try_another_key_hyperlink"));
    private final BackupRestorationViewModel viewModel;
    private final FlowStackContext<IdentityManagementFlow> mainFlowContext;
    final RingProgressIndicator ringProgressIndicator = new RingProgressIndicator();
    final StackPane ringContainer = new StackPane(new Node[]{this.ringProgressIndicator});
    final StackPane ringOrLoadedList = new StackPane();
    final Hyperlink legacyHyperLink = new Hyperlink();
    final Text errorText = new Text();
    final Hyperlink retryKeyHyperLink = new Hyperlink();
    final Text errorTextP1 = new Text();
    final TextFlow errorTextFlow = new TextFlow();

    public DeviceBackupSelectionViewController(FlowStackContext<IdentityManagementFlow> context, BackupRestorationViewModel model) {
        this.viewModel = model;
        this.mainFlowContext = context;
        this.descriptionLabel.textProperty().bind((ObservableValue)ViewControllerHelper.getString("on_boarding_number_of_profile_found_label", (ObservableIntegerValue)model.deviceBackupCnt));
        this.descriptionLabel.getStyleClass().addAll((Object[])new String[]{"body-1"});
        this.descriptionLabel.setTextAlignment(TextAlignment.CENTER);
        this.descriptionLabel.visibleProperty().bind((ObservableValue)model.dataStateProp.isEqualTo((Object)BackupRestorationViewModel.DataState.LOADED));
        this.errorText.textProperty().bind((ObservableValue)model.errorText);
        this.errorText.setTextAlignment(TextAlignment.CENTER);
        this.errorText.getStyleClass().addAll((Object[])new String[]{"body-1", "danger-text"});
        this.errorTextP1.textProperty().bind((ObservableValue)model.errorTextP1);
        this.errorTextP1.setTextAlignment(TextAlignment.CENTER);
        this.errorTextP1.getStyleClass().addAll((Object[])new String[]{"body-1", "danger-text"});
        this.errorTextP1.visibleProperty().bind((ObservableValue)model.emptyIdentityList);
        this.errorTextP1.managedProperty().bind((ObservableValue)this.errorTextP1.visibleProperty());
        this.legacyHyperLink.textProperty().bind((ObservableValue)model.legacyHyperLinkText);
        this.legacyHyperLink.setOnMouseClicked(event -> {
            context.pushState(IdentityManagementFlow.BACKUP, IdentityManagementFlow.RestoreBackupState.SELECT_FILE);
            this.viewModel.reset();
        });
        this.legacyHyperLink.getStyleClass().addAll((Object[])new String[]{"body-1", "hyperlink-error-text"});
        this.legacyHyperLink.visibleProperty().bind((ObservableValue)model.emptyIdentityList);
        this.legacyHyperLink.managedProperty().bind((ObservableValue)this.legacyHyperLink.visibleProperty());
        this.retryKeyHyperLink.textProperty().bind((ObservableValue)model.retryKeyHyperLinkText);
        this.retryKeyHyperLink.setOnMouseClicked(event -> {
            context.goToPreviousState();
            this.viewModel.reset();
        });
        this.retryKeyHyperLink.getStyleClass().addAll((Object[])new String[]{"body-1", "hyperlink-error-text"});
        this.errorTextFlow.getChildren().addAll((Object[])new Node[]{this.errorText, this.retryKeyHyperLink, this.errorTextP1, this.legacyHyperLink});
        this.errorTextFlow.maxWidthProperty().bind((ObservableValue)this.rootContainer.widthProperty());
        this.errorTextFlow.setTextAlignment(TextAlignment.CENTER);
        this.errorTextFlow.visibleProperty().bind((ObservableValue)model.fetchFailed);
        this.errorTextFlow.managedProperty().bind((ObservableValue)this.errorTextFlow.visibleProperty());
        VBox.setMargin((Node)this.errorText, (Insets)new Insets(12.0, 12.0, 12.0, 12.0));
        this.ringProgressIndicator.getStyleClass().setAll((Object[])new String[]{"sync-progress-indicator", "indeterminate"});
        this.ringProgressIndicator.setProgress(-1);
        this.ringProgressIndicator.setInnerCircleRadius(8);
        this.ringProgressIndicator.setRingWidth(2);
        this.ringContainer.visibleProperty().bind((ObservableValue)model.dataStateProp.isEqualTo((Object)BackupRestorationViewModel.DataState.LOADING));
        this.ringContainer.managedProperty().bind((ObservableValue)this.ringContainer.visibleProperty());
        this.ringContainer.setPadding(new Insets(12.0, 0.0, 24.0, 0.0));
        this.deviceBackupListViewController = StandardPanelListController.builder().withLiveData(model.deviceBackupLiveData).withDataClass(DeviceBackupInfo.class).withCellFactory((Callback<ListView<DeviceBackupInfo>, AbstractListCell<DeviceBackupInfo>>)((Callback)param -> new DeviceBackupListCell(true))).withoutBottomMargin().defaultComparator().noFilter().withoutSearch().withSingleSelection().withDisableUnselect(true).withoutButton((deviceBackupInfo, node) -> {
            model.selectedDeviceBackupInfo.setValue(deviceBackupInfo);
            model.fetchProfileBackupList();
            this.mainFlowContext.pushState(IdentityManagementFlow.BACKUP, IdentityManagementFlow.RestoreBackupState.PROFILE_BACKUP_SELECTION);
        }).build();
        this.deviceBackupListViewController.getListView().prefHeightProperty().bind((ObservableValue)Bindings.size(this.deviceBackupListViewController.getListModel().getList()).multiply(90));
        this.deviceBackupListViewController.getListView().setMaxHeight(500.0);
        this.deviceBackupListViewController.getLayout().visibleProperty().bind((ObservableValue)model.dataStateProp.isEqualTo((Object)BackupRestorationViewModel.DataState.LOADED));
        this.deviceBackupListViewController.getLayout().managedProperty().bind((ObservableValue)this.deviceBackupListViewController.getLayout().visibleProperty());
        this.deviceBackupListViewController.getLayout().setPadding(new Insets(0.0, 0.0, 12.0, 0.0));
        this.deviceBackupListViewController.getLayout().getStyleClass().add((Object)"rounded-background-pane");
        this.ringOrLoadedList.getChildren().addAll((Object[])new Node[]{this.ringContainer, this.deviceBackupListViewController.getLayout()});
        this.ringOrLoadedList.setAlignment(Pos.CENTER);
        this.profilNotListedLabel.getStyleClass().addAll((Object[])new String[]{"body-1", "grey-text"});
        this.tryAnotherKeyHyperlink.getStyleClass().addAll((Object[])new String[]{"body-1-size"});
        this.tryAnotherKeyHyperlink.setOnMouseClicked(event -> this.mainFlowContext.pushState(IdentityManagementFlow.BACKUP, IdentityManagementFlow.RestoreBackupState.ENTER_KEY));
        this.labelContainer.setAlignment(Pos.CENTER);
        this.labelContainer.setSpacing(4.0);
        this.labelContainer.getChildren().addAll((Object[])new Node[]{this.profilNotListedLabel, this.tryAnotherKeyHyperlink});
        Region hSep = new Region();
        Region hSep1 = new Region();
        VBox.setVgrow((Node)hSep, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)hSep1, (Priority)Priority.ALWAYS);
        this.rootContainer.setMaxWidth(525.0);
        this.rootContainer.setSpacing(12.0);
        this.rootContainer.setAlignment(Pos.CENTER);
        this.rootContainer.getChildren().addAll((Object[])new Node[]{this.descriptionLabel, this.ringOrLoadedList, hSep, this.errorTextFlow, hSep1, this.labelContainer});
        this.bindSceneProperty();
    }

    @Override
    public Region getLayout() {
        return this.rootContainer;
    }

    @Override
    public void onLayoutAttached() {
    }

    @Override
    public void onLayoutDetached() {
    }
}

