/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.main_stack.identity_management_layer.backup_restoration;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.configuration.EngineConfiguration;
import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.engine.helpers.helpers.BackupApiHelper;
import io.olvid.windows.messenger.fx.generic_types.DiffUtils;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.mainflow.IdentityManagementFlow;
import io.olvid.windows.messenger.fx.misc.ClipboardDelegate;
import io.olvid.windows.messenger.fx.owned_identities.DeviceInfo;
import io.olvid.windows.messenger.keycloak.KeycloakManager;
import io.olvid.windows.messenger.keycloak.protocol.AbstractProtocol;
import io.olvid.windows.messenger.keycloak.protocol.AuthenticationProtocol;
import io.olvid.windows.messenger.livedata.MutableLiveData;
import io.olvid.windows.messenger.livedata.info.backup.DeviceBackupFetchResult;
import io.olvid.windows.messenger.livedata.info.backup.DeviceBackupInfo;
import io.olvid.windows.messenger.livedata.info.backup.ProfileBackupFetchResult;
import io.olvid.windows.messenger.livedata.info.backup.ProfileBackupsInfo;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.DeviceUtils;
import io.olvid.windows.messenger.misc.Either;
import io.olvid.windows.messenger.misc.notification_pattern.NotificationListener;
import io.olvid.windows.messenger.misc.state_pattern.FlowStackContext;
import io.olvid.windows.messenger.start_up.AppRuntimeHelper;
import java.io.File;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class BackupRestorationViewModel
implements ClipboardDelegate.SingleFile,
NotificationListener<AuthenticationProtocol.KeycloakAuthenticationNotification> {
    private final AppLogger logger = new AppLogger(BackupRestorationViewModel.class);
    private final ObjectProperty<File> selectedFile = new SimpleObjectProperty();
    private final ObjectProperty<byte[]> backupContent = new SimpleObjectProperty();
    private final ObjectProperty<Integer> checkStatus = new SimpleObjectProperty();
    private final BooleanProperty success = new SimpleBooleanProperty(false);
    public final MutableLiveData<List<DeviceBackupInfo>> deviceBackupLiveData = new MutableLiveData(List.of());
    public final MutableLiveData<List<ProfileBackupsInfo>> profileBackupsLiveData = new MutableLiveData(List.of());
    public final ObjectProperty<DeviceBackupFetchResult.FetchStatus> deviceBackupFetchStatus = new SimpleObjectProperty();
    public final ObjectProperty<ProfileBackupFetchResult.FetchStatus> profileBackupFetchStatus = new SimpleObjectProperty();
    public final StringProperty errorText = new SimpleStringProperty();
    public final StringProperty errorTextP1 = new SimpleStringProperty();
    public final StringProperty retryKeyHyperLinkText = new SimpleStringProperty();
    public final StringProperty legacyHyperLinkText = new SimpleStringProperty();
    public final ObjectProperty<DataState> dataStateProp = new SimpleObjectProperty();
    public final StringProperty seedProperty = new SimpleStringProperty(null);
    public final ObjectProperty<DeviceBackupInfo> selectedDeviceBackupInfo = new SimpleObjectProperty(null);
    public final ObjectProperty<ProfileBackupFetchResult> selectedProfileBAckupFetchResult = new SimpleObjectProperty(null);
    public final ObjectProperty<ProfileBackupsInfo> selectedProfileSnapshot = new SimpleObjectProperty();
    public final MutableLiveData<List<DeviceInfo>> selectedProfileSnapshotDeviceList = new MutableLiveData(List.of());
    public final StringProperty redirectInput = new SimpleStringProperty();
    public final BooleanProperty showManualRedirectInput = new SimpleBooleanProperty(false);
    public final BooleanProperty loading = new SimpleBooleanProperty(false);
    public final BooleanProperty fetchFailed = new SimpleBooleanProperty(false);
    private final FlowStackContext<IdentityManagementFlow> identityManagementFlowFlowContext;
    public final IntegerProperty deviceBackupCnt = new SimpleIntegerProperty(0);
    public final IntegerProperty profileBackupCntz = new SimpleIntegerProperty(0);
    public final StringProperty selectedProfileToBackupFirstLastName = new SimpleStringProperty(null);
    public final BooleanProperty emptyIdentityList = new SimpleBooleanProperty(true);
    public Optional<String> serializedAuthState = Optional.empty();
    private Optional<AuthenticationProtocol> authenticationProtocolInstance = Optional.empty();

    public BackupRestorationViewModel(FlowStackContext<IdentityManagementFlow> context, boolean emptyIdentityList) {
        this.identityManagementFlowFlowContext = context;
        this.emptyIdentityList.set(emptyIdentityList);
    }

    public void fetchProfileBackupList() {
        AsyncTaskExecutor.submitTask(() -> {
            ViewControllerHelper.smartUIUpdate(() -> this.dataStateProp.set((Object)DataState.LOADING));
            ProfileBackupFetchResult profileBackupsInfosList = BackupApiHelper.fetchProfileBackupInfo(((DeviceBackupInfo)this.selectedDeviceBackupInfo.get()).ownedIdentityBytes(), ((DeviceBackupInfo)this.selectedDeviceBackupInfo.get()).profileBackupSeed());
            if (!DiffUtils.areContentTheSame(profileBackupsInfosList.profileBackupsInfoList(), (List)this.profileBackupsLiveData.getValue())) {
                this.profileBackupsLiveData.postValue(profileBackupsInfosList.profileBackupsInfoList());
                this.selectedProfileSnapshotDeviceList.postValue(profileBackupsInfosList.deviceList());
            }
            ViewControllerHelper.smartUIUpdate(() -> {
                switch (profileBackupsInfosList.fetchStatus()) {
                    case SUCCESS: {
                        this.fetchFailed.set(false);
                        break;
                    }
                    case NETWORK_ERROR: {
                        this.fetchFailed.set(true);
                        this.errorText.setValue(ViewControllerHelper.getString("on_boarding_flow_backup_network_error_text"));
                        break;
                    }
                    case PERMANENT_ERROR: 
                    case TRUNCATED: {
                        this.fetchFailed.set(true);
                        this.errorText.setValue(ViewControllerHelper.getString("on_boarding_flow_backup_permanent_error_standalone_text"));
                        break;
                    }
                    case ERROR: {
                        this.fetchFailed.set(true);
                        this.errorText.setValue(ViewControllerHelper.getString("backup_fetch_general_error_text"));
                    }
                }
                this.selectedProfileToBackupFirstLastName.set((Object)((DeviceBackupInfo)this.selectedDeviceBackupInfo.get()).identityDetails().formatFirstAndLastName("%f %l", false));
                this.profileBackupFetchStatus.set((Object)profileBackupsInfosList.fetchStatus());
                this.selectedProfileBAckupFetchResult.set((Object)profileBackupsInfosList);
                this.profileBackupCntz.set(profileBackupsInfosList.profileBackupsInfoList().size());
                this.dataStateProp.set((Object)DataState.LOADED);
            });
        });
    }

    public void fetchDeviceBackupList() {
        AsyncTaskExecutor.submitTask(() -> {
            if (this.seedProperty.get() != null) {
                ViewControllerHelper.smartUIUpdate(() -> this.dataStateProp.set((Object)DataState.LOADING));
                DeviceBackupFetchResult deviceBackupFetchResult = BackupApiHelper.fetchDeviceBackupInfos(EngineConfiguration.getInstance().getServerName(), (String)this.seedProperty.get());
                if (!DiffUtils.areContentTheSame((List)this.deviceBackupLiveData.getValue(), deviceBackupFetchResult.deviceBackupInfos())) {
                    this.deviceBackupLiveData.postValue(deviceBackupFetchResult.deviceBackupInfos());
                }
                ViewControllerHelper.smartUIUpdate(() -> {
                    switch (deviceBackupFetchResult.fetchStatus()) {
                        case SUCCESS: {
                            this.fetchFailed.set(false);
                            this.resetErrorText(true);
                            break;
                        }
                        case NETWORK_ERROR: {
                            this.fetchFailed.set(true);
                            this.resetErrorText(false);
                            this.errorText.setValue(ViewControllerHelper.getString("on_boarding_flow_backup_network_error_text"));
                            break;
                        }
                        case PERMANENT_ERROR: {
                            this.fetchFailed.set(true);
                            this.errorText.setValue(ViewControllerHelper.getString("on_boarding_flow_backup_permanent_error_text"));
                            this.errorTextP1.setValue(ViewControllerHelper.getString("on_boarding_flow_backup_permanent_error_1_text"));
                            this.legacyHyperLinkText.setValue(ViewControllerHelper.getString("on_boarding_flow_backup_legacy_file_hyperlink_error_text"));
                            this.retryKeyHyperLinkText.setValue(ViewControllerHelper.getString("on_boarding_flow_backup_retry_key_hyperlink"));
                            break;
                        }
                        case ERROR: {
                            this.fetchFailed.set(true);
                            this.errorText.setValue(ViewControllerHelper.getString("backup_fetch_general_error_text"));
                            this.resetErrorText(false);
                        }
                    }
                    this.deviceBackupFetchStatus.set((Object)deviceBackupFetchResult.fetchStatus());
                    this.deviceBackupCnt.set(deviceBackupFetchResult.deviceBackupInfos().size());
                    this.dataStateProp.set((Object)DataState.LOADED);
                });
            }
        });
    }

    @Override
    public void onReceived(AuthenticationProtocol.KeycloakAuthenticationNotification keycloakAuthenticationNotification) {
        this.logger.info("BackupRestorationViewModel::onReceived receiverd authentication protocol notification --> " + keycloakAuthenticationNotification.getClass().getName());
        AuthenticationProtocol.KeycloakAuthenticationNotification keycloakAuthenticationNotification2 = keycloakAuthenticationNotification;
        Objects.requireNonNull(keycloakAuthenticationNotification2);
        AuthenticationProtocol.KeycloakAuthenticationNotification keycloakAuthenticationNotification3 = keycloakAuthenticationNotification2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AuthenticationProtocol.AuthenticationProtocolFailed.class, AuthenticationProtocol.AuthenticationSuccessNotification.class, AuthenticationProtocol.DiscoveringNotification.class, AuthenticationProtocol.WaitingForAccessTokenNotification.class, AuthenticationProtocol.WaitingForAuthorizationCodeNotification.class}, (Object)keycloakAuthenticationNotification3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                AuthenticationProtocol.AuthenticationProtocolFailed ignored = (AuthenticationProtocol.AuthenticationProtocolFailed)keycloakAuthenticationNotification3;
                break;
            }
            case 1: {
                AuthenticationProtocol.AuthenticationSuccessNotification successNotification = (AuthenticationProtocol.AuthenticationSuccessNotification)keycloakAuthenticationNotification3;
                if (((ProfileBackupFetchResult)this.selectedProfileBAckupFetchResult.get()).multiDevice()) {
                    this.serializedAuthState = successNotification.serializedAuthState();
                    boolean restoreResult = Api.getBackupApi().restoreProfile(((ProfileBackupsInfo)this.selectedProfileSnapshot.get()).snapshot(), DeviceUtils.getSystemDeviceName(), successNotification.serializedAuthState());
                    if (restoreResult) {
                        this.identityManagementFlowFlowContext.pushState(IdentityManagementFlow.BACKUP, IdentityManagementFlow.RestoreBackupState.RESTORE_OTHER_PROFILE_CHOICE);
                        break;
                    }
                    this.logger.error("BackupRestorationViewModel::onReceived authentication success, but restore failed");
                    break;
                }
                this.identityManagementFlowFlowContext.pushState(IdentityManagementFlow.BACKUP, IdentityManagementFlow.RestoreBackupState.WARNING_MULTIDEVICE_LICENSE);
                break;
            }
            case 2: {
                AuthenticationProtocol.DiscoveringNotification ignored = (AuthenticationProtocol.DiscoveringNotification)keycloakAuthenticationNotification3;
                break;
            }
            case 3: {
                AuthenticationProtocol.WaitingForAccessTokenNotification ignored = (AuthenticationProtocol.WaitingForAccessTokenNotification)keycloakAuthenticationNotification3;
                break;
            }
            case 4: {
                AuthenticationProtocol.WaitingForAuthorizationCodeNotification waitingForAuthorizationCodeNotification = (AuthenticationProtocol.WaitingForAuthorizationCodeNotification)keycloakAuthenticationNotification3;
                try {
                    AppRuntimeHelper.launchBrowser(waitingForAuthorizationCodeNotification.authenticationUrl());
                    break;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public File getSelectedFile() {
        return (File)this.selectedFile.get();
    }

    public ObjectProperty<File> selectedFileProperty() {
        return this.selectedFile;
    }

    @Override
    public void importFile(File file) {
        this.setSelectedFile(file);
    }

    public void setSelectedFile(File selectedFile) {
        this.selectedFile.set((Object)selectedFile);
    }

    public ObjectProperty<byte[]> backupContentProperty() {
        return this.backupContent;
    }

    public void setBackupContent(byte[] backupContent) {
        this.backupContent.set((Object)backupContent);
    }

    public Integer getCheckStatus() {
        return (Integer)this.checkStatus.get();
    }

    public ObjectProperty<Integer> checkStatusProperty() {
        return this.checkStatus;
    }

    public void setCheckStatus(int checkStatus) {
        this.checkStatus.set((Object)checkStatus);
    }

    public boolean isSuccess() {
        return this.success.get();
    }

    public BooleanProperty successProperty() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success.set(success);
    }

    public void startAuthenticationProtocol() {
        this.loading.set(true);
        AuthenticationProtocol authenticationProtocol = AuthenticationProtocol.of(((ProfileBackupsInfo)this.selectedProfileSnapshot.get()).keycloakInfoOpt().get().serverUrl(), ((ProfileBackupsInfo)this.selectedProfileSnapshot.get()).keycloakInfoOpt().get().clientId(), ((ProfileBackupsInfo)this.selectedProfileSnapshot.get()).keycloakInfoOpt().get().clientSecret(), KeycloakManager.RedirectType.RESTRICTED, Optional.empty(), Either.right(this));
        authenticationProtocol.start();
        this.authenticationProtocolInstance = Optional.of(authenticationProtocol);
    }

    public void stopAuthenticationProtocol() {
        this.loading.set(false);
        this.authenticationProtocolInstance.ifPresent(AbstractProtocol::stop);
    }

    private void resetErrorText(boolean includeMain) {
        if (includeMain) {
            this.errorText.setValue(null);
        }
        this.errorTextP1.setValue(null);
        this.legacyHyperLinkText.setValue(null);
        this.retryKeyHyperLinkText.setValue(null);
    }

    public void reset() {
        this.selectedFile.set(null);
        this.backupContent.set(null);
        this.checkStatus.set(null);
        this.success.set(false);
        this.fetchFailed.set(false);
        this.errorText.set(null);
        this.errorTextP1.set(null);
        this.retryKeyHyperLinkText.set(null);
        this.legacyHyperLinkText.set(null);
        this.seedProperty.set(null);
        this.stopAuthenticationProtocol();
    }

    public static enum DataState {
        LOADED,
        LOADING,
        ERROR;

    }
}

