/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.main_stack.identity_management_layer;

import io.olvid.windows.messenger.fx.framework.animation.AnimationUtils;
import java.util.ArrayList;
import java.util.List;
import javafx.animation.FillTransition;
import javafx.beans.binding.Bindings;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.util.Duration;

public class ProgressIndicator {
    public static final int SPACING = 4;
    public static final int RECTANGLE_HEIGHT = 4;
    public static final int RECTANGLE_NORMAL_WIDTH = 33;
    public static final Duration ANIMATION_DURATION = Duration.millis((double)300.0);
    public static final int CURRENT_RECTANGLE_WIDTH = 57;
    Color unselect = new Color(0.9372549019607843, 0.9450980392156862, 0.9764705882352941, 1.0);
    Color select = new Color(0.0, 0.0, 0.0, 1.0);
    HBox root = new HBox();
    ObservableList<Rectangle> rectangleList = FXCollections.observableArrayList();
    IntegerProperty currentStep = new SimpleIntegerProperty(-1);
    IntegerProperty nbStep = new SimpleIntegerProperty(-1);

    public ProgressIndicator(int nb, int step) {
        this.root.setSpacing(4.0);
        this.root.setAlignment(Pos.CENTER);
        Bindings.bindContent((List)this.root.getChildren(), this.rectangleList);
        this.bind();
        for (int i = 0; i < nb; ++i) {
            Rectangle rectangle = new Rectangle(33.0, 4.0);
            rectangle.setFill((Paint)this.unselect);
            rectangle.getStyleClass().add((Object)"progress-indicator");
            this.rectangleList.add((Object)rectangle);
        }
        this.currentStep.set(step);
        this.nbStep.set(nb);
    }

    public ProgressIndicator() {
        this.root.setSpacing(4.0);
        this.root.setAlignment(Pos.CENTER);
        Bindings.bindContent((List)this.root.getChildren(), this.rectangleList);
        this.bind();
        this.currentStep.set(-1);
        this.nbStep.set(-1);
    }

    private void bind() {
        this.currentStep.addListener((observable, oldValue, newValue) -> {
            AnimationUtils.SizeTransition sizeTransition;
            FillTransition fillTransition;
            Rectangle rectangle;
            if (newValue.intValue() >= 0 && newValue.intValue() < this.root.getChildren().size()) {
                rectangle = (Rectangle)this.rectangleList.get(newValue.intValue());
                fillTransition = new FillTransition(ANIMATION_DURATION);
                fillTransition.setFromValue(this.unselect);
                fillTransition.setToValue(this.select);
                fillTransition.setShape((Shape)rectangle);
                fillTransition.play();
                sizeTransition = new AnimationUtils.SizeTransition(ANIMATION_DURATION, 33.0, 57.0, rectangle);
                sizeTransition.play();
            }
            if (oldValue.intValue() >= 0 && oldValue.intValue() < this.root.getChildren().size()) {
                rectangle = (Rectangle)this.rectangleList.get(oldValue.intValue());
                fillTransition = new FillTransition(ANIMATION_DURATION);
                fillTransition.setFromValue(this.select);
                fillTransition.setToValue(this.unselect);
                fillTransition.setShape((Shape)rectangle);
                fillTransition.play();
                sizeTransition = new AnimationUtils.SizeTransition(ANIMATION_DURATION, 57.0, 33.0, rectangle);
                sizeTransition.play();
            }
        });
        this.nbStep.addListener((observable, oldValue, newValue) -> {
            if (newValue.intValue() >= 0 && newValue.intValue() < this.root.getChildren().size()) {
                ArrayList<Rectangle> toRemove = new ArrayList<Rectangle>();
                for (int i = newValue.intValue(); i < this.rectangleList.size(); ++i) {
                    toRemove.add((Rectangle)this.rectangleList.get(i));
                }
                toRemove.forEach(it -> {
                    AnimationUtils.SizeTransition sizeTransition = new AnimationUtils.SizeTransition(ANIMATION_DURATION, it.getWidth(), 0.0, (Rectangle)it);
                    sizeTransition.setOnFinished(event -> this.rectangleList.remove(it));
                    sizeTransition.play();
                });
            }
            if (newValue.intValue() >= 0 && newValue.intValue() > this.root.getChildren().size()) {
                for (int i = this.root.getChildren().size(); i < newValue.intValue(); ++i) {
                    Rectangle rectangle = new Rectangle(0.0, 4.0);
                    AnimationUtils.SizeTransition sizeTransition = new AnimationUtils.SizeTransition(ANIMATION_DURATION, 0.0, 33.0, rectangle);
                    rectangle.setFill((Paint)this.unselect);
                    rectangle.getStyleClass().add((Object)"progress-indicator");
                    this.rectangleList.add((Object)rectangle);
                    sizeTransition.play();
                }
            }
        });
        this.root.managedProperty().bind((ObservableValue)this.root.visibleProperty());
        this.root.visibleProperty().bind((ObservableValue)this.nbStep.greaterThan(0));
    }

    public Node getRoot() {
        return this.root;
    }

    public void setCurrentStep(int currentStep) {
        this.currentStep.set(currentStep);
    }

    public void setNbStep(int nbStep) {
        this.nbStep.set(nbStep);
    }
}

