/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.invitations;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Invitation;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.gen.InvitationGenerated;
import io.olvid.windows.messenger.engine.helpers.discussion.DiscussionApi;
import io.olvid.windows.messenger.engine.helpers.invitations.InvitationApi;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.cache.DbCache;
import io.olvid.windows.messenger.livedata.info.IdentityDetailsInfo;
import io.olvid.windows.messenger.livedata.mediator.ContactInfoLiveData;
import io.olvid.windows.messenger.logger.AppLogger;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.TextField;

public class InvitationListCell
extends ListCell<Invitation> {
    Invitation invitation = null;
    @FXML
    Node invitation_view_pending_cell;
    @FXML
    Label invitation_view_pending_cell_contact_name;
    @FXML
    Button invitation_view_pending_cell_no_button;
    @FXML
    Button invitation_view_pending_cell_ok_button;
    @FXML
    Node invitation_view_sas_cell;
    @FXML
    Label invitation_view_sas_cell_contact_name;
    @FXML
    TextField invitation_view_sas_cell_sas_display;
    @FXML
    TextField invitation_view_sas_cell_sas_input;
    @FXML
    Button invitation_view_sas_cell_submit_button;
    private final LiveDataListener<ContactInfoLiveData.ContactInfoState> identityInfoChangeListener = this::identityInfoChangeListener;

    public InvitationListCell() {
        FXMLLoader obv_mFxmlLoader_pending = ViewControllerHelper.buildFXMLLoader("fx/invitation/invitation_view_pending_cell.fxml");
        ViewControllerHelper.loadWithExplicitLoader(obv_mFxmlLoader_pending, (Object)this, "fx/invitation/invitation_view_pending_cell.fxml");
        FXMLLoader obv_mFxmlLoader_sas = ViewControllerHelper.buildFXMLLoader("fx/invitation/invitation_view_sas_cell.fxml");
        ViewControllerHelper.loadWithExplicitLoader(obv_mFxmlLoader_sas, (Object)this, "fx/invitation/invitation_view_sas_cell.fxml");
    }

    protected void updateItem(Invitation invitation, boolean empty) {
        super.updateItem((Object)invitation, empty);
        this.invitation = invitation;
        this.updateItemTask(invitation, empty);
    }

    private void updateItemTask(Invitation invitation, boolean empty) {
        this.setStyle("-fx-background-color: white");
        if (empty) {
            this.setGraphic(null);
            return;
        }
        String name = DiscussionApi.computeTitle(invitation.getDiscussion());
        OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(invitation.getOwnedIdentityId());
        if (invitation.getState() == InvitationGenerated.State.INVITATION_WAIT_IT_TO_ACCEPT || invitation.getState() == InvitationGenerated.State.INVITATION_WAIT_YOU_TO_ACCEPT || invitation.getState() == InvitationGenerated.State.INVITATION_STATUS_IN_PROGRESS) {
            this.invitation_view_pending_cell_contact_name.setText(name);
            if (invitation.getState() == InvitationGenerated.State.INVITATION_WAIT_YOU_TO_ACCEPT) {
                this.invitation_view_pending_cell_ok_button.setVisible(true);
                this.invitation_view_pending_cell_no_button.setVisible(true);
                this.invitation_view_pending_cell_ok_button.setText("Accept");
                this.invitation_view_pending_cell_no_button.setText("Decline");
                this.invitation_view_pending_cell_ok_button.setOnMouseClicked(event -> InvitationApi.answerInvitation(invitation, true, ownedIdentity.getBytesOwnedIdentity()));
                this.invitation_view_pending_cell_no_button.setOnMouseClicked(event -> InvitationApi.answerInvitation(invitation, false, ownedIdentity.getBytesOwnedIdentity()));
            } else if (invitation.getState() == InvitationGenerated.State.INVITATION_WAIT_IT_TO_ACCEPT || invitation.getState() == InvitationGenerated.State.INVITATION_STATUS_IN_PROGRESS) {
                this.invitation_view_pending_cell_ok_button.setVisible(false);
                this.invitation_view_pending_cell_no_button.setVisible(false);
                if (invitation.getState() == InvitationGenerated.State.INVITATION_WAIT_IT_TO_ACCEPT) {
                    this.invitation_view_pending_cell_contact_name.setText(this.invitation_view_pending_cell_contact_name.getText() + " Waiting For Acceptation");
                } else if (invitation.getState() == InvitationGenerated.State.INVITATION_STATUS_IN_PROGRESS) {
                    this.invitation_view_pending_cell_contact_name.setText(this.invitation_view_pending_cell_contact_name.getText() + " Protocol in progress");
                }
            }
            this.setGraphic(this.invitation_view_pending_cell);
        } else if (invitation.getState() == InvitationGenerated.State.INVITATION_WAIT_YOU_FOR_SAS_EXCHANGE || invitation.getState() == InvitationGenerated.State.INVITATION_WAIT_IT_FOR_SAS_EXCHANGE) {
            this.invitation_view_sas_cell_contact_name.setText(name);
            this.invitation_view_sas_cell_sas_display.setText(new String(invitation.getSasToDisplay().orElse(new byte[0]), StandardCharsets.UTF_8));
            if (invitation.getState() == InvitationGenerated.State.INVITATION_WAIT_YOU_FOR_SAS_EXCHANGE) {
                this.invitation_view_sas_cell_submit_button.setVisible(true);
                this.invitation_view_sas_cell_sas_input.setVisible(true);
                if (this.invitation_view_sas_cell_submit_button.getOnMouseClicked() == null) {
                    this.invitation_view_sas_cell_submit_button.setOnMouseClicked(event -> this.submitSasButtonHandler(ownedIdentity.getBytesOwnedIdentity()));
                }
            } else if (invitation.getState() == InvitationGenerated.State.INVITATION_WAIT_IT_FOR_SAS_EXCHANGE) {
                this.invitation_view_sas_cell_submit_button.setVisible(false);
                this.invitation_view_sas_cell_sas_input.setVisible(false);
            }
            this.setGraphic(this.invitation_view_sas_cell);
        } else if (invitation.getState() == InvitationGenerated.State.INTRODUCTION_WAIT_IT_TO_ACCEPT || invitation.getState() == InvitationGenerated.State.INTRODUCTION_WAIT_YOU_TO_ACCEPT) {
            if (invitation.getMediatorRef().isPresent()) {
                DbCache.getInstance().contactRefInfoMapLiveData.addListener((Id<ContactRef>)invitation.getMediatorRef().get().getItemId(), this.identityInfoChangeListener);
            }
            if (invitation.getState() == InvitationGenerated.State.INTRODUCTION_WAIT_YOU_TO_ACCEPT) {
                this.invitation_view_pending_cell_ok_button.setVisible(true);
                this.invitation_view_pending_cell_no_button.setVisible(true);
                this.invitation_view_pending_cell_ok_button.setText("Accept");
                this.invitation_view_pending_cell_no_button.setText("Decline");
                this.invitation_view_pending_cell_ok_button.setOnMouseClicked(event -> InvitationApi.answerIntroduction(invitation, true, ownedIdentity.getBytesOwnedIdentity()));
                this.invitation_view_pending_cell_no_button.setOnMouseClicked(event -> InvitationApi.answerIntroduction(invitation, false, ownedIdentity.getBytesOwnedIdentity()));
            } else {
                this.invitation_view_pending_cell_contact_name.setText(name);
                this.invitation_view_pending_cell_ok_button.setVisible(true);
                this.invitation_view_pending_cell_ok_button.setText("Wait it to accept");
                this.invitation_view_pending_cell_ok_button.setOnMouseClicked(event -> {
                    AppLogger.e("Deleting introduction");
                    InvitationApi.abortProtocol(invitation, ownedIdentity.getBytesOwnedIdentity());
                });
                this.invitation_view_pending_cell_no_button.setVisible(false);
            }
            this.setGraphic(this.invitation_view_pending_cell);
        }
    }

    private void identityInfoChangeListener(ContactInfoLiveData.ContactInfoState newValue, ContactInfoLiveData.ContactInfoState oldValue) {
        if (newValue.equals(oldValue)) {
            return;
        }
        String mediatorName = newValue.toOptional().map(info -> info.getCustomOrDisplayName(IdentityDetailsInfo.Format.FIRST_LAST_POSITION_COMPANY)).orElse(ViewControllerHelper.getString("deleted_contact"));
        String name = DiscussionApi.computeTitle(this.invitation.getDiscussion());
        MessageFormat messageFormat = new MessageFormat(ViewControllerHelper.getString("invitation_introduce_by"));
        String message = messageFormat.format(new String[]{name, mediatorName});
        ViewControllerHelper.smartUIUpdate(() -> this.invitation_view_pending_cell_contact_name.setText(message));
    }

    private void submitSasButtonHandler(byte[] ownedIdentityBytes) {
        if (!InvitationApi.submitSas(this.invitation, this.invitation_view_sas_cell_sas_input.getText(), ownedIdentityBytes)) {
            this.invitation_view_sas_cell_sas_input.setText("");
        }
    }
}

