/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.helpers;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.fx.framework.annotations.FXMLView;
import io.olvid.windows.messenger.fx.misc.UIUpdater;
import io.olvid.windows.messenger.logger.AppLogger;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableIntegerValue;
import javafx.beans.value.ObservableStringValue;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;

public class ViewControllerHelper {
    public static Stage MAIN_STAGE;
    public static final Locale EN_LOCALE;
    public static final ResourceBundle RESOURCE_BUNDLE;
    private static final UIUpdater uiUpdater;
    private static final ObjectMapper jsonObjectMapper;

    public static ObjectMapper getJsonObjectMapper() {
        return jsonObjectMapper;
    }

    private static ResourceBundle loadResourceBundle() {
        ResourceBundle resourceBundle;
        try {
            resourceBundle = ResourceBundle.getBundle("tr.langBundle", Locale.getDefault());
        }
        catch (Exception ex) {
            resourceBundle = ResourceBundle.getBundle("tr.langBundle", EN_LOCALE);
        }
        return resourceBundle;
    }

    public static Pane load(String fxmlFile) {
        try {
            URL fxmlFileURL = ViewControllerHelper.class.getClassLoader().getResource(fxmlFile);
            if (fxmlFileURL != null) {
                return (Pane)FXMLLoader.load((URL)fxmlFileURL, (ResourceBundle)RESOURCE_BUNDLE);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }

    public static Node loadAnnotatedController(Initializable controller) {
        return ViewControllerHelper.loadNodeWithExplicitController(controller, ViewControllerHelper.getFxmlPathFromAnnotation(controller));
    }

    private static String getFxmlPathFromAnnotation(Initializable controller) {
        if (controller.getClass().isAnnotationPresent(FXMLView.class)) {
            return controller.getClass().getAnnotation(FXMLView.class).path();
        }
        AppLogger.w("Can't find annotation to get associated fxml path....class in fault : " + controller.getClass().getSimpleName());
        return null;
    }

    public static Region loadNodeWithExplicitController(Object controller, String fxmlFile) {
        try {
            URL fxmlFileURL = ViewControllerHelper.class.getClassLoader().getResource(fxmlFile);
            if (fxmlFileURL != null) {
                FXMLLoader loader = new FXMLLoader();
                loader.setLocation(fxmlFileURL);
                loader.setResources(RESOURCE_BUNDLE);
                loader.setController(controller);
                return (Region)loader.load();
            }
            AppLogger.e("ViewControllerHelper: loadNodeWithExplicitController: unable to find resource", new Exception());
            return null;
        }
        catch (Exception e) {
            AppLogger.e("ViewControllerHelper: loadNodeWithExplicitController: unable to load node", e);
            return null;
        }
    }

    public static Node loadNodeWithExplicitRoot(Object controller, String fxmlFile) {
        try {
            URL fxmlFileURL = ViewControllerHelper.class.getClassLoader().getResource(fxmlFile);
            if (fxmlFileURL != null) {
                FXMLLoader loader = new FXMLLoader();
                loader.setLocation(fxmlFileURL);
                loader.setResources(RESOURCE_BUNDLE);
                loader.setController(controller);
                loader.setRoot(controller);
                return (Node)loader.load();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }

    public static synchronized void setMainStage(Stage primaryStage) {
        if (primaryStage != null && MAIN_STAGE == null) {
            MAIN_STAGE = primaryStage;
        }
    }

    public static UIUpdater getUiUpdater() {
        return uiUpdater;
    }

    public static void smartUIUpdate(Runnable event) {
        if (DbManager.isOnUIThread()) {
            event.run();
        } else {
            Platform.runLater((Runnable)event);
        }
    }

    public static Pane loadWithImplicitLoader(Object controller, String fxmlFile) {
        URL fxmlFileURL = ViewControllerHelper.class.getClassLoader().getResource(fxmlFile);
        FXMLLoader loader = new FXMLLoader(fxmlFileURL, RESOURCE_BUNDLE);
        loader.setController(controller);
        try {
            return (Pane)loader.load();
        }
        catch (IOException e) {
            AppLogger.e("ViewControllerHelper: loadWithImplicitLoader: unable to load pane");
            return null;
        }
    }

    public static void loadWithExplicitLoader(FXMLLoader loader, Object controller, String fxmlFile) {
        URL fxmlFileURL = ViewControllerHelper.class.getClassLoader().getResource(fxmlFile);
        if (loader == null) {
            FXMLLoader loaderLocal = new FXMLLoader(fxmlFileURL, RESOURCE_BUNDLE);
            try {
                loaderLocal.load();
            }
            catch (IOException e) {
                AppLogger.e("ViewControllerHelper: loadWithExplicitLoader: unable load");
            }
        } else {
            loader.setController(controller);
            try {
                loader.load();
            }
            catch (IOException e) {
                AppLogger.e("ViewControllerHelper: loadWithExplicitLoader: unable to set controller");
            }
        }
    }

    public static void setNodeAnchorPaneAttributes(Node node, Double top, Double right, Double bottom, Double left) {
        if (bottom != null) {
            AnchorPane.setBottomAnchor((Node)node, (Double)bottom);
        }
        if (left != null) {
            AnchorPane.setLeftAnchor((Node)node, (Double)left);
        }
        if (right != null) {
            AnchorPane.setRightAnchor((Node)node, (Double)right);
        }
        if (top != null) {
            AnchorPane.setTopAnchor((Node)node, (Double)top);
        }
    }

    public static void clipChildren(Region region) {
        Rectangle outputClip = new Rectangle();
        outputClip.setWidth(region.getWidth());
        outputClip.setHeight(region.getHeight());
        region.setClip((Node)outputClip);
        region.layoutBoundsProperty().addListener((ov, oldValue, newValue) -> {
            outputClip.setWidth(newValue.getWidth());
            outputClip.setHeight(newValue.getHeight());
        });
    }

    public static void attachNodeToAnchorPane(Node child, Pane parent) {
        if (child == null || parent == null) {
            throw new IllegalArgumentException("invalid params : attachNodeToAnchorPane");
        }
        AnchorPane.setBottomAnchor((Node)child, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)child, (Double)0.0);
        AnchorPane.setRightAnchor((Node)child, (Double)0.0);
        AnchorPane.setTopAnchor((Node)child, (Double)0.0);
        parent.getChildren().add((Object)child);
    }

    public static void detachNodeFromAnchorPane(Node child, Pane parent) {
        if (child == null || parent == null) {
            throw new IllegalArgumentException("invalid params : attachNodeToAnchorPane");
        }
        parent.getChildren().remove((Object)child);
    }

    public static FXMLLoader buildFXMLLoader(String pathToFxml) {
        URL fxmlUrl = ViewControllerHelper.class.getClassLoader().getResource(pathToFxml);
        return new FXMLLoader(fxmlUrl, RESOURCE_BUNDLE);
    }

    public static void setManagedAndVisible(Node node, boolean value) {
        ViewControllerHelper.checkUIThread();
        node.setManaged(value);
        node.setVisible(value);
    }

    public static void hideNode(Node node) {
        ViewControllerHelper.setManagedAndVisible(node, false);
    }

    public static void showNode(Node node) {
        ViewControllerHelper.setManagedAndVisible(node, true);
    }

    public static String getString(String key) {
        return RESOURCE_BUNDLE.getString(key).replace("\n", System.lineSeparator());
    }

    public static String getString(String key, Object ... args) {
        String string = RESOURCE_BUNDLE.getString(key).replace("\n", System.lineSeparator());
        return MessageFormat.format(string, args);
    }

    public static ObservableStringValue getString(String key, ObservableStringValue property1) {
        return Bindings.createStringBinding(() -> {
            String string = RESOURCE_BUNDLE.getString(key).replace("\n", System.lineSeparator());
            return MessageFormat.format(string, property1.getValue());
        }, (Observable[])new Observable[]{property1});
    }

    public static ObservableStringValue getString(String key, ObservableStringValue property1, ObservableStringValue property2) {
        return Bindings.createStringBinding(() -> {
            String string = RESOURCE_BUNDLE.getString(key).replace("\n", System.lineSeparator());
            return MessageFormat.format(string, property1.getValue(), property2.getValue());
        }, (Observable[])new Observable[]{property1, property2});
    }

    public static ObservableStringValue getString(String key, ObservableIntegerValue property1) {
        return Bindings.createStringBinding(() -> {
            String string = RESOURCE_BUNDLE.getString(key).replace("\n", System.lineSeparator());
            return MessageFormat.format(string, property1.getValue());
        }, (Observable[])new Observable[]{property1});
    }

    public static void checkUIThread() {
        if (!DbManager.isOnUIThread()) {
            AppLogger.e("This thread should be on UI Thread....don't do that ");
        }
    }

    public static void checkNotUIThread() {
        if (DbManager.isOnUIThread()) {
            AppLogger.e("This thread should not be on UI Thread....don't do that ");
        }
    }

    static {
        EN_LOCALE = new Locale("en", "US");
        RESOURCE_BUNDLE = ViewControllerHelper.loadResourceBundle();
        uiUpdater = new UIUpdater();
        jsonObjectMapper = new ObjectMapper();
    }
}

