/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.helpers;

import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.modal.ModalConfiguration;
import java.util.function.Function;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.scene.Node;
import javafx.scene.layout.Pane;

public class SizeObserver {
    public static ReadOnlyDoubleProperty stageHeight = ViewControllerHelper.MAIN_STAGE.heightProperty();
    public static ReadOnlyDoubleProperty stageWidth = ViewControllerHelper.MAIN_STAGE.widthProperty();
    private static SimpleDoubleProperty smallModalHeight = new SimpleDoubleProperty(SizeObserver.computeSmallModalHeight(ViewControllerHelper.MAIN_STAGE.getHeight()));
    private static SimpleDoubleProperty smallModalWidth = new SimpleDoubleProperty(SizeObserver.computeSmallModalWidth(ViewControllerHelper.MAIN_STAGE.getWidth()));
    private static SimpleDoubleProperty mediumModalHeight = new SimpleDoubleProperty(SizeObserver.computeMediumModalHeight(ViewControllerHelper.MAIN_STAGE.getHeight()));
    private static SimpleDoubleProperty mediumModalWidth = new SimpleDoubleProperty(SizeObserver.computeMediumModalWidth(ViewControllerHelper.MAIN_STAGE.getWidth()));
    private static SimpleDoubleProperty bigModalHeight = new SimpleDoubleProperty(SizeObserver.computeBigModalHeight(ViewControllerHelper.MAIN_STAGE.getHeight()));
    private static SimpleDoubleProperty bigModalWidth = new SimpleDoubleProperty(SizeObserver.computeBigModalWidth(ViewControllerHelper.MAIN_STAGE.getWidth()));

    private static double computeSmallModalHeight(double stageHeight) {
        return Math.max(stageHeight * 3.0 / 5.0, 400.0);
    }

    private static double computeSmallModalWidth(double stageWidth) {
        return Math.max(stageWidth * 1.0 / 4.0, 300.0);
    }

    private static double computeMediumModalHeight(double stageHeight) {
        return Math.max(stageHeight * 3.0 / 5.0, 400.0);
    }

    private static double computeMediumModalWidth(double stageWidth) {
        return Math.max(stageWidth * 1.0 / 4.0, 400.0);
    }

    private static double computeBigModalHeight(double stageHeight) {
        return Math.max(stageHeight * 4.0 / 5.0, 500.0);
    }

    private static double computeBigModalWidth(double stageWidth) {
        return Math.max(stageWidth * 1.0 / 2.0, 400.0);
    }

    public static ReadOnlyDoubleProperty getSmallModalHeight() {
        return smallModalHeight;
    }

    public static ReadOnlyDoubleProperty getSmallModalWidth() {
        return smallModalWidth;
    }

    public static ReadOnlyDoubleProperty getMediumModalHeight() {
        return mediumModalHeight;
    }

    public static ReadOnlyDoubleProperty getMediumModalWidth() {
        return mediumModalWidth;
    }

    public static ReadOnlyDoubleProperty getBigModalHeight() {
        return bigModalHeight;
    }

    public static ReadOnlyDoubleProperty getBigModalWidth() {
        return bigModalWidth;
    }

    public static SimpleDoubleProperty getModalHeight(ModalConfiguration.ModalSize size) {
        switch (size) {
            case SMALL: {
                return smallModalHeight;
            }
            case MEDIUM: {
                return mediumModalHeight;
            }
            case BIG: {
                return bigModalHeight;
            }
        }
        return null;
    }

    public static SimpleDoubleProperty getModalWidth(ModalConfiguration.ModalSize size) {
        switch (size) {
            case SMALL: {
                return smallModalWidth;
            }
            case MEDIUM: {
                return mediumModalWidth;
            }
            case BIG: {
                return bigModalWidth;
            }
        }
        return null;
    }

    public static ReadOnlyDoubleProperty getObservableSizePercent(ReadOnlyDoubleProperty originalProperty, int percent) {
        SimpleDoubleProperty property = new SimpleDoubleProperty(originalProperty.getValue() * (double)percent / 100.0);
        originalProperty.addListener((observable, oldValue, newValue) -> property.set(originalProperty.getValue() * (double)percent / 100.0));
        return property;
    }

    public static ReadOnlyDoubleProperty getObservableSizePercentWithMin(ReadOnlyDoubleProperty originalProperty, int percent, double min) {
        SimpleDoubleProperty property = new SimpleDoubleProperty(Math.max(originalProperty.getValue() * (double)percent / 100.0, min));
        originalProperty.addListener((observable, oldValue, newValue) -> property.set(Math.max(originalProperty.getValue() * (double)percent / 100.0, min)));
        return property;
    }

    public static ReadOnlyDoubleProperty getObservableSizePercentWithMax(ReadOnlyDoubleProperty originalProperty, int percent, double max) {
        SimpleDoubleProperty property = new SimpleDoubleProperty(Math.min(originalProperty.getValue() * (double)percent / 100.0, max));
        originalProperty.addListener((observable, oldValue, newValue) -> property.set(Math.min(originalProperty.getValue() * (double)percent / 100.0, max)));
        return property;
    }

    public static ReadOnlyDoubleProperty getObservableSizePercentWithMinAndMax(ReadOnlyDoubleProperty originalProperty, int percent, double min, double max) {
        SimpleDoubleProperty property = new SimpleDoubleProperty(Math.min(Math.max(originalProperty.getValue() * (double)percent / 100.0, min), max));
        originalProperty.addListener((observable, oldValue, newValue) -> property.set(Math.min(Math.max(originalProperty.getValue() * (double)percent / 100.0, min), max)));
        return property;
    }

    public static ReadOnlyDoubleProperty getCustomObservableSizeWithMinAndMax(ReadOnlyDoubleProperty originalProperty, Function<Double, Double> transformationFunc, double min, double max) {
        SimpleDoubleProperty property = new SimpleDoubleProperty(Math.min(Math.max(transformationFunc.apply(originalProperty.getValue()), min), max));
        originalProperty.addListener((observable, oldValue, newValue) -> property.set(Math.min(Math.max((Double)transformationFunc.apply(originalProperty.getValue()), min), max)));
        return property;
    }

    public static ReadOnlyDoubleProperty getObservableSumHeightOfChildren(Pane pane) {
        SimpleDoubleProperty property = new SimpleDoubleProperty();
        for (Node children : pane.getChildren()) {
            property.add((ObservableNumberValue)children.getScene().heightProperty());
        }
        return property;
    }

    static {
        stageHeight.addListener((observable, oldValue, newValue) -> {
            smallModalHeight.set(SizeObserver.computeSmallModalHeight((Double)newValue));
            mediumModalHeight.set(SizeObserver.computeMediumModalHeight((Double)newValue));
            bigModalHeight.set(SizeObserver.computeBigModalHeight((Double)newValue));
        });
        stageWidth.addListener((observable, oldValue, newValue) -> {
            smallModalWidth.set(SizeObserver.computeSmallModalWidth((Double)newValue));
            mediumModalWidth.set(SizeObserver.computeMediumModalWidth((Double)newValue));
            bigModalWidth.set(SizeObserver.computeBigModalWidth((Double)newValue));
        });
    }
}

