/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.helpers;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Invitation;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.PreContact;
import io.olvid.windows.messenger.database.tables.gen.InvitationGenerated;
import io.olvid.windows.messenger.engine.helpers.invitations.InvitationApi;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.livedata.cache.DbCache;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import io.olvid.windows.messenger.logger.AppLogger;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class AutoInvitationHelper {
    private static AutoInvitationHelper instance = null;
    LiveData<List<Invitation>> invitationLiveData = LiveDataFactory.buildDbLiveDataList(Invitation.class, () -> DbManager.getInstance().getInvitationDao().getAllSortedByIndex());

    private AutoInvitationHelper() {
    }

    public static synchronized AutoInvitationHelper getInstance() {
        if (instance == null) {
            instance = new AutoInvitationHelper();
        }
        return instance;
    }

    public void startAutoInvitation() {
        this.invitationLiveData.addListener(this::onChange);
        AppLogger.d("Started AutoInvitationHelper process");
    }

    public void stopAutoInvitation() {
        this.invitationLiveData.removeListener(this::onChange);
        AppLogger.d("Stopped AutoInvitationHelper process");
    }

    public void inviteEveryOtherIdentities() {
        AsyncTaskExecutor.submitTask(() -> {
            List<OwnedIdentityInfo> ownedIdentities = DbCache.getInstance().ownedIdentitiesInfo.getValue();
            LinkedList<CallSite> alreadySentInvitations = new LinkedList<CallSite>();
            if (ownedIdentities == null) {
                return;
            }
            for (OwnedIdentityInfo ownedIdentity : ownedIdentities) {
                for (OwnedIdentityInfo contactOwnedIdentity : ownedIdentities) {
                    if (alreadySentInvitations.contains(String.valueOf(ownedIdentity.getItemId()) + " - " + String.valueOf(contactOwnedIdentity.getItemId()))) continue;
                    String invitationUrl = InvitationApi.getUrlRepresentation(contactOwnedIdentity);
                    if (ownedIdentity.equals(contactOwnedIdentity)) continue;
                    alreadySentInvitations.add((CallSite)((Object)(String.valueOf(contactOwnedIdentity.getItemId()) + " - " + String.valueOf(ownedIdentity.getItemId()))));
                    if (DbManager.getInstance().getContactDao().get(ownedIdentity.bytesOwnedIdentity(), contactOwnedIdentity.bytesOwnedIdentity()) != null) continue;
                    InvitationApi.sendInvitation(invitationUrl, ownedIdentity.bytesOwnedIdentity());
                }
            }
        });
    }

    private void onChange(List<Invitation> newList, List<Invitation> oldList) {
        AsyncTaskExecutor.submitTask(() -> {
            if (newList == null) {
                return;
            }
            for (Invitation invitation : newList) {
                try {
                    byte[] bytesContactIdentity;
                    Discussion discussion;
                    if (invitation == null || !(discussion = invitation.getDiscussion()).getContactId().isPresent() && !discussion.getPreContactId().isPresent()) continue;
                    if (discussion.getContactId().isPresent()) {
                        Contact contact = DbManager.getInstance().getContactDao().get(discussion.getContactId().get());
                        bytesContactIdentity = contact.getBytesContactIdentity();
                    } else {
                        PreContact preContact = DbManager.getInstance().getPreContactDao().get(discussion.getPreContactId().get());
                        ContactRef contactRef = DbManager.getInstance().getContactRefDao().get(preContact.getContactRefId());
                        bytesContactIdentity = contactRef.getBytesContactIdentity();
                    }
                    OwnedIdentity contactOwnedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(bytesContactIdentity);
                    if (contactOwnedIdentity != null) {
                        this.processContactInvitation(invitation, contactOwnedIdentity);
                        continue;
                    }
                    AppLogger.d("AutoInvitationHelper: onChange: invitation for no contact found: " + String.valueOf(invitation));
                }
                catch (Exception e) {
                    AppLogger.e("AutoInvitationHelper: onChange: Unexpected exception raised", e);
                }
            }
        });
    }

    void processContactInvitation(Invitation invitation, OwnedIdentity contactOwnedIdentity) {
        OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(invitation.getOwnedIdentityId());
        switch (invitation.getState()) {
            case INVITATION_WAIT_YOU_TO_ACCEPT: {
                InvitationApi.answerInvitation(invitation, true, ownedIdentity.getBytesOwnedIdentity());
                break;
            }
            case INVITATION_WAIT_YOU_FOR_SAS_EXCHANGE: {
                ArrayList<Invitation> contactInvitations = DbManager.getInstance().getInvitationDao().getInvitationsByIdentity((Id<OwnedIdentity>)contactOwnedIdentity.getItemId());
                if (contactInvitations == null) break;
                for (Invitation contactInvitation : contactInvitations) {
                    Contact contact;
                    if (contactInvitation.getState() != InvitationGenerated.State.INVITATION_WAIT_YOU_FOR_SAS_EXCHANGE && contactInvitation.getState() != InvitationGenerated.State.INVITATION_WAIT_IT_FOR_SAS_EXCHANGE) continue;
                    Discussion discussion = contactInvitation.getDiscussion();
                    if (discussion.getPreContactId().isPresent()) {
                        PreContact preContact = DbManager.getInstance().getPreContactDao().get(discussion.getPreContactId().get());
                        ContactRef contactRef = DbManager.getInstance().getContactRefDao().get(preContact.getContactRefId());
                        if (!Arrays.equals(contactRef.getBytesContactIdentity(), ownedIdentity.getBytesOwnedIdentity()) || !contactInvitation.getSasToDisplay().isPresent()) continue;
                        InvitationApi.submitSas(invitation, new String(contactInvitation.getSasToDisplay().get()), ownedIdentity.getBytesOwnedIdentity());
                        continue;
                    }
                    if (!discussion.getContactId().isPresent() || !Arrays.equals((contact = DbManager.getInstance().getContactDao().get(discussion.getContactId().get())).getBytesContactIdentity(), ownedIdentity.getBytesOwnedIdentity()) || !contactInvitation.getSasToDisplay().isPresent()) continue;
                    InvitationApi.submitSas(invitation, new String(contactInvitation.getSasToDisplay().get()), ownedIdentity.getBytesOwnedIdentity());
                }
                break;
            }
        }
    }
}

