/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.groups.group_management.creation.controller;

import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.groups.group_management.creation.FaceBox;
import io.olvid.windows.messenger.fx.groups.group_management.creation.GroupCreationFlowModel;
import io.olvid.windows.messenger.fx.groups.group_management.creation.GroupType;
import io.olvid.windows.messenger.fx.groups.group_management.creation.controller.TemplateSelectionView;
import io.olvid.windows.messenger.fx.misc.BindingUtils;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.control.Toggle;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;

public class TemplateSelectionController
extends BaseViewController {
    private final VBox root;
    private final TemplateSelectionView templateSelectionView = new TemplateSelectionView();
    private final HBox face_box = new HBox();
    private final Map<Toggle, GroupType> toggleTypeMap = new HashMap<Toggle, GroupType>();

    public TemplateSelectionController(GroupCreationFlowModel model) {
        this.root = new VBox();
        this.root.setSpacing(12.0);
        this.face_box.setAlignment(Pos.CENTER);
        this.face_box.setSpacing(45.0);
        this.root.getChildren().add((Object)this.face_box);
        this.root.getChildren().add((Object)this.templateSelectionView);
        this.root.setMaxHeight(705.0);
        BindingUtils.bindMappedListFromSelectModel(this.face_box.getChildren(), model.getSelectedModelContact(), FaceBox::createProfileCircle);
        this.face_box.visibleProperty().bind((ObservableValue)model.getSelectedModelContact().hasSelectedItemsProperty());
        this.face_box.managedProperty().bind((ObservableValue)model.getSelectedModelContact().hasSelectedItemsProperty());
        model.discussionTypeProperty().bind(this.selectedStateProperty());
        this.toggleTypeMap.put((Toggle)this.templateSelectionView.toggleAdvanced, GroupType.CUSTOM);
        this.toggleTypeMap.put((Toggle)this.templateSelectionView.toggleStandard, GroupType.STANDARD);
        this.toggleTypeMap.put((Toggle)this.templateSelectionView.toggleControlled, GroupType.CONTROLLED);
        this.toggleTypeMap.put((Toggle)this.templateSelectionView.toggleReadOnly, GroupType.READ_ONLY);
        FaceBox.bindFaceBox(this.face_box);
    }

    @Override
    public Region getLayout() {
        return this.root;
    }

    @Override
    public void onLayoutAttached() {
    }

    @Override
    public void onLayoutDetached() {
    }

    public GroupType getSelectedState() {
        Toggle currentToggle = (Toggle)this.templateSelectionView.toggleStandard.getToggleGroup().selectedToggleProperty().get();
        if (this.toggleTypeMap.containsKey(currentToggle)) {
            return this.toggleTypeMap.get(currentToggle);
        }
        return GroupType.NONE;
    }

    public ObjectBinding<GroupType> selectedStateProperty() {
        return Bindings.createObjectBinding(this::getSelectedState, (Observable[])new Observable[]{this.templateSelectionView.toggleStandard.getToggleGroup().selectedToggleProperty()});
    }
}

