/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.groups.group_management.creation.controller;

import io.olvid.windows.messenger.fx.discussions.discussion_modal_new.DiscussionFlowId;
import io.olvid.windows.messenger.fx.framework.annotations.FXMLView;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.groups.group_management.creation.FaceBox;
import io.olvid.windows.messenger.fx.groups.group_management.creation.FlowConstructor;
import io.olvid.windows.messenger.fx.groups.group_management.creation.GroupCreationFlowModel;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.BindingUtils;
import io.olvid.windows.messenger.fx.modal.standard_ui.flow.ModalFlowController;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Toggle;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;

@FXMLView(path="fx/groups/new_group_flow/advance_parameters.fxml")
public class AdvanceParametersController
extends BaseViewController {
    @FXML
    private VBox root;
    @FXML
    private HBox face_box;
    @FXML
    private Toggle toggle_read_only;
    @FXML
    private Button button_admin;
    @FXML
    private Button button_read_only;
    @FXML
    private Button button_delete;
    @FXML
    private Button button_ephemeral;
    @FXML
    private ComboBox<GroupCreationFlowModel.DeletePermission> combo_delete;
    private final GroupCreationFlowModel model;
    private final ModalFlowController<DiscussionFlowId> groupModalFlow;

    public AdvanceParametersController(GroupCreationFlowModel flowModel, ModalFlowController<DiscussionFlowId> groupModalFlow) {
        this.model = flowModel;
        this.groupModalFlow = groupModalFlow;
        this.loadFxml();
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        BindingUtils.bindMappedListFromSelectModel(this.face_box.getChildren(), this.model.getSelectedModelContact(), FaceBox::createProfileCircle);
        FaceBox.bindFaceBox(this.face_box);
        this.initComboModeration(this.model.deletePermissionProperty());
        this.initButton();
    }

    private void initComboModeration(ObjectProperty<GroupCreationFlowModel.DeletePermission> deletePermissionObjectProperty) {
        this.combo_delete.getItems().addAll((Object[])GroupCreationFlowModel.DeletePermission.values());
        deletePermissionObjectProperty.bind((ObservableValue)this.combo_delete.getSelectionModel().selectedItemProperty());
        this.combo_delete.getSelectionModel().select((Object)GroupCreationFlowModel.DeletePermission.ADMIN_ONLY);
        this.combo_delete.setConverter((StringConverter)new StringConverter<GroupCreationFlowModel.DeletePermission>(this){

            public String toString(GroupCreationFlowModel.DeletePermission deletePermission) {
                String key = "";
                switch (deletePermission) {
                    case NO_ONE: {
                        key = "modal.new_group.parameter_delete_no_one";
                        break;
                    }
                    case EVERY_ONE: {
                        key = "modal.new_group.parameter_delete_every_one";
                        break;
                    }
                    case ADMIN_ONLY: {
                        key = "modal.new_group.parameter_delete_admin_only";
                    }
                }
                return ViewControllerHelper.getString(key);
            }

            public GroupCreationFlowModel.DeletePermission fromString(String string) {
                return null;
            }
        });
    }

    @Override
    public Region getLayout() {
        return this.root;
    }

    @Override
    public void onLayoutAttached() {
    }

    @Override
    public void onLayoutDetached() {
    }

    private void initButton() {
        this.button_admin.setOnMouseClicked(event -> this.groupModalFlow.setState(FlowConstructor.GroupFlowStateId.ADMIN_CHOICE));
        this.button_read_only.setOnMouseClicked(event -> this.toggle_read_only.setSelected(!this.toggle_read_only.isSelected()));
        this.model.readOnlyProperty().bind((ObservableValue)this.toggle_read_only.selectedProperty());
        this.button_delete.setOnMouseClicked(event -> {
            if (this.combo_delete.isShowing()) {
                this.combo_delete.hide();
            } else {
                this.combo_delete.show();
            }
        });
        this.button_ephemeral.setOnMouseClicked(event -> this.groupModalFlow.setState(FlowConstructor.GroupFlowStateId.EPHEMERAL_PARAMETERS));
    }
}

