/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.groups.group_management.creation.controller;

import io.olvid.windows.messenger.fx.contacts.contacts_list.ContactListCell;
import io.olvid.windows.messenger.fx.custom_components.toggle_switch.TSwitch;
import io.olvid.windows.messenger.fx.generic_types.list_view.controller.StandardListViewController;
import io.olvid.windows.messenger.fx.groups.group_management.creation.GroupCreationFlowModel;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.BindingUtils;
import io.olvid.windows.messenger.livedata.info.ContactInfo;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;

public class AdminSelectionController {
    private final GroupCreationFlowModel model;
    private final VBox root = new VBox();

    public AdminSelectionController(GroupCreationFlowModel groupModalFlow) {
        this.model = groupModalFlow;
        ObservableSet<ContactInfo> contactListSet = this.model.getSelectedModelContact().getSelectedItems();
        ObservableList<ContactInfo> contactList = BindingUtils.of(contactListSet);
        StandardListViewController<ContactInfo> standardListView = new StandardListViewController<ContactInfo>(param -> new ContactParameterListCell(this), contactList, this.model.getAdminSelectModel(), (contact, node) -> {});
        standardListView.getListView().setFixedCellSize(70.0);
        HBox allHBox = this.createSelectAllHBox(contactList);
        this.root.setPadding(new Insets(32.0, 0.0, 0.0, 0.0));
        this.root.getChildren().addAll((Object[])new Node[]{allHBox, standardListView.getListView()});
    }

    private HBox createSelectAllHBox(ObservableList<ContactInfo> contactList) {
        Label label = new Label(ViewControllerHelper.RESOURCE_BUNDLE.getString("modal_new_group_parameter_select_everything"));
        label.getStyleClass().add((Object)"h2");
        Region filler = new Region();
        HBox.setHgrow((Node)filler, (Priority)Priority.ALWAYS);
        TSwitch toggle = new TSwitch();
        toggle.getStyleClass().add((Object)"success-t-switch");
        SetChangeListener selectAdminListener = change -> toggle.setSelected(change.getSet().size() == contactList.size());
        ObservableSet<ContactInfo> selectedAdmin = this.model.getAdminSelectModel().getSelectedItems();
        selectedAdmin.addListener(selectAdminListener);
        toggle.setOnAction(event -> {
            if (toggle.isSelected()) {
                this.model.getSelectedModelContact().getSelectedItems().forEach(this.model.getAdminSelectModel()::selectItem);
            } else {
                this.model.getSelectedModelContact().getSelectedItems().forEach(this.model.getAdminSelectModel()::unselectItem);
            }
        });
        return new HBox(new Node[]{label, filler, toggle});
    }

    public Node getRoot() {
        return this.root;
    }

    private class ContactParameterListCell
    extends ContactListCell {
        private final ObjectProperty<ContactInfo> contactProperty = new SimpleObjectProperty();

        public ContactParameterListCell(AdminSelectionController adminSelectionController) {
            super(false);
            this.setSelectModel(adminSelectionController.model.getAdminSelectModel());
            this.fillTheVariable();
        }

        @Override
        public void updateItem(ContactInfo contact, boolean empty) {
            super.updateItem(contact, empty);
            this.setText(null);
            if (contact != null && !empty) {
                this.contactProperty.set((Object)contact);
            } else {
                this.setGraphic(null);
            }
        }

        private void fillTheVariable() {
            Label specificLabel = this.createAdminNode();
            TSwitch tSwitch = new TSwitch();
            tSwitch.getStyleClass().add((Object)"success-t-switch");
            tSwitch.setMouseTransparent(true);
            tSwitch.selectedProperty().bind((ObservableValue)this.select);
            VBox vBox = new VBox(new Node[]{tSwitch, specificLabel});
            vBox.setAlignment(Pos.CENTER_RIGHT);
            this.getCheckBoxParent().getChildren().setAll((Object[])new Node[]{vBox});
        }

        private Label createAdminNode() {
            Label label = new Label();
            label.textProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.select).then(ViewControllerHelper.RESOURCE_BUNDLE.getString("modal_new_group_parameter_admin_label_admin")).otherwise(ViewControllerHelper.RESOURCE_BUNDLE.getString("modal_new_group_parameter_admin_label_not_admin")));
            label.getStyleClass().add((Object)"body-2");
            return label;
        }
    }
}

