/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.groups.group_management;

import io.olvid.windows.messenger.fx.custom_components.bubbles.BubbleUtils;
import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.custom_components.toggle_switch.TSwitch;
import io.olvid.windows.messenger.fx.framework.lib.OlvidBindings;
import io.olvid.windows.messenger.fx.generic_types.DiffUtils;
import io.olvid.windows.messenger.fx.groups.group_management.GroupCardController;
import io.olvid.windows.messenger.fx.groups.group_management.GroupCardModel;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.BubbleAndDescription;
import io.olvid.windows.messenger.livedata.info.ContactInfo;
import io.olvid.windows.messenger.livedata.info.PendingGroupMemberInfo;
import io.olvid.windows.messenger.misc.BytesKey;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class GroupMemberCellPanel
extends HBox
implements DiffUtils.NodeController<GroupCardController.MemberInfo> {
    public GroupCardController.MemberInfo memberInfo;
    protected final BooleanProperty pending = new SimpleBooleanProperty();
    protected final BooleanProperty deleted = new SimpleBooleanProperty();
    protected final ObjectProperty<BytesKey> id = new SimpleObjectProperty();
    protected final BooleanProperty admin = new SimpleBooleanProperty();
    protected final BooleanProperty adminPermissionChange = new SimpleBooleanProperty();
    protected final BooleanProperty declined = new SimpleBooleanProperty();
    protected final GroupCardModel groupCardModel;
    protected final BubbleAndDescription bubbleAndDescription;
    protected OlvidBindings.StaticListBindings<String> svgTrashBinding;
    protected OlvidBindings.StaticListBindings<String> contactCellPaneBinding;

    public GroupMemberCellPanel(GroupCardModel groupCardModel) {
        this.groupCardModel = groupCardModel;
        this.setAlignment(Pos.CENTER_LEFT);
        this.setPrefHeight(80.0);
        this.setPadding(new Insets(12.0, 0.0, 12.0, 0.0));
        HBox.setHgrow((Node)this, (Priority)Priority.ALWAYS);
        Button deleteButton = new Button();
        deleteButton.getStyleClass().add((Object)"empty-button");
        SvgSizeable svgTrash = new SvgSizeable();
        svgTrash.getStyleClass().addAll((Object[])new String[]{"icon-medium", "svg-trash1"});
        deleteButton.setGraphic((Node)svgTrash);
        HBox disableOnDeleteContainer = new HBox();
        disableOnDeleteContainer.setAlignment(Pos.CENTER_LEFT);
        HBox.setHgrow((Node)disableOnDeleteContainer, (Priority)Priority.ALWAYS);
        Region spacer = new Region();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        Label pendingTag = new Label();
        pendingTag.setText(ViewControllerHelper.getString("group_card_members_pending_label"));
        pendingTag.getStyleClass().addAll((Object[])new String[]{"body-3", "tag-grey"});
        HBox.setHgrow((Node)pendingTag, (Priority)Priority.ALWAYS);
        Label adminTag = new Label();
        adminTag.setText(ViewControllerHelper.getString("group_card_admin_tag"));
        adminTag.getStyleClass().addAll((Object[])new String[]{"body-3", "tag-primary"});
        HBox.setHgrow((Node)adminTag, (Priority)Priority.ALWAYS);
        StackPane chevronContainer = new StackPane();
        SvgSizeable chevron = new SvgSizeable();
        chevron.getStyleClass().addAll((Object[])new String[]{"svg-chevron", "icon-medium", "icon-grey"});
        chevronContainer.getChildren().add((Object)chevron);
        VBox toggleContainer = new VBox();
        toggleContainer.setAlignment(Pos.CENTER_RIGHT);
        TSwitch toggleSwitch = new TSwitch();
        toggleSwitch.getStyleClass().add((Object)"success-t-switch");
        Label toggleLabel = new Label();
        toggleLabel.getStyleClass().add((Object)"body-2");
        this.bubbleAndDescription = new BubbleAndDescription();
        HBox.setHgrow((Node)this.bubbleAndDescription, (Priority)Priority.ALWAYS);
        StackPane stackPane = new StackPane(new Node[]{pendingTag, adminTag, toggleContainer});
        HBox hBox = new HBox(new Node[]{spacer, stackPane});
        this.bubbleAndDescription.setRight((Node)hBox);
        disableOnDeleteContainer.getChildren().addAll((Object[])new Node[]{this.bubbleAndDescription, chevronContainer});
        toggleContainer.getChildren().addAll((Object[])new Node[]{toggleSwitch, toggleLabel});
        this.getChildren().addAll((Object[])new Node[]{deleteButton, disableOnDeleteContainer});
        SimpleBooleanProperty editMode = new SimpleBooleanProperty();
        editMode.bind((ObservableValue)groupCardModel.editModeProperty().and((ObservableBooleanValue)groupCardModel.amISamuraiProperty()));
        adminTag.managedProperty().bind((ObservableValue)adminTag.visibleProperty());
        adminTag.visibleProperty().bind((ObservableValue)this.admin.and((ObservableBooleanValue)editMode.not()).and((ObservableBooleanValue)this.pending.not()).and((ObservableBooleanValue)this.declined.not()));
        pendingTag.managedProperty().bind((ObservableValue)pendingTag.visibleProperty());
        pendingTag.visibleProperty().bind((ObservableValue)this.pending.and((ObservableBooleanValue)editMode.not()).or((ObservableBooleanValue)this.declined));
        pendingTag.textProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.declined).then(ViewControllerHelper.getString("group_management_pending_declined")).otherwise(ViewControllerHelper.getString("group_card_members_pending_label")));
        deleteButton.managedProperty().bind((ObservableValue)deleteButton.visibleProperty());
        deleteButton.visibleProperty().bind((ObservableValue)editMode);
        toggleContainer.managedProperty().bind((ObservableValue)toggleContainer.visibleProperty());
        toggleContainer.visibleProperty().bind((ObservableValue)editMode.and((ObservableBooleanValue)groupCardModel.v2Property()));
        chevron.managedProperty().bind((ObservableValue)chevron.visibleProperty());
        chevron.visibleProperty().bind((ObservableValue)editMode.not());
        toggleSwitch.selectedProperty().bind((ObservableValue)Bindings.or((ObservableBooleanValue)this.admin.and((ObservableBooleanValue)this.adminPermissionChange.not()), (ObservableBooleanValue)this.admin.not().and((ObservableBooleanValue)this.adminPermissionChange)));
        this.adminPermissionChange.bind((ObservableValue)Bindings.createBooleanBinding(() -> groupCardModel.getAdminChange().contains(this.id.get()), (Observable[])new Observable[]{this.id, groupCardModel.getAdminChange()}));
        toggleSwitch.setOnAction(event -> {
            if (!groupCardModel.getAdminChange().remove(this.id.get())) {
                groupCardModel.getAdminChange().add((Object)((BytesKey)this.id.get()));
            }
            event.consume();
        });
        this.admin.bind((ObservableValue)Bindings.createBooleanBinding(() -> groupCardModel.getAdminKeySet().contains(this.id.get()), (Observable[])new Observable[]{groupCardModel.getAdminKeySet(), this.id}));
        toggleLabel.textProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)toggleSwitch.selectedProperty()).then(ViewControllerHelper.getString("modal_new_group_parameter_admin_label_admin")).otherwise(ViewControllerHelper.getString("modal_new_group_parameter_admin_label_not_admin")));
        this.deleted.bind((ObservableValue)Bindings.createBooleanBinding(() -> groupCardModel.getDeletesMembers().contains(this.id.get()), (Observable[])new Observable[]{this.id, groupCardModel.getDeletesMembers()}));
        deleteButton.setOnAction(event -> {
            if (this.memberInfo == null || this.id.get() == null) {
                return;
            }
            groupCardModel.delete((BytesKey)this.id.get());
        });
        disableOnDeleteContainer.disableProperty().bind((ObservableValue)this.deleted);
        this.svgTrashBinding = OlvidBindings.bindClass((Node)svgTrash);
        this.svgTrashBinding.to("icon-medium").to((ObservableValue<String>)Bindings.when((ObservableBooleanValue)this.deleted).then("svg-trash1").otherwise("svg-trash"));
        this.contactCellPaneBinding = OlvidBindings.bindClass((Node)this);
        this.contactCellPaneBinding.to((ObservableValue<String>)Bindings.when((ObservableBooleanValue)this.deleted).then("light-grey-pane").otherwise(""));
    }

    @Override
    public GroupCardController.MemberInfo getValue() {
        return this.memberInfo;
    }

    @Override
    public void update(GroupCardController.MemberInfo memberInfo) {
        this.memberInfo = memberInfo;
        this.bubbleAndDescription.title.setText(memberInfo.getDisplayName());
        this.bubbleAndDescription.setSubtitle(Optional.ofNullable(memberInfo.getPositionCompany()));
        this.id.set((Object)BytesKey.of(memberInfo.getBytesContactIdentity()));
        if (memberInfo.either().isLeft()) {
            ContactInfo contactInfo = memberInfo.either().getLeft();
            BubbleUtils.setBubbleData(contactInfo, this.bubbleAndDescription.bubble);
            this.declined.set(false);
            this.pending.set(false);
        } else {
            PendingGroupMemberInfo pendingGroupMember = memberInfo.either().getRight();
            BubbleUtils.setBubbleData(pendingGroupMember, this.bubbleAndDescription.bubble);
            this.declined.set(pendingGroupMember.isDeclined());
            this.pending.set(true);
        }
    }

    @Override
    public Node getNode() {
        return this;
    }

    @Override
    public void dispose() {
        this.svgTrashBinding.unbind();
        this.contactCellPaneBinding.unbind();
        this.admin.unbind();
        this.adminPermissionChange.unbind();
        this.deleted.unbind();
        this.setOnMouseClicked(null);
    }
}

