/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.groups.group_management;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.ContactGroupJoin;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.GroupMemberPermissions;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.PendingGroupMember;
import io.olvid.windows.messenger.database.tables.gen.GroupGenerated;
import io.olvid.windows.messenger.database.tables.gen.GroupMemberPermissionsGenerated;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.livedata.ListLiveData;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.MapLiveData;
import io.olvid.windows.messenger.livedata.MutableLiveData;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.livedata.cache.DbCache;
import io.olvid.windows.messenger.livedata.info.ContactInfo;
import io.olvid.windows.messenger.livedata.info.PendingGroupMemberInfo;
import io.olvid.windows.messenger.misc.BytesKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;

public class GroupCardModel {
    private final LiveData<Group> groupLiveData;
    private final LiveData<List<Contact>> contactListLiveData;
    private final BooleanProperty v2 = new SimpleBooleanProperty();
    private final ObjectProperty<Optional<String>> selectedNewPhotoUrlAbsolutePath = new SimpleObjectProperty(Optional.empty());
    private final LiveData<List<PendingGroupMemberInfo>> pendingGroupMembersLiveData;
    private final LiveData<List<GroupMemberPermissions>> allGroupMembersPermisisons;
    private final LiveData<GroupMemberPermissions> ownGroupPermissionLiveData;
    private final BooleanProperty lastSamurai = new SimpleBooleanProperty(false);
    private final BooleanProperty thereAreOtherSamurai = new SimpleBooleanProperty(true);
    private final BooleanProperty amISamurai = new SimpleBooleanProperty(false);
    private final LiveDataListener<List<GroupMemberPermissions>> onAllPermissionsChange = this::onPermissionsChange;
    private final LiveDataListener<GroupMemberPermissions> ownPermissionListener = this::ownPermissionListener;
    private final BooleanProperty editMode = new SimpleBooleanProperty(false);
    private final BooleanProperty keycloak = new SimpleBooleanProperty(false);
    private final BooleanProperty errorTitle = new SimpleBooleanProperty();
    private final ObservableSet<BytesKey> adminChange = FXCollections.observableSet((Object[])new BytesKey[0]);
    private final ObjectProperty<GroupGenerated.Update> updateState = new SimpleObjectProperty((Object)GroupGenerated.Update.NONE);
    private final ObservableSet<BytesKey> deletesMembers = FXCollections.observableSet((Object[])new BytesKey[0]);
    private final ObservableSet<BytesKey> adminKeySet = FXCollections.observableSet((Object[])new BytesKey[0]);
    private MutableLiveData<List<Id<Contact>>> newMembersIdLiveData;
    private LiveData<List<ContactInfo>> newMembersInfoLiveData;
    private final LiveData<List<ContactInfo>> groupMembersLiveData;

    private void ownPermissionListener(GroupMemberPermissions newValue, GroupMemberPermissions oldValue) {
        ViewControllerHelper.smartUIUpdate(() -> {
            if (newValue == null) {
                this.amISamurai.setValue(Boolean.valueOf(false));
            } else {
                this.amISamurai.setValue(Boolean.valueOf(newValue.hasPermissionAdmin()));
            }
        });
    }

    public GroupCardModel(Id<Group> groupId, LiveDataListener<Group> groupChangeListener, LiveDataListener<GroupMemberPermissions> ownPermissionListener) {
        this.groupLiveData = LiveDataFactory.buildDbLiveDataItem(Group.class, () -> (Group)DbManager.getInstance().getGroupDao().get(groupId));
        this.ownGroupPermissionLiveData = LiveDataFactory.switchMap(this.groupLiveData, groupArg -> {
            if (groupArg == null) {
                return null;
            }
            return LiveDataFactory.buildDbLiveDataItem(GroupMemberPermissions.class, () -> DbManager.getInstance().getGroupMemberPermissionsDao().getOwnPermission((Id<Group>)groupArg.getItemId()));
        });
        this.ownGroupPermissionLiveData.addListener(ownPermissionListener);
        this.ownGroupPermissionLiveData.addListener(this.ownPermissionListener);
        this.contactListLiveData = LiveDataFactory.switchMap(this.groupLiveData, groupArg -> {
            if (groupArg == null) {
                return null;
            }
            return LiveDataFactory.buildDbLiveDataList(Contact.class, () -> DbManager.getInstance().getContactDao().getSortedGroupMembers((Id<Group>)groupArg.getItemId()), List.of(ContactGroupJoin.class));
        });
        this.groupMembersLiveData = SelectedOwnedIdentitySingleton.getInstance().of(this.contactListLiveData);
        LiveData pendingGroupMemberLiveData = LiveDataFactory.switchMap(this.groupLiveData, groupArg -> {
            if (groupArg == null) {
                return null;
            }
            return LiveDataFactory.buildDbLiveDataList(PendingGroupMember.class, () -> DbManager.getInstance().getPendingGroupMemberDao().getPendingMembers((Group)groupArg));
        });
        LiveData pendingGroupMemberInfoLiveData = MapLiveData.list(pendingGroupMemberLiveData, AbstractTableGenerated::getItemId, DbCache.getInstance().pendingGroupMemberInfoLiveData, pgm -> Optional.empty());
        this.pendingGroupMembersLiveData = ListLiveData.compact(pendingGroupMemberInfoLiveData, o -> o);
        this.groupLiveData.addListener(groupChangeListener);
        this.allGroupMembersPermisisons = LiveDataFactory.switchMap(this.groupLiveData, groupArg -> {
            if (groupArg == null) {
                return null;
            }
            return LiveDataFactory.buildDbLiveDataList(GroupMemberPermissions.class, () -> DbManager.getInstance().getGroupMemberPermissionsDao().getAllOthersPermissionsForGroup((Id<Group>)groupArg.getItemId()), List.of(ContactGroupJoin.class, PendingGroupMember.class));
        });
        this.allGroupMembersPermisisons.addListener(this.onAllPermissionsChange);
        this.lastSamurai.bind((ObservableValue)this.amISamurai.and((ObservableBooleanValue)this.thereAreOtherSamurai.not()));
        this.newMembersIdLiveData = LiveDataFactory.buildMutableLiveData(new ArrayList());
        this.newMembersInfoLiveData = LiveDataFactory.switchMap(this.newMembersIdLiveData, ids -> {
            LiveData<List<ContactInfo>> filter = ListLiveData.filter(DbCache.getInstance().contactsInfo, info -> ids.contains(info.getItemId()));
            return LiveDataFactory.map(filter, List.of(), l -> {
                ArrayList sortedList = new ArrayList(l);
                Collections.sort(sortedList);
                return sortedList;
            });
        });
    }

    private void onPermissionsChange(List<GroupMemberPermissions> newValue, List<GroupMemberPermissions> oldValue) {
        if (newValue == null) {
            return;
        }
        Group group = this.groupLiveData.getValue();
        if (group == null) {
            return;
        }
        ViewControllerHelper.smartUIUpdate(() -> this.thereAreOtherSamurai.setValue(Boolean.valueOf(group.isV2() && newValue.stream().filter(groupMemberPermissions -> groupMemberPermissions.getContactGroupJoinId().isPresent()).anyMatch(GroupMemberPermissionsGenerated::hasPermissionAdmin))));
        Set newAdminKeySet = newValue.stream().filter(GroupMemberPermissionsGenerated::hasPermissionAdmin).map(groupMemberPermissions -> {
            if (groupMemberPermissions.getContactGroupJoinId().isPresent()) {
                ContactGroupJoin contactGroupJoin = DbManager.getInstance().getContactGroupJoinDao().get(groupMemberPermissions.getContactGroupJoinId().get());
                if (contactGroupJoin == null) {
                    return null;
                }
                Optional<ContactInfo> contactInfo = DbCache.getInstance().getContactInfo(contactGroupJoin.getContactId());
                return contactInfo.map(info -> BytesKey.of(info.bytesContactIdentity())).orElse(null);
            }
            if (groupMemberPermissions.getPendingGroupMemberId().isPresent()) {
                PendingGroupMember pendingGroupMember = DbManager.getInstance().getPendingGroupMemberDao().get(groupMemberPermissions.getPendingGroupMemberId().get());
                if (pendingGroupMember == null) {
                    return null;
                }
                ContactRef contactRef = DbManager.getInstance().getContactRefDao().get(pendingGroupMember.getContactRefId());
                return BytesKey.of(contactRef.getBytesContactIdentity());
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        ViewControllerHelper.smartUIUpdate(() -> {
            this.adminKeySet.removeIf(ind -> !newAdminKeySet.contains(ind));
            this.adminKeySet.addAll((Collection)newAdminKeySet);
        });
    }

    public Group getGroup() {
        return this.groupLiveData != null ? this.groupLiveData.getValue() : null;
    }

    public Discussion getAssociatedDiscussion() {
        return DbManager.getInstance().getDiscussionDao().get(this.groupLiveData.getValue());
    }

    public LiveData<List<ContactInfo>> getGroupMembersLiveData() {
        return this.groupMembersLiveData;
    }

    public LiveData<List<PendingGroupMemberInfo>> getPendingGroupMembersLiveData() {
        return this.pendingGroupMembersLiveData;
    }

    public LiveData<List<ContactInfo>> getNewMembersInfoLiveData() {
        return this.newMembersInfoLiveData;
    }

    public Optional<List<GroupMemberPermissions>> getAllGroupMembersPermissions() {
        return Optional.ofNullable(this.allGroupMembersPermisisons.getValue());
    }

    public Optional<GroupMemberPermissions> getOwnGroupPermission() {
        return Optional.ofNullable(this.ownGroupPermissionLiveData.getValue());
    }

    public void setSelectedNewPhotoUrlAbsolutePath(Optional<String> selectedNewPhotoUrlAbsolutePath) {
        this.selectedNewPhotoUrlAbsolutePath.set(selectedNewPhotoUrlAbsolutePath);
    }

    public BooleanProperty lastSamuraiProperty() {
        return this.lastSamurai;
    }

    public BooleanProperty amISamuraiProperty() {
        return this.amISamurai;
    }

    public ObservableSet<BytesKey> getAdminChange() {
        return this.adminChange;
    }

    public void unplug() {
        this.groupLiveData.removeAllListeners();
        this.ownGroupPermissionLiveData.removeAllListeners();
        this.allGroupMembersPermisisons.removeAllListeners();
        this.groupMembersLiveData.removeAllListeners();
    }

    public void plug(LiveDataListener<Group> groupChangeListener, LiveDataListener<GroupMemberPermissions> ownPermissionListener) {
        this.groupLiveData.addListener(groupChangeListener);
        this.ownGroupPermissionLiveData.addListener(ownPermissionListener);
        this.allGroupMembersPermisisons.addListener(this.onAllPermissionsChange);
    }

    public ObjectProperty<Optional<String>> selectedNewPhotoUrlAbsolutePathProperty() {
        return this.selectedNewPhotoUrlAbsolutePath;
    }

    public Optional<String> getSelectedNewPhotoUrlAbsolutePath() {
        return (Optional)this.selectedNewPhotoUrlAbsolutePath.get();
    }

    public boolean isEditMode() {
        return this.editMode.get();
    }

    public BooleanProperty editModeProperty() {
        return this.editMode;
    }

    public void setEditMode(boolean editMode) {
        this.editMode.set(editMode);
    }

    public GroupGenerated.Update getUpdateState() {
        return (GroupGenerated.Update)this.updateState.get();
    }

    public ObjectProperty<GroupGenerated.Update> updateStateProperty() {
        return this.updateState;
    }

    public void setUpdateState(GroupGenerated.Update updateState) {
        this.updateState.set((Object)updateState);
    }

    public ObservableSet<BytesKey> getDeletesMembers() {
        return this.deletesMembers;
    }

    public boolean isKeycloak() {
        return this.keycloak.get();
    }

    public BooleanProperty keycloakProperty() {
        return this.keycloak;
    }

    public void setKeycloak(boolean keycloak) {
        this.keycloak.set(keycloak);
    }

    public boolean isV2() {
        return this.v2.get();
    }

    public BooleanProperty v2Property() {
        return this.v2;
    }

    public ObservableSet<BytesKey> getAdminKeySet() {
        return this.adminKeySet;
    }

    public boolean isErrorTitle() {
        return this.errorTitle.get();
    }

    public BooleanProperty errorTitleProperty() {
        return this.errorTitle;
    }

    public void setErrorTitle(boolean errorTitle) {
        this.errorTitle.set(errorTitle);
    }

    public void setV2(boolean v2) {
        this.v2Property().setValue(Boolean.valueOf(v2));
    }

    public void delete(BytesKey key) {
        List newContacts = (List)this.newMembersIdLiveData.getValue();
        if (newContacts != null) {
            ArrayList newContactsCopy = new ArrayList(newContacts);
            ListIterator iterator = newContactsCopy.listIterator();
            boolean found = false;
            while (iterator.hasNext()) {
                Id contactId = (Id)iterator.next();
                Optional<ContactInfo> contactInfo = DbCache.getInstance().getContactInfo(contactId);
                if (contactInfo.isEmpty() || !BytesKey.of(contactInfo.get().bytesContactIdentity()).equals(key)) continue;
                iterator.remove();
                found = true;
                break;
            }
            if (found) {
                this.newMembersIdLiveData.postValue(newContactsCopy);
                return;
            }
        }
        if (!this.deletesMembers.remove((Object)key)) {
            this.deletesMembers.add((Object)key);
        }
    }

    public MutableLiveData<List<Id<Contact>>> getNewMembersIdLiveData() {
        return this.newMembersIdLiveData;
    }
}

