/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.groups.group_management;

import io.olvid.engine.datatypes.containers.GroupV2;
import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.ContactGroupJoin;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.GroupMemberPermissions;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.PendingGroupMember;
import io.olvid.windows.messenger.database.tables.gen.GroupGenerated;
import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.engine.api.GroupUpdateInput;
import io.olvid.windows.messenger.engine.helpers.discussion.DiscussionApi;
import io.olvid.windows.messenger.engine.helpers.files.FileApi;
import io.olvid.windows.messenger.engine.helpers.groups.GroupHelper;
import io.olvid.windows.messenger.fx.contacts.contacts_list.AddGroupMemberModalController;
import io.olvid.windows.messenger.fx.custom_components.HeightBindTextArea;
import io.olvid.windows.messenger.fx.custom_components.bubbles.BubbleUtils;
import io.olvid.windows.messenger.fx.custom_components.bubbles.IdentityBubble;
import io.olvid.windows.messenger.fx.custom_components.bubbles.PolarPane;
import io.olvid.windows.messenger.fx.framework.annotations.FXMLView;
import io.olvid.windows.messenger.fx.framework.lib.OlvidBindings;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.groups.group_management.GroupCardModel;
import io.olvid.windows.messenger.fx.groups.group_management.GroupMemberCellPanel;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.main_stack.main_layer.right_panel.RightPanelContextHolder;
import io.olvid.windows.messenger.fx.main_stack.main_layer.right_panel.RightPanelContextState;
import io.olvid.windows.messenger.fx.modal.message_infos.view.VBoxList;
import io.olvid.windows.messenger.livedata.Diffable;
import io.olvid.windows.messenger.livedata.ListLiveData;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.livedata.cache.DbCache;
import io.olvid.windows.messenger.livedata.info.ContactInfo;
import io.olvid.windows.messenger.livedata.info.IdentityDetailsInfo;
import io.olvid.windows.messenger.livedata.info.PendingGroupMemberInfo;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.BytesKey;
import io.olvid.windows.messenger.misc.Either;
import io.olvid.windows.messenger.misc.Pair;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.GenericNotification;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.ModalNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.UIActionNC;
import io.olvid.windows.messenger.start_up.AppRuntimeHelper;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import org.jetbrains.annotations.NotNull;

@FXMLView(path="fx/groups/group_management/group_card.fxml")
public class GroupCardController
extends BaseViewController {
    @FXML
    private ScrollPane root;
    @FXML
    private VBox main_vbox;
    @FXML
    private StackPane personal_note_wrapper;
    @FXML
    private StackPane description_wrapper;
    @FXML
    private StackPane title_wrapper;
    @FXML
    private Label label_title_error;
    @FXML
    private Button modification_button;
    @FXML
    private Button new_member_button;
    @FXML
    private VBox members_box_container;
    @FXML
    private Button quit_group;
    @FXML
    private Button delete_group;
    @FXML
    private Region delete_group_sep;
    @FXML
    private Button bubble_button;
    @FXML
    private Button delete_photo;
    @FXML
    private Button open_discussion;
    @FXML
    private Button close_button;
    @FXML
    private Button previous_button;
    @FXML
    private StackPane camera;
    @FXML
    private IdentityBubble group_bubble;
    @FXML
    private Label admin_label;
    private VBoxList<MemberInfo, GroupMemberCellPanel> members_box;
    private final LiveDataListener<Group> groupChangeListener = this::onGroupChanged;
    private final LiveDataListener<GroupMemberPermissions> ownPermissionListener = this::onOwnGroupPermissionsChange;
    private final RightPanelContextHolder navigation;
    private HeightBindTextArea note_area;
    private HeightBindTextArea description_area;
    private HeightBindTextArea title_area;
    private LiveDataListener<Boolean> navigationEmptyLiveDataListener;
    private final GroupCardModel model;
    private ChangeListener<Boolean> booleanChangeListener;
    private ObservableList<ContactInfo> sortedNewMembers;
    private ObservableList<ContactInfo> sortedMembers;

    public GroupCardController(Id<Group> groupId, RightPanelContextHolder navigation) {
        this.navigation = navigation;
        this.model = new GroupCardModel(groupId, this.groupChangeListener, this.ownPermissionListener);
        this.loadFxml();
    }

    private GroupMemberCellPanel createMemberItem(MemberInfo memberInfo) {
        GroupMemberCellPanel controller = new GroupMemberCellPanel(this.model);
        controller.update(memberInfo);
        controller.setOnMouseClicked(event -> {
            if (controller.memberInfo.either().isLeft()) {
                this.handleContactSelected(controller.memberInfo.either().getLeft());
            } else {
                this.handleContactSelected(controller.memberInfo.either().getRight());
            }
        });
        return controller;
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        super.initialize(location, resources);
        this.initMembersItem();
        BooleanBinding editAndAdmin = this.model.editModeProperty().and((ObservableBooleanValue)this.model.amISamuraiProperty());
        BooleanBinding updateOnGoing = Bindings.createBooleanBinding(() -> switch (this.model.getUpdateState()) {
            case GroupGenerated.Update.CREATING, GroupGenerated.Update.SYNCING -> true;
            default -> false;
        }, (Observable[])new Observable[]{this.model.updateStateProperty()});
        this.initButtonModification(updateOnGoing);
        this.initTextArea(editAndAdmin);
        this.initMemberListView(editAndAdmin);
        this.open_discussion.setOnAction(this::goToDiscussionHandler);
        this.initBubble(editAndAdmin);
        this.initDeleteAndQuitGroupButton(updateOnGoing);
        this.close_button.setOnAction(event -> {
            if (this.model.editModeProperty().get()) {
                this.stopEditing();
            } else {
                this.navigation.close();
            }
        });
        this.previous_button.managedProperty().bind((ObservableValue)this.previous_button.visibleProperty());
        this.navigationEmptyLiveDataListener = (newValue, oldValue) -> ViewControllerHelper.smartUIUpdate(() -> this.previous_button.visibleProperty().set(newValue == false));
        this.navigation.getRightPanelContext().getIsStatesHistoryEmpty().addListener(this.navigationEmptyLiveDataListener);
        this.previous_button.disableProperty().bind((ObservableValue)this.model.editModeProperty());
        this.previous_button.setOnAction(event -> this.navigation.goToPrevious());
        this.booleanChangeListener = (observable, oldValue, newValue) -> {
            if (newValue.booleanValue() && this.model.getGroup().isNameEmpty()) {
                this.title_area.setText("");
            }
            if (oldValue.booleanValue()) {
                this.title_area.setText(this.model.getGroup().getDisplayName().orElse(""));
                this.description_area.setText(this.model.getGroup().getDescription().orElse(null));
                this.note_area.setText(this.model.getGroup().getPersonalNote().orElse(null));
                this.group_bubble.setPhotoUrlRelPath(this.model.getGroup().getCustomPhotoUrlOrPhotoUrl());
            }
        };
        this.model.editModeProperty().addListener((ChangeListener)new WeakChangeListener(this.booleanChangeListener));
        this.admin_label.managedProperty().bind((ObservableValue)this.admin_label.visibleProperty());
        this.admin_label.visibleProperty().bind((ObservableValue)this.model.amISamuraiProperty());
        this.initTitleLabelError();
    }

    private void initTitleLabelError() {
        this.label_title_error.managedProperty().bind((ObservableValue)this.label_title_error.visibleProperty());
        this.label_title_error.visibleProperty().bind((ObservableValue)this.model.editModeProperty().and((ObservableBooleanValue)this.model.errorTitleProperty()));
        this.title_area.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue() && oldValue.booleanValue()) {
                this.model.setErrorTitle(!GroupHelper.isGroupNameCompliant(this.model.getGroup(), this.getCurrentTitle()));
            }
        });
    }

    private void initMembersItem() {
        LiveData pending = LiveDataFactory.map(this.model.getPendingGroupMembersLiveData(), List.of(), l -> l.stream().map(MemberInfo::of).toList());
        LiveData members = LiveDataFactory.map(this.model.getGroupMembersLiveData(), List.of(), l -> l.stream().map(MemberInfo::of).toList());
        LiveData newMembers = LiveDataFactory.map(this.model.getNewMembersInfoLiveData(), List.of(), l -> l.stream().map(MemberInfo::of).toList());
        LiveData all = ListLiveData.concat(pending, ListLiveData.concat(members, newMembers));
        LiveData allSorted = ListLiveData.sort(all, Comparator.naturalOrder());
        this.members_box = new VBoxList<MemberInfo, GroupMemberCellPanel>(GroupMemberCellPanel.class, this::createMemberItem);
        this.members_box_container.getChildren().add(this.members_box);
        this.members_box.plug(allSorted);
    }

    private void initMemberListView(BooleanBinding editAndAdmin) {
        this.new_member_button.setOnAction(this::addMembersButtonHandler);
        this.new_member_button.managedProperty().bind((ObservableValue)this.new_member_button.visibleProperty());
        this.new_member_button.visibleProperty().bind((ObservableValue)editAndAdmin);
    }

    private void initBubble(BooleanBinding editAndAdmin) {
        OlvidBindings.bindClass((Node)this.bubble_button).to((ObservableValue<String>)Bindings.when((ObservableBooleanValue)editAndAdmin).then("bubble_edit").otherwise("bubble_inert"));
        this.bubble_button.disableProperty().bind((ObservableValue)editAndAdmin.not());
        this.bubble_button.setOnAction(this::editPhotoButtonHandler);
        this.bubble_button.setGraphic((Node)this.group_bubble);
        this.camera.managedProperty().bind((ObservableValue)this.camera.visibleProperty());
        this.camera.visibleProperty().bind((ObservableValue)editAndAdmin);
        PolarPane.setAngle((Node)this.camera, 45);
        PolarPane.setRadius((Node)this.camera, this.group_bubble.getRadius());
        this.delete_photo.managedProperty().bind((ObservableValue)this.delete_photo.visibleProperty());
        this.delete_photo.visibleProperty().bind((ObservableValue)this.model.editModeProperty().and((ObservableBooleanValue)this.model.selectedNewPhotoUrlAbsolutePathProperty().isNotEqualTo(Optional.empty())));
        this.delete_photo.setOnAction(event -> this.resizeAndCompressSucceeded(null));
    }

    private void initDeleteAndQuitGroupButton(BooleanBinding updateOnGoing) {
        this.quit_group.setOnAction(this::leaveGroupButtonHandler);
        this.quit_group.disableProperty().bind((ObservableValue)this.model.lastSamuraiProperty().or((ObservableBooleanValue)updateOnGoing).or((ObservableBooleanValue)this.model.keycloakProperty()));
        this.delete_group.setOnAction(this::disbandGroupButtonHandler);
        this.delete_group.disableProperty().bind((ObservableValue)updateOnGoing);
        this.delete_group.managedProperty().bind((ObservableValue)this.delete_group.visibleProperty());
        this.delete_group.visibleProperty().bind((ObservableValue)this.model.amISamuraiProperty().and((ObservableBooleanValue)this.model.keycloakProperty().not()));
        this.delete_group_sep.managedProperty().bind((ObservableValue)this.delete_group_sep.visibleProperty());
        this.delete_group_sep.visibleProperty().bind((ObservableValue)this.delete_group.visibleProperty());
    }

    private void initButtonModification(BooleanBinding updateOnGoing) {
        this.modification_button.textProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.model.editModeProperty()).then(ViewControllerHelper.getString("group_card_modification_button_save")).otherwise(ViewControllerHelper.getString("group_card_modification_button_modify")));
        this.modification_button.setOnAction(event -> {
            if (this.model.editModeProperty().get()) {
                if (GroupHelper.isGroupNameCompliant(this.model.getGroup(), this.getCurrentTitle())) {
                    AsyncTaskExecutor.submitTask(() -> {
                        this.save();
                        ViewControllerHelper.smartUIUpdate(() -> this.stopEditing());
                    });
                } else {
                    this.model.setErrorTitle(true);
                }
            } else {
                this.model.editModeProperty().set(true);
            }
        });
        this.modification_button.disableProperty().bind((ObservableValue)updateOnGoing);
    }

    private void save() {
        String currentDescription;
        String currentNote;
        boolean changeOccur = false;
        Optional<String> currentTitle = this.getCurrentTitle();
        if (!Objects.equals(currentTitle, this.model.getGroup().getCustomNameOrName())) {
            changeOccur = true;
        }
        Optional<String> nameUpdateOpt = Optional.of(currentTitle.orElse(""));
        Optional<Object> noteUpdate = Optional.empty();
        String string = currentNote = this.note_area.getText() == null ? null : this.note_area.getText().trim();
        if (!Objects.equals(Optional.ofNullable(currentNote), this.model.getGroup().getPersonalNote())) {
            changeOccur = true;
            noteUpdate = Optional.ofNullable(currentNote);
        }
        Optional<String> descriptionUpdate = Optional.empty();
        String string2 = currentDescription = this.description_area.getText() == null ? null : this.description_area.getText().trim().replace("\n", " ");
        if (!Objects.equals(Optional.ofNullable(currentDescription), this.model.getGroup().getDescription())) {
            changeOccur = true;
            descriptionUpdate = Optional.ofNullable(currentDescription);
        }
        Optional<Object> photoUpdate = Optional.empty();
        Optional<String> currentPhoto = this.model.getSelectedNewPhotoUrlAbsolutePath();
        if (!currentPhoto.equals(this.model.getGroup().getCustomPhotoUrlOrPhotoUrl())) {
            photoUpdate = currentPhoto;
            if (photoUpdate.isEmpty()) {
                photoUpdate = Optional.of("");
            }
            changeOccur = true;
        }
        boolean customPhotoChange = !currentPhoto.equals(this.model.getGroup().getCustomPhotoUrlOrPhotoUrl());
        noteUpdate.ifPresent(note -> GroupHelper.updatePersonalNoteInDB(this.model.getGroup(), Optional.of(note)));
        if (this.model.getOwnGroupPermission().isPresent() && this.model.getOwnGroupPermission().get().hasPermissionAdmin() && this.model.getAllGroupMembersPermissions().isPresent()) {
            Map<BytesKey, Set<String>> changePermissionMap = this.computeThePermissionChangeMap(this.model.getAllGroupMembersPermissions().get());
            HashMap<BytesKey, Set<String>> newMembersMap = new HashMap<BytesKey, Set<String>>();
            ((List)this.model.getNewMembersIdLiveData().getValue()).stream().map(DbCache.getInstance()::getContactInfo).forEach(optional -> optional.ifPresent(contact -> {
                boolean admin = this.model.getAdminChange().contains((Object)BytesKey.of(contact.bytesContactIdentity()));
                Set<String> permission = admin ? GroupHelper.getDefaultAdminPermissionsAsString() : GroupHelper.getDefaultMemberPermissionsAsString();
                newMembersMap.put(BytesKey.of(contact.bytesContactIdentity()), permission);
            }));
            if (!(this.model.getDeletesMembers().isEmpty() && changePermissionMap.isEmpty() && newMembersMap.isEmpty() && !changeOccur || !SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo().isPresent())) {
                GroupUpdateInput update = new GroupUpdateInput(SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo().get().bytesOwnedIdentity(), this.model.getGroup().getBytesGroupIdentifier(), nameUpdateOpt, descriptionUpdate, noteUpdate, photoUpdate, new HashSet<BytesKey>((Collection<BytesKey>)this.model.getDeletesMembers()), changePermissionMap, newMembersMap);
                Api.getGroupApi(this.model.getGroup().getVersion()).updateGroup(update);
            }
        } else {
            if (customPhotoChange) {
                GroupHelper.updateCustomGroupPhoto((Id<Group>)this.model.getGroup().getItemId(), currentPhoto);
            }
            currentTitle.ifPresent(s -> AsyncTaskExecutor.submitTask(() -> GroupHelper.updateGroupCustomName(this.model.getGroup(), currentTitle)));
        }
    }

    private Optional<String> getCurrentTitle() {
        return Optional.ofNullable(this.title_area.getText() == null || this.title_area.getText().isEmpty() ? null : this.title_area.getText().trim().replace("\n", " "));
    }

    private Map<BytesKey, Set<String>> computeThePermissionChangeMap(List<GroupMemberPermissions> membersPermissions) {
        return membersPermissions.stream().map(groupMemberPermissions -> {
            BytesKey key = this.getMemberBytesKey((GroupMemberPermissions)groupMemberPermissions);
            if (key == null) {
                return null;
            }
            if (this.model.getAdminChange().contains((Object)key) && !this.model.getDeletesMembers().contains((Object)key)) {
                Pair<BytesKey, Set<String>> permissionChange = new Pair<BytesKey, Set<String>>(key, GroupHelper.getStringsFromObvPermissions(groupMemberPermissions));
                GroupCardController.toggleAdminPermission(permissionChange);
                return permissionChange;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    private BytesKey getMemberBytesKey(GroupMemberPermissions groupMemberPermissions) {
        if (groupMemberPermissions.getContactGroupJoinId().isPresent()) {
            ContactGroupJoin contactGroupJoin = DbManager.getInstance().getContactGroupJoinDao().get(groupMemberPermissions.getContactGroupJoinId().get());
            Optional<ContactInfo> optionalContactInfo = DbCache.getInstance().getContactInfo(contactGroupJoin.getContactId());
            if (optionalContactInfo.isPresent()) {
                return BytesKey.of(optionalContactInfo.get().bytesContactIdentity());
            }
        }
        if (groupMemberPermissions.getPendingGroupMemberId().isPresent()) {
            PendingGroupMember pendingGroupMember = DbManager.getInstance().getPendingGroupMemberDao().get(groupMemberPermissions.getPendingGroupMemberId().get());
            ContactRef contactRef = DbManager.getInstance().getContactRefDao().get(pendingGroupMember.getContactRefId());
            return BytesKey.of(contactRef.getBytesContactIdentity());
        }
        return null;
    }

    private void stopEditing() {
        this.model.getDeletesMembers().clear();
        this.model.getAdminChange().clear();
        this.model.getNewMembersIdLiveData().postValue(List.of());
        this.model.editModeProperty().set(false);
        this.model.setSelectedNewPhotoUrlAbsolutePath(this.model.getGroup().getCustomPhotoUrlOrPhotoUrl());
        this.model.setErrorTitle(false);
    }

    private static void toggleAdminPermission(Pair<BytesKey, Set<String>> permissionChange) {
        if (permissionChange != null && !permissionChange.getSecond().remove(GroupV2.Permission.GROUP_ADMIN.getString())) {
            permissionChange.getSecond().addAll(GroupHelper.getDefaultAdminPermissionsAsString());
        }
    }

    private void initTextArea(BooleanBinding editAndAdmin) {
        this.title_area = new HeightBindTextArea(this.title_wrapper.widthProperty());
        this.title_area.setPromptText(ViewControllerHelper.getString("group_card_title_prompt_text"));
        this.title_area.getStyleClass().add((Object)"h1");
        this.title_area.editableProperty().bind((ObservableValue)this.model.editModeProperty());
        this.title_wrapper.getChildren().setAll((Object[])new Node[]{this.title_area});
        this.description_area = new HeightBindTextArea(this.description_wrapper.widthProperty());
        this.description_area.setPromptText(ViewControllerHelper.getString("group_card_description_prompt_text"));
        this.description_area.getStyleClass().add((Object)"body-1");
        this.description_area.editableProperty().bind((ObservableValue)editAndAdmin);
        this.description_wrapper.getChildren().setAll((Object[])new Node[]{this.description_area});
        this.description_wrapper.visibleProperty().bind((ObservableValue)this.description_area.textProperty().isNotEmpty().or((ObservableBooleanValue)editAndAdmin));
        this.description_wrapper.managedProperty().bind((ObservableValue)this.description_wrapper.visibleProperty());
        this.note_area = new HeightBindTextArea(this.personal_note_wrapper.widthProperty());
        this.note_area.setPromptText(ViewControllerHelper.getString("group_card_note_prompt_text"));
        this.note_area.getStyleClass().addAll((Object[])new String[]{"personal-note", "body-1"});
        this.note_area.editableProperty().bind((ObservableValue)this.model.editModeProperty());
        this.personal_note_wrapper.getChildren().setAll((Object[])new Node[]{this.note_area});
        this.personal_note_wrapper.visibleProperty().bind((ObservableValue)this.note_area.textProperty().isNotEmpty().or((ObservableBooleanValue)this.model.editModeProperty()));
        this.personal_note_wrapper.managedProperty().bind((ObservableValue)this.personal_note_wrapper.visibleProperty());
    }

    @Override
    public Region getLayout() {
        return this.root;
    }

    @Override
    public void onLayoutAttached() {
        this.model.plug(this.groupChangeListener, this.ownPermissionListener);
    }

    @Override
    public void onLayoutDetached() {
        if (this.model != null) {
            this.model.editModeProperty().removeListener(this.booleanChangeListener);
            this.model.unplug();
        }
        this.navigation.getRightPanelContext().getIsStatesHistoryEmpty().removeListener(this.navigationEmptyLiveDataListener);
        this.members_box.unplug();
        this.members_box.getChildren().clear();
    }

    private void onOwnGroupPermissionsChange(GroupMemberPermissions newValue, GroupMemberPermissions oldValue) {
        if (this.model != null) {
            ViewControllerHelper.smartUIUpdate(() -> this.model.amISamuraiProperty().set(newValue != null && newValue.hasPermissionAdmin()));
        }
    }

    private void onGroupChanged(Group group, Group oGroup) {
        ViewControllerHelper.smartUIUpdate(() -> {
            if (group == null) {
                return;
            }
            this.model.setV2(group.isV2());
            this.model.setUpdateState(group.getUpdateInProgress());
            this.model.setKeycloak(group.isKeycloakManaged());
            BubbleUtils.setBubbleData(group, this.group_bubble);
            this.model.setSelectedNewPhotoUrlAbsolutePath(group.getCustomPhotoUrlOrPhotoUrl());
            if (!this.model.isEditMode()) {
                this.title_area.setText(group.getDisplayName().orElse(ViewControllerHelper.getString("unnamed_group")));
            }
            this.note_area.setText(group.getPersonalNote().orElse(null));
            this.description_area.setText(group.getDescription().orElse(null));
        });
    }

    private void handleContactSelected(ContactInfo contact) {
        if (!this.model.isEditMode()) {
            RightPanelContextState.ContactCard newState = new RightPanelContextState.ContactCard(contact.genId());
            this.navigation.getRightPanelContext().updateLocalContext(newState, false);
        }
    }

    private void handleContactSelected(PendingGroupMemberInfo pendingGroupMember) {
        if (!this.model.isEditMode()) {
            AsyncTaskExecutor.submitTask(() -> {
                if (pendingGroupMember.contactInfo().isPresent()) {
                    RightPanelContextState.ContactCard newState = new RightPanelContextState.ContactCard(pendingGroupMember.contactInfo().get().genId());
                    this.navigation.getRightPanelContext().updateLocalContext(newState, false);
                }
            });
        }
    }

    private void addMembersButtonHandler(Event event) {
        if (this.model.getGroup() != null && this.model.amISamuraiProperty().get()) {
            NCRegistry.getUIActionNC().postNotification(new ModalNotification(new AddGroupMemberModalController(this.model.getGroup(), contactInfos -> this.model.getNewMembersIdLiveData().postValue((List<Id<Contact>>)contactInfos), this.model.getNewMembersInfoLiveData().getValue())));
        }
    }

    private void goToDiscussionHandler(Event event) {
        AsyncTaskExecutor.submitTask(() -> {
            Discussion associatedDiscussion = this.model.getAssociatedDiscussion();
            DiscussionApi.unHideDiscussionIfHiddenDbTask(associatedDiscussion);
            NCRegistry.getUIActionNC().postNotification(GenericNotification.of(UIActionNC.UserInteractionNotificationEnumType.DISCUSSION_SELECTED, associatedDiscussion.getItemId()));
        });
    }

    private void disbandGroupButtonHandler(ActionEvent mouseEvent) {
        if (this.model.getGroup() != null && this.model.amISamuraiProperty().get() && SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo().isPresent()) {
            if (Api.getGroupApi(this.model.getGroup().getVersion()).disbandGroup(SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo().get().bytesOwnedIdentity(), this.model.getGroup().getBytesGroupIdentifier())) {
                this.navigation.getRightPanelContext().goToPreviousState();
            }
            UIActionNC.fireGroupSelectedNotification(Optional.empty(), true);
        }
    }

    private void leaveGroupButtonHandler(ActionEvent mouseEvent) {
        if (this.model.getGroup() != null && SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo().isPresent()) {
            Api.getGroupApi(this.model.getGroup().getVersion()).leaveGroup(SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo().get().bytesOwnedIdentity(), this.model.getGroup().getBytesGroupIdentifier());
            UIActionNC.fireGroupSelectedNotification(Optional.empty(), true);
        }
    }

    private void editPhotoButtonHandler(ActionEvent event) {
        if (this.model.getGroup() == null) {
            return;
        }
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(ViewControllerHelper.getString("photo_chooser_title"));
        String homePath = AppRuntimeHelper.USER_HOME_DIR_ABSOLUTE_PATH;
        File homeFile = homePath == null ? null : new File(homePath);
        fileChooser.setInitialDirectory(homeFile);
        File photo = fileChooser.showOpenDialog(ViewControllerHelper.MAIN_STAGE.getOwner());
        if (photo != null && !photo.getAbsolutePath().isEmpty()) {
            AsyncTaskExecutor.submitTask(() -> FileApi._resizeCompressAndEncryptImageTask(photo.getAbsolutePath(), 1080, 1080, this::resizeAndCompressSucceeded, error -> AppLogger.e("GroupManagementService: importAndUpdateGroupPhotoTask: task error: " + String.valueOf(error))));
        }
    }

    private void resizeAndCompressSucceeded(String relativePath) {
        this.group_bubble.setPhotoUrlRelPath(Optional.ofNullable(relativePath));
        this.model.setSelectedNewPhotoUrlAbsolutePath(relativePath == null ? Optional.empty() : Optional.of(FileApi.absolutePathFromRelative(relativePath)));
    }

    public record MemberInfo(Either<ContactInfo, PendingGroupMemberInfo> either) implements Diffable,
    Comparable<MemberInfo>
    {
        static MemberInfo of(ContactInfo contactInfo) {
            return new MemberInfo(Either.left(contactInfo));
        }

        static MemberInfo of(PendingGroupMemberInfo pendingGroupMemberInfo) {
            return new MemberInfo(Either.right(pendingGroupMemberInfo));
        }

        public String getDisplayName() {
            if (this.either.isRight()) {
                return this.either.getRight().getCustomOrDisplayName(IdentityDetailsInfo.Format.FIRST_LAST);
            }
            return this.either.getLeft().getCustomOrDisplayName(IdentityDetailsInfo.Format.FIRST_LAST);
        }

        public String getPositionCompany() {
            if (this.either.isRight()) {
                return this.either.getRight().detailsInfo().getDisplayName(IdentityDetailsInfo.Format.POSITION_COMPANY);
            }
            return this.either.getLeft().detailsInfo().getDisplayName(IdentityDetailsInfo.Format.POSITION_COMPANY);
        }

        public byte[] getBytesContactIdentity() {
            if (this.either.isRight()) {
                return this.either.getRight().bytesContactIdentity();
            }
            return this.either.getLeft().bytesContactIdentity();
        }

        @Override
        public boolean areContentTheSame(Object obj) {
            return this.equals(obj);
        }

        @Override
        public Object getItemId() {
            if (this.either.isLeft()) {
                return this.either.getLeft().getItemId();
            }
            return this.either.getRight().getItemId();
        }

        @Override
        public int compareTo(@NotNull MemberInfo o) {
            return this.getDisplayName().compareTo(o.getDisplayName());
        }
    }
}

