/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.groups;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.discussions.discussion_modal_new.DiscussionFlowId;
import io.olvid.windows.messenger.fx.generic_types.list_view.AbstractListCell;
import io.olvid.windows.messenger.fx.generic_types.list_view.StandardPanelListController;
import io.olvid.windows.messenger.fx.generic_types.list_view.controller.SearchBarController;
import io.olvid.windows.messenger.fx.groups.group_management.creation.FlowConstructor;
import io.olvid.windows.messenger.fx.groups.groups_list.GroupListCell;
import io.olvid.windows.messenger.fx.helpers.ListItemSearchHelper;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.main_stack.main_layer.left_panel.tabs_management.BaseNavBarTab;
import io.olvid.windows.messenger.fx.modal.standard_ui.flow.ModalFlowController;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.misc.Either;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.GenericNotification;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.ModalNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.UIActionNC;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.util.Callback;

public class GroupTabController
extends BaseNavBarTab {
    private final StandardPanelListController<Group> groupListViewController = this.initiateInnerNode();
    private final Button tabButton;

    public GroupTabController() {
        super.buildStandardTab(Either.left(ViewControllerHelper.RESOURCE_BUNDLE.getString("left.panel.group.title")), Optional.empty(), Optional.of("svg-plus"), Optional.of(this::openModal), Optional.empty(), Optional.empty(), Optional.empty(), new Node[]{this.groupListViewController.getLayout()});
        this.tabButton = this.createButton("svg-groups");
    }

    private StandardPanelListController<Group> initiateInnerNode() {
        LiveData liveData = LiveDataFactory.switchMap(SelectedOwnedIdentitySingleton.getInstance().currentOwnedIdentityId, ownedIdentity -> ownedIdentity.map(id -> LiveDataFactory.buildDbLiveDataList(Group.class, () -> DbManager.getInstance().getGroupDao().getGroupsAssociatedToIdentity((Id<OwnedIdentity>)id), List.of(Group.class))).orElse(null));
        StandardPanelListController<Group> groupListViewController = StandardPanelListController.builder().withLiveData(liveData).withDataClass(Group.class).withCellFactory((Callback<ListView<Group>, AbstractListCell<Group>>)((Callback)param -> this.buildCell())).withoutBottomMargin().setComparator(Comparator.comparing(group -> group.getDisplayName().orElse(""))).noFilter().setSearchPredicate(ListItemSearchHelper::groupSearchPredicate).withSingleSelection().withDisableUnselect(false).withoutButton(this::onSelectedGroup).build();
        ViewControllerHelper.smartUIUpdate(() -> {
            Optional<SearchBarController> searchBarControllerOpt = groupListViewController.getSearchBar();
            searchBarControllerOpt.ifPresent(searchBarController -> VBox.setMargin((Node)searchBarController.getLayout(), (Insets)new Insets(18.0, 10.0, 0.0, 10.0)));
            VBox.setMargin(groupListViewController.getListView(), (Insets)new Insets(12.0, 8.0, 0.0, 8.0));
            groupListViewController.getListView().fixedCellSizeProperty().set(80.0);
            groupListViewController.getListView().getStyleClass().add((Object)"hoverable-list");
            ViewControllerHelper.setNodeAnchorPaneAttributes((Node)groupListViewController.getLayout(), 0.0, 0.0, 0.0, 0.0);
        });
        return groupListViewController;
    }

    @Override
    public void onLayoutAttached() {
    }

    @Override
    public void onLayoutDetached() {
        super.onLayoutDetached();
        if (this.groupListViewController.getSelectionModel() != null) {
            this.groupListViewController.getListModel().unPlug();
            this.groupListViewController.setListModel(null);
        }
    }

    @Override
    public Button getNavBarButton() {
        return this.tabButton;
    }

    @Override
    public Region getLayout() {
        return this.tabContainer;
    }

    public void onSelectedGroup(Group group, Node node) {
        AsyncTaskExecutor.submitTask(() -> {
            Discussion discussion = DbManager.getInstance().getDiscussionDao().getDiscussionFromGroupIdentifier(group.getBytesGroupIdentifier(), group.getOwnedIdentityId());
            if (discussion != null) {
                NCRegistry.getUIActionNC().postNotification(GenericNotification.of(UIActionNC.UserInteractionNotificationEnumType.DISCUSSION_SELECTED, discussion.getItemId()));
            } else {
                UIActionNC.fireGroupSelectedNotification(Optional.of(group.getItemId()), true);
            }
        });
    }

    private AbstractListCell<Group> buildCell() {
        GroupListCell groupListCell = new GroupListCell();
        groupListCell.prefWidthProperty().bind((ObservableValue)this.groupListViewController.getListView().widthProperty());
        groupListCell.setMaxWidth(Double.NEGATIVE_INFINITY);
        groupListCell.setMinWidth(Double.NEGATIVE_INFINITY);
        return groupListCell;
    }

    private void openModal(ActionEvent event) {
        ModalFlowController<DiscussionFlowId> groupModal = new ModalFlowController<DiscussionFlowId>();
        FlowConstructor.initGroupModal(groupModal);
        groupModal.setState(FlowConstructor.GroupFlowStateId.MEMBER_SELECTION);
        NCRegistry.getUIActionNC().postNotification(new ModalNotification(groupModal));
    }

    @Override
    public SvgSizeable getNavBarButtonIcon() {
        return (SvgSizeable)this.tabButton.getGraphic();
    }
}

