/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.generic_types.list_view.controller;

import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.richtextfx.TextFieldStyledArea;
import io.olvid.windows.messenger.fx.modal.standard_ui.button.ButtonBuilder;
import io.olvid.windows.messenger.livedata.Diffable;
import io.olvid.windows.messenger.misc.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.transformation.FilteredList;
import javafx.css.PseudoClass;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;

public class SearchBarController
extends BaseViewController {
    public final TextFieldStyledArea textField = new TextFieldStyledArea();
    public final HBox root = new HBox();
    private Consumer<String> customSearch;
    private final ChangeListener<String> inputChangeListener = this::customSearchTextListener;

    public SearchBarController() {
        this.root.getStyleClass().add((Object)"search-bar");
        this.root.getChildren().add((Object)this.textField);
        this.textField.getStyleClass().add((Object)"text");
        Text placeholder = new Text(ViewControllerHelper.getString("left.panel.discussion.search"));
        placeholder.getStyleClass().addAll((Object[])new String[]{"body", "grey-text"});
        this.textField.setPlaceholder((Node)placeholder, Pos.BASELINE_LEFT);
        this.root.setAlignment(Pos.CENTER);
        this.textField.setPadding(new Insets(0.0, 0.0, 0.0, 16.0));
        this.textField.focusedProperty().addListener((observable, oldValue, newValue) -> this.root.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"focused"), newValue.booleanValue()));
        this.textField.maxHeightProperty().bind((ObservableValue)Bindings.divide((ObservableNumberValue)this.root.heightProperty(), (int)2));
        HBox.setHgrow((Node)this.textField, (Priority)Priority.ALWAYS);
        SvgSizeable search = new SvgSizeable();
        search.getStyleClass().addAll((Object[])new String[]{"svg-search", "icon-large", "icon-grey"});
        search.visibleProperty().bind(this.textField.plainTextProperty().map(String::isEmpty));
        SvgSizeable close = new SvgSizeable();
        close.getStyleClass().addAll((Object[])new String[]{"svg-close", "icon-large", "icon-grey"});
        close.visibleProperty().bind(this.textField.plainTextProperty().map(s -> !s.isEmpty()));
        StackPane clearButtonGraphic = new StackPane();
        clearButtonGraphic.getChildren().addAll((Object[])new Node[]{search, close});
        Button clearButton = new ButtonBuilder().withAction((EventHandler<MouseEvent>)((EventHandler)event -> {
            this.textField.clear();
            this.textField.requestFocus();
        })).withGraphic((Node)clearButtonGraphic).build().button();
        this.root.getChildren().add((Object)clearButton);
    }

    @Override
    public Region getLayout() {
        return this.root;
    }

    @Override
    public void onLayoutAttached() {
    }

    @Override
    public void onLayoutDetached() {
    }

    public <DataType extends Diffable> void bindFilter(BiFunction<DataType, List<Pattern>, Boolean> searchPredicate, FilteredList<DataType> filteredList, Optional<Predicate<DataType>> additionalPredicate) {
        Predicate<Diffable> textPredicate = dataType -> {
            if (this.textField.getText() == null || this.textField.getText().isEmpty()) {
                return true;
            }
            ArrayList<Pattern> filterPatterns = SearchBarController.getNewPredicate(this.textField.getText());
            if (dataType == null) {
                return true;
            }
            return (Boolean)searchPredicate.apply(dataType, filterPatterns);
        };
        filteredList.predicateProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> {
            if (additionalPredicate.isEmpty()) {
                return textPredicate;
            }
            return textPredicate.and((Predicate)additionalPredicate.get());
        }, (Observable[])new Observable[]{this.textField.textProperty()}));
    }

    public void addCustomSearchListener(Consumer<String> customSearchTextConsumer) {
        if (this.customSearch == null) {
            this.customSearch = customSearchTextConsumer;
            this.textField.textProperty().addListener(this.inputChangeListener);
        }
    }

    public void removeCustomSearchListener() {
        this.customSearch = null;
        this.textField.textProperty().removeListener(this.inputChangeListener);
    }

    private void customSearchTextListener(ObservableValue<? extends String> observable, String oldValue, String newValue) {
        if (newValue != null) {
            this.customSearch.accept(newValue);
        }
    }

    public static ArrayList<Pattern> getNewPredicate(String prompt) {
        String[] parts = prompt.trim().split("\\s+");
        ArrayList<Pattern> filterPatterns = new ArrayList<Pattern>(parts.length);
        for (String part : parts) {
            if (part.isEmpty()) continue;
            filterPatterns.add(Pattern.compile(Pattern.quote(StringUtils.unAccent(part))));
        }
        return filterPatterns;
    }

    public ObservableValue<String> getTextProperty() {
        return this.textField.textProperty();
    }

    public void focus() {
        this.textField.requestFocus();
    }
}

