/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.generic_types.list_view;

import io.olvid.windows.messenger.fx.generic_types.list_view.AbstractListCell;
import io.olvid.windows.messenger.fx.generic_types.list_view.StandardPanelListController;
import io.olvid.windows.messenger.fx.generic_types.list_view.controller.ButtonController;
import io.olvid.windows.messenger.fx.generic_types.list_view.controller.SearchBarController;
import io.olvid.windows.messenger.fx.generic_types.list_view.model.ListPanelSelectModel;
import io.olvid.windows.messenger.livedata.Diffable;
import io.olvid.windows.messenger.livedata.LiveData;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javafx.scene.Node;
import javafx.scene.control.ListView;
import javafx.util.Callback;

public interface BuilderInterface<DataType extends Diffable> {
    public StandardPanelListController<DataType> build();

    public static interface Buttonable<DataType extends Diffable> {
        public BuilderInterface<DataType> withoutButton();

        public BuilderInterface<DataType> withoutButton(BiConsumer<DataType, Node> var1);

        public BuilderInterface<DataType> withButtonController(ButtonController var1);
    }

    public static interface DisableUnselect<DataType extends Diffable> {
        public Buttonable<DataType> withDisableUnselect(boolean var1);
    }

    public static interface Selectable<DataType extends Diffable> {
        public Selectable<DataType> setListSelectionModel(ListPanelSelectModel<DataType> var1);

        public Buttonable<DataType> withoutSelection();

        public DisableUnselect<DataType> withSingleSelection();

        public Buttonable<DataType> withMultipleSelection();
    }

    public static interface Predicatable<DataType extends Diffable> {
        public Predicatable<DataType> setSearchBar(SearchBarController var1);

        public Selectable<DataType> setCustomSearchTextConsumer(Consumer<String> var1);

        public Selectable<DataType> setSearchPredicate(BiFunction<DataType, List<Pattern>, Boolean> var1);

        public Selectable<DataType> withoutSearch();
    }

    public static interface Filterable<DataType extends Diffable> {
        public Predicatable<DataType> setFilter(Predicate<DataType> var1);

        public Predicatable<DataType> noFilter();
    }

    public static interface Sortable<DataType extends Diffable> {
        public Filterable<DataType> setComparator(Comparator<DataType> var1);

        public Filterable<DataType> defaultComparator();
    }

    public static interface Marginable<DataType extends Diffable> {
        public Sortable<DataType> withFixBottomMargin(Optional<Double> var1);

        default public Sortable<DataType> withoutBottomMargin() {
            return this.withFixBottomMargin(Optional.empty());
        }
    }

    public static interface CellFactoryable<DataType extends Diffable> {
        public Marginable<DataType> withCellFactory(Callback<ListView<DataType>, AbstractListCell<DataType>> var1);
    }

    public static interface DataTypeable<DataType extends Diffable> {
        public CellFactoryable<DataType> withDataClass(Class<DataType> var1);
    }

    public static interface LiveDatable {
        public <DataType extends Diffable> DataTypeable<DataType> withLiveData(LiveData<List<DataType>> var1);
    }
}

