/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.generic_types.flow_view;

import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.generic_types.flow_view.CellWithItem;
import io.olvid.windows.messenger.fx.generic_types.flow_view.FlowListBuilder;
import io.olvid.windows.messenger.fx.generic_types.flow_view.FlowListModel;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.livedata.Diffable;
import io.olvid.windows.messenger.livedata.LiveData;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.fxmisc.flowless.VirtualFlow;
import org.fxmisc.flowless.VirtualizedScrollPane;

public final class FlowListViewController<T extends Diffable>
extends BaseViewController {
    private final VirtualizedScrollPane<VirtualFlow<ObjectProperty<T>, CellWithItem<T>>> scrollPane;
    private final VirtualFlow<ObjectProperty<T>, CellWithItem<T>> virtualFlow;
    public final FlowListModel<T> model;
    private final BiConsumer<T, Node> clickAction;
    private final Function<ObjectProperty<T>, CellWithItem<T>> cellFactory;
    private final BooleanProperty isLastItemVisible = new SimpleBooleanProperty(true);
    private final ListChangeListener<CellWithItem<T>> cellWithItemListChangeListener = this::visibleCellsChanged;

    FlowListViewController(FlowListBuilder<T> builder) {
        this.model = new FlowListModel<T>(builder, this);
        this.clickAction = builder.clickAction;
        this.cellFactory = builder.cellFactory;
        this.virtualFlow = VirtualFlow.createVertical(this.model.getItems(), this::buildCell, (VirtualFlow.Gravity)VirtualFlow.Gravity.FRONT);
        this.scrollPane = new VirtualizedScrollPane(this.virtualFlow, ScrollPane.ScrollBarPolicy.NEVER, ScrollPane.ScrollBarPolicy.ALWAYS);
        if (builder.needLastItemVisibilityProperty) {
            this.virtualFlow.visibleCells().addListener(this.cellWithItemListChangeListener);
        }
        VBox.setVgrow(this.scrollPane, (Priority)Priority.ALWAYS);
        this.bindSceneProperty();
    }

    private CellWithItem<T> buildCell(ObjectProperty<T> value) {
        CellWithItem<T> cell = this.cellFactory.apply(value);
        cell.getNode().setOnMouseClicked(event -> {
            if (event == null || MouseButton.PRIMARY != event.getButton()) {
                return;
            }
            Optional itemOpt = cell.getItem();
            if (itemOpt.isEmpty()) {
                return;
            }
            Diffable item = (Diffable)itemOpt.get();
            if (this.clickAction != null) {
                EventTarget target = event.getTarget();
                if (target instanceof Node) {
                    Node node = (Node)target;
                    this.clickAction.accept(item, node);
                } else {
                    this.logger.error("clicked on target that is not a Node -> " + String.valueOf(target.getClass()));
                }
            }
        });
        return cell;
    }

    public void showAsFirst(int itemIdx) {
        this.virtualFlow.showAsFirst(itemIdx);
    }

    public void showAsLast(int itemIdx) {
        this.virtualFlow.showAsLast(itemIdx);
    }

    public void scrollToBottom() {
        this.virtualFlow.showAsLast(this.model.getItems().size() - 1);
    }

    private boolean repositionLastItem(T t, int idx) {
        Optional itemOpt;
        ViewControllerHelper.checkUIThread();
        Optional lastCellOpt = this.virtualFlow.getCellIfVisible(idx);
        if (lastCellOpt.isPresent() && (itemOpt = ((CellWithItem)lastCellOpt.get()).getItem()).isPresent() && ((Diffable)itemOpt.get()).equals(t)) {
            this.virtualFlow.showAsLast(idx);
            return true;
        }
        return false;
    }

    public int getFirstVisibleIndex() {
        return this.virtualFlow.getFirstVisibleIndex();
    }

    public int getLastVisibleIndex() {
        return this.virtualFlow.getLastVisibleIndex();
    }

    public boolean isVisible(int itemIdx) {
        return this.getFirstVisibleIndex() <= itemIdx && itemIdx <= this.getLastVisibleIndex();
    }

    public BooleanProperty isLastItemVisible() {
        return this.isLastItemVisible;
    }

    public void show(T t) {
        int lastVisibleIndex = this.virtualFlow.getLastVisibleIndex();
        if (lastVisibleIndex <= 3) {
            return;
        }
        if (this.repositionLastItem(t, lastVisibleIndex)) {
            return;
        }
        if (this.repositionLastItem(t, lastVisibleIndex - 1)) {
            return;
        }
    }

    public VirtualizedScrollPane<VirtualFlow<ObjectProperty<T>, CellWithItem<T>>> getLayout() {
        return this.scrollPane;
    }

    @Override
    public void onLayoutAttached() {
    }

    @Override
    public void onLayoutDetached() {
        this.virtualFlow.visibleCells().removeListener(this.cellWithItemListChangeListener);
    }

    public static <T extends Diffable> FlowListBuilder<T> builder(Class<T> clazz, LiveData<List<T>> liveData, Function<ObjectProperty<T>, CellWithItem<T>> cellFactory) {
        return new FlowListBuilder<T>(clazz, liveData, cellFactory);
    }

    private void visibleCellsChanged(ListChangeListener.Change<? extends CellWithItem<T>> c) {
        ObservableList<ObjectProperty<T>> items = this.model.getItems();
        if (items.isEmpty()) {
            this.isLastItemVisible.set(true);
            return;
        }
        Diffable last = (Diffable)((ObjectProperty)items.getLast()).get();
        if (last == null) {
            this.isLastItemVisible.set(true);
            return;
        }
        ObservableList visibleCells = c.getList();
        if (visibleCells.isEmpty()) {
            this.isLastItemVisible.set(true);
            return;
        }
        for (CellWithItem visibleCell : visibleCells) {
            Diffable item;
            Optional itemOpt = visibleCell.getItem();
            if (itemOpt.isEmpty() || !(item = (Diffable)itemOpt.get()).getItemId().equals(last.getItemId())) continue;
            this.isLastItemVisible.set(true);
            return;
        }
        this.isLastItemVisible.set(false);
    }
}

