/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.generic_types.flow_view;

import io.olvid.windows.messenger.fx.generic_types.DiffUtils;
import io.olvid.windows.messenger.fx.generic_types.flow_view.FlowListBuilder;
import io.olvid.windows.messenger.fx.generic_types.flow_view.FlowListConfiguration;
import io.olvid.windows.messenger.fx.generic_types.flow_view.FlowListViewController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.livedata.Diffable;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.Pair;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.scene.Scene;

public class FlowListModel<T extends Diffable> {
    private final AppLogger logger = new AppLogger(FlowListModel.class);
    private final LiveData<List<T>> liveData;
    private final FlowListViewController<T> controller;
    private final ObservableList<ObjectProperty<T>> items = FXCollections.observableArrayList();
    private final SortedList<ObjectProperty<T>> sortedItems;
    private final LiveDataListener<List<T>> itemsChangeListener = this::itemsChangeListener;
    private final BooleanProperty isSearchModeActive = new SimpleBooleanProperty();
    private final FlowListConfiguration<T> flowListConfiguration;

    public FlowListModel(FlowListBuilder<T> builder, FlowListViewController<T> controller) {
        this.liveData = builder.liveData;
        this.controller = controller;
        this.flowListConfiguration = builder.flowListConfiguration;
        this.sortedItems = builder.comparator != null ? new SortedList(this.items) : null;
        this.liveData.addListener(this.itemsChangeListener);
    }

    private void itemsChangeListener(List<T> newValues, List<T> oldValues) {
        ViewControllerHelper.smartUIUpdate(() -> {
            if (newValues == null) {
                this.items.clear();
                return;
            }
            boolean deepChange = false;
            if (this.flowListConfiguration != null) {
                this.flowListConfiguration.listWillChange(newValues, oldValues);
                deepChange = this.flowListConfiguration.isDeepChange(newValues, oldValues);
            }
            if (deepChange) {
                DiffUtils.replace(newValues, this.items);
            } else {
                DiffUtils.applyChanges2(newValues, this.items);
            }
            if (this.isSearchModeActive.not().get()) {
                this.doScroll(newValues, oldValues);
            }
        });
    }

    public void bindSearchModeProperty(BooleanProperty isSearchModeActive) {
        this.isSearchModeActive.bind((ObservableValue)isSearchModeActive);
    }

    public void doScroll(List<T> newValues, List<T> oldValues) {
        if (this.flowListConfiguration == null) {
            return;
        }
        int lastVisibleIndex = this.controller.getLastVisibleIndex();
        if (lastVisibleIndex == -1) {
            Scene scene = this.controller.getLayout().getScene();
            new PostScroll(scene, newValues, oldValues);
            return;
        }
        Pair<Integer, FlowListConfiguration.Position> scroll = this.flowListConfiguration.scrollTo(newValues, oldValues);
        FlowListConfiguration.Position kind = scroll.getSecond();
        Integer idx = scroll.getFirst();
        switch (kind) {
            case NONE: {
                break;
            }
            case FIRST: {
                this.logger.warning("doScroll::showAsFirst idx ->  " + idx);
                this.controller.showAsFirst(idx);
                break;
            }
            case LAST: {
                this.logger.warning("doScroll::showAsLast idx ->  " + idx);
                this.controller.showAsLast(idx);
            }
        }
        this.flowListConfiguration.scrollWasDone();
    }

    public ObservableList<ObjectProperty<T>> getItems() {
        if (this.sortedItems != null) {
            return this.sortedItems;
        }
        return this.items;
    }

    private class PostScroll
    implements Runnable {
        private final Scene scene;
        private final List<T> newValues;
        private final List<T> oldValues;

        public PostScroll(Scene scene, List<T> newValues, List<T> oldValues) {
            this.scene = scene;
            this.newValues = newValues;
            this.oldValues = oldValues;
            scene.addPostLayoutPulseListener((Runnable)this);
        }

        @Override
        public void run() {
            if (FlowListModel.this.isSearchModeActive.not().get()) {
                FlowListModel.this.doScroll(this.newValues, this.oldValues);
            }
            this.scene.removePostLayoutPulseListener((Runnable)this);
        }
    }
}

