/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.generic_types.flow_view;

import io.olvid.windows.messenger.fx.generic_types.flow_view.CellWithItem;
import io.olvid.windows.messenger.fx.generic_types.flow_view.FlowListBuilderInterface;
import io.olvid.windows.messenger.fx.generic_types.flow_view.FlowListConfiguration;
import io.olvid.windows.messenger.fx.generic_types.flow_view.FlowListViewController;
import io.olvid.windows.messenger.livedata.Diffable;
import io.olvid.windows.messenger.livedata.LiveData;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javafx.beans.property.ObjectProperty;
import javafx.scene.Node;

public class FlowListBuilder<T extends Diffable>
implements FlowListBuilderInterface.Scrollable<T>,
FlowListBuilderInterface.Sortable<T>,
FlowListBuilderInterface.Selectable<T>,
FlowListBuilderInterface.Buildable<T> {
    final Class<T> clazz;
    final LiveData<List<T>> liveData;
    final Function<ObjectProperty<T>, CellWithItem<T>> cellFactory;
    boolean needLastItemVisibilityProperty = false;
    Comparator<T> comparator = null;
    BiConsumer<T, Node> clickAction = null;
    FlowListConfiguration<T> flowListConfiguration = null;

    public FlowListBuilder(Class<T> clazz, LiveData<List<T>> liveData, Function<ObjectProperty<T>, CellWithItem<T>> cellFactory) {
        this.clazz = clazz;
        this.liveData = liveData;
        this.cellFactory = cellFactory;
    }

    @Override
    public FlowListBuilderInterface.Scrollable<T> withLastItemVisibilityProperty() {
        this.needLastItemVisibilityProperty = true;
        return this;
    }

    @Override
    public FlowListBuilderInterface.Sortable<T> noAutoScroll() {
        return this;
    }

    @Override
    public FlowListBuilderInterface.Sortable<T> autoScroll(FlowListConfiguration<T> configuration) {
        this.flowListConfiguration = configuration;
        return this;
    }

    @Override
    public FlowListBuilderInterface.Selectable<T> setComparator(Comparator<T> comparator) {
        this.comparator = comparator;
        return this;
    }

    @Override
    public FlowListBuilderInterface.Selectable<T> unsorted() {
        return this;
    }

    @Override
    public FlowListBuilderInterface.Buildable<T> clickAction(BiConsumer<T, Node> clickAction) {
        this.clickAction = clickAction;
        return this;
    }

    @Override
    public FlowListBuilderInterface.Buildable<T> withoutSelection() {
        return this;
    }

    @Override
    public FlowListViewController<T> build() {
        return new FlowListViewController(this);
    }
}

