/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.framework.view_controller;

import io.olvid.windows.messenger.fx.framework.annotations.FXMLView;
import io.olvid.windows.messenger.fx.framework.view_controller.ViewControllerLifeCycle;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.logger.AppLogger;
import java.lang.ref.Cleaner;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.concurrent.LinkedBlockingQueue;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Scene;
import javafx.scene.layout.Region;

public abstract class BaseViewController
implements ViewControllerLifeCycle {
    private final ChangeListener<Scene> sceneChangeListener = new SceneChangeListener();
    protected final AppLogger logger = new AppLogger(this.getClass());
    private static final Cleaner cleaner = Cleaner.create();
    final CleanAction cleanAction = new CleanAction();

    protected void loadFxml() {
        String fxmlPathFromAnnotation = this.getFxmlPathFromAnnotation();
        ViewControllerHelper.loadNodeWithExplicitController(this, fxmlPathFromAnnotation);
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        this.bindSceneProperty();
        cleaner.register(this, this.cleanAction);
    }

    public final void addOnDestroyAction(Runnable action) {
        this.cleanAction.onDestroyActions.add(action);
    }

    protected void bindSceneProperty() {
        this.getLayout().sceneProperty().addListener(this.sceneChangeListener);
    }

    public abstract Region getLayout();

    @Override
    public abstract void onLayoutAttached();

    @Override
    public abstract void onLayoutDetached();

    private String getFxmlPathFromAnnotation() {
        if (this.getClass().isAnnotationPresent(FXMLView.class)) {
            return this.getClass().getAnnotation(FXMLView.class).path();
        }
        this.logger.warning("Can't find annotation to get associated fxml path....class in fault : " + this.getClass().getSimpleName());
        return null;
    }

    class SceneChangeListener
    implements ChangeListener<Scene> {
        SceneChangeListener() {
        }

        public void changed(ObservableValue<? extends Scene> observable, Scene oldScene, Scene newScene) {
            if (newScene == null) {
                BaseViewController.this.onLayoutDetached();
            } else {
                BaseViewController.this.onLayoutAttached();
            }
        }
    }

    private static final class CleanAction
    implements Runnable {
        private final LinkedBlockingQueue<Runnable> onDestroyActions = new LinkedBlockingQueue();

        @Override
        public void run() {
            ArrayList actions = new ArrayList();
            this.onDestroyActions.drainTo(actions);
            for (Runnable action : actions) {
                action.run();
            }
        }
    }
}

