/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.framework.utils;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.shape.SVGPath;

public class SVGBuilder {
    private final Double targetHeight;
    private final Double viewBoxHeight;
    private final Double targetWidth;
    private final Double viewBoxWidth;
    private final List<SVGPath> pathList;

    public SVGBuilder(Double targetHeight, Double viewBoxHeight) {
        this.targetHeight = targetHeight;
        this.viewBoxHeight = viewBoxHeight;
        this.targetWidth = this.targetHeight;
        this.viewBoxWidth = this.viewBoxHeight;
        this.pathList = new ArrayList<SVGPath>();
    }

    public SVGBuilder(Double targetHeight, Double viewBoxHeight, Double targetWidth, Double viewBoxWidth) {
        this.targetHeight = targetHeight;
        this.viewBoxHeight = viewBoxHeight;
        this.targetWidth = targetWidth;
        this.viewBoxWidth = viewBoxWidth;
        this.pathList = new ArrayList<SVGPath>();
    }

    public SVGBuilder addSVGPath(SVGPath path) {
        this.pathList.add(path);
        return this;
    }

    public SVGBuilder addSVGPath(SVGPath ... paths) {
        this.pathList.addAll(List.of(paths));
        return this;
    }

    public Node build() {
        Group group = new Group();
        group.getChildren().addAll(this.pathList);
        group.setScaleX(this.targetWidth / this.viewBoxWidth);
        group.setScaleY(this.targetHeight / this.viewBoxHeight);
        return group;
    }
}

