/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.framework.utils;

import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;

public class FxButtons {
    private FxButtons() {
    }

    public static Builder create() {
        return new Builder(null);
    }

    public static Builder create(Runnable onClick) {
        return new Builder(onClick);
    }

    public static final class Builder {
        private Runnable onClick;
        private String labelText = "";
        private Node leftNode;
        private Node rightNode;
        private String leftIconKey;
        private String rightIconKey;
        private boolean showChevron = false;
        private boolean centerIfNoSideNodes = true;
        private boolean fullWidth = false;
        private double minHeight = 44.0;
        private Double prefHeight = 50.0;
        private double spacing = 8.0;
        private Insets padding = new Insets(12.0, 12.0, 12.0, 12.0);
        private final List<String> styleClasses = new ArrayList<String>();
        private final List<String> textStyleClasses = new ArrayList<String>(List.of("body-1"));
        private boolean visible = true;
        private boolean managed = true;
        private Function<String, Node> iconResolver = Builder::defaultIconForKey;
        private Supplier<Node> chevronSupplier = Builder::defaultChevron;

        private Builder(Runnable onClick) {
            this.onClick = onClick != null ? onClick : () -> {};
        }

        public Builder onClick(Runnable r) {
            this.onClick = r != null ? r : () -> {};
            return this;
        }

        public Builder label(String text) {
            this.labelText = text != null ? text : "";
            return this;
        }

        public Builder leftNode(Node n) {
            this.leftNode = n;
            this.leftIconKey = null;
            return this;
        }

        public Builder rightNode(Node n) {
            this.rightNode = n;
            this.rightIconKey = null;
            return this;
        }

        public Builder leftIcon(String key) {
            this.leftIconKey = key;
            this.leftNode = null;
            return this;
        }

        public Builder rightIcon(String key) {
            this.rightIconKey = key;
            this.rightNode = null;
            return this;
        }

        public Builder chevron(boolean show) {
            this.showChevron = show;
            return this;
        }

        public Builder centerIfNoSideNodes(boolean v) {
            this.centerIfNoSideNodes = v;
            return this;
        }

        public Builder fullWidth() {
            this.fullWidth = true;
            return this;
        }

        public Builder fixedWidth() {
            this.fullWidth = false;
            return this;
        }

        public Builder minHeight(double h) {
            this.minHeight = h;
            return this;
        }

        public Builder prefHeight(Double h) {
            this.prefHeight = h;
            return this;
        }

        public Builder spacing(double s) {
            this.spacing = s;
            return this;
        }

        public Builder padding(Insets p) {
            this.padding = p;
            return this;
        }

        public Builder addStyleClasses(String ... css) {
            if (css != null) {
                this.styleClasses.addAll(Arrays.asList(css));
            }
            return this;
        }

        public Builder iconResolver(Function<String, Node> resolver) {
            if (resolver != null) {
                this.iconResolver = resolver;
            }
            return this;
        }

        public Builder chevronSupplier(Supplier<Node> supplier) {
            if (supplier != null) {
                this.chevronSupplier = supplier;
            }
            return this;
        }

        public Builder addLabelStyleClasses(String ... css) {
            if (css != null) {
                this.textStyleClasses.addAll(Arrays.asList(css));
            }
            return this;
        }

        public Builder visible(boolean value) {
            this.visible = value;
            return this;
        }

        public Builder managed(boolean value) {
            this.managed = value;
            return this;
        }

        public Button build() {
            Button btn = new Button();
            btn.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            if (this.fullWidth) {
                btn.setMaxWidth(Double.MAX_VALUE);
            }
            btn.setMinHeight(this.minHeight);
            if (this.prefHeight != null) {
                btn.setPrefHeight(this.prefHeight.doubleValue());
            }
            btn.setOnAction(e -> this.onClick.run());
            if (!this.styleClasses.isEmpty()) {
                btn.getStyleClass().addAll(this.styleClasses);
            }
            Node content = this.buildRow();
            btn.setGraphic(content);
            btn.setVisible(this.visible);
            btn.setManaged(this.managed);
            return btn;
        }

        private Node buildRow() {
            Label text = new Label(this.labelText);
            text.getStyleClass().addAll(this.textStyleClasses);
            Node left = this.leftNode != null ? this.leftNode : (this.leftIconKey != null ? this.iconResolver.apply(this.leftIconKey) : null);
            Node right = this.resolveRightNode();
            if (left == null && right == null && this.centerIfNoSideNodes) {
                HBox row = new HBox(this.spacing);
                row.setAlignment(Pos.CENTER);
                row.setPadding(this.padding);
                Region l = new Region();
                Region r = new Region();
                HBox.setHgrow((Node)l, (Priority)Priority.ALWAYS);
                HBox.setHgrow((Node)r, (Priority)Priority.ALWAYS);
                row.getChildren().addAll((Object[])new Node[]{l, text, r});
                return row;
            }
            HBox row = new HBox(this.spacing);
            row.setAlignment(Pos.CENTER_LEFT);
            row.setPadding(this.padding);
            if (left != null) {
                row.getChildren().add((Object)left);
            }
            row.getChildren().add((Object)text);
            Region spacer = new Region();
            HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
            row.getChildren().add((Object)spacer);
            if (right != null) {
                row.getChildren().add((Object)right);
            }
            return row;
        }

        private Node resolveRightNode() {
            if (this.rightNode != null) {
                return this.rightNode;
            }
            if (this.rightIconKey != null) {
                return this.iconResolver.apply(this.rightIconKey);
            }
            if (this.showChevron) {
                return this.chevronSupplier.get();
            }
            return null;
        }

        private static Node defaultIconForKey(String key) {
            SvgSizeable s = new SvgSizeable();
            s.getStyleClass().addAll((Object[])new String[]{key, "icon-medium"});
            return s;
        }

        private static Node defaultChevron() {
            SvgSizeable chevron = new SvgSizeable();
            chevron.getStyleClass().addAll((Object[])new String[]{"svg-chevron", "icon-medium"});
            return chevron;
        }
    }
}

