/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.framework.updater;

import io.olvid.windows.messenger.fx.framework.updater.ListUpdateTask;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.UIUpdater;
import io.olvid.windows.messenger.livedata.Diffable;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;

public class ListUpdater<ViewModel, Task extends ListUpdateTask<ViewModel>, Data extends Diffable> {
    private UIUpdater uiUpdater;
    private Function<Data, Task> listUpdateTask;
    private final HashMap<Object, ViewModel> viewModelMap = new HashMap();
    private final LiveDataListener<List<Data>> listLiveDataListener = this::onListChange;

    private void onListChange(List<Data> newData, List<Data> oldDataOriginal) {
        ArrayList<Data> oldData = new ArrayList<Data>(oldDataOriginal);
        ArrayList operationMove = new ArrayList();
        ArrayList operationUpdate = new ArrayList();
        ViewControllerHelper.smartUIUpdate(() -> {
            if (newData == null) {
                AppLogger.t("ListModel::onChange NewVal is NULL");
                operationMove.add(List::clear);
                return;
            }
            oldData.removeIf(item -> !newData.contains(item));
            for (int newIndex = 0; newIndex < newData.size(); ++newIndex) {
                Object newViewModel;
                Diffable newElement = (Diffable)newData.get(newIndex);
                int finalNewIndex = newIndex;
                int oldIndex = oldData.indexOf(newElement);
                if (oldIndex == -1) {
                    oldData.add(newIndex, newElement);
                    newViewModel = ((ListUpdateTask)this.listUpdateTask.apply(newElement)).create();
                    operationMove.add(list -> list.add(finalNewIndex, newViewModel));
                    continue;
                }
                if (newElement.areContentTheSame(oldData.get(oldIndex))) {
                    if (oldIndex == newIndex) continue;
                    if (oldData.size() > newIndex) {
                        oldData.set(oldIndex, (Diffable)oldData.get(newIndex));
                        oldData.set(newIndex, newElement);
                        operationMove.add(list -> list.set(oldIndex, list.get(finalNewIndex)));
                        newViewModel = ((ListUpdateTask)this.listUpdateTask.apply(newElement)).create();
                        operationMove.add(list -> list.set(finalNewIndex, newViewModel));
                        continue;
                    }
                    AppLogger.e("ListModel::onChange SOMETHING IS WRONG");
                    throw new RuntimeException();
                }
                if (oldIndex != newIndex) {
                    oldData.set(oldIndex, (Diffable)oldData.get(newIndex));
                    operationMove.add(list -> list.set(oldIndex, list.get(finalNewIndex)));
                    oldData.set(newIndex, newElement);
                    newViewModel = ((ListUpdateTask)this.listUpdateTask.apply(newElement)).create();
                    operationMove.add(list -> list.set(finalNewIndex, newViewModel));
                    continue;
                }
                oldData.set(newIndex, newElement);
                ListUpdateTask task = (ListUpdateTask)this.listUpdateTask.apply(newElement);
                operationUpdate.add(task);
            }
        });
    }

    public void onLiveData(LiveData<List<Data>> listLiveData) {
        LiveDataListener<List<Data>> listener = this.listLiveDataListener;
        listLiveData.addListener(listener);
    }
}

