/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.framework.lib;

import io.olvid.windows.messenger.fx.framework.lib.Disposable;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class Pool<T extends Disposable> {
    private final ConcurrentLinkedQueue<T> pool;
    private final int maxObjects;
    private final AppLogger logger = new AppLogger(Pool.class);

    public Pool(int minObjects, int maxObjects) {
        this.maxObjects = maxObjects;
        this.pool = new ConcurrentLinkedQueue();
        for (int i = 0; i < minObjects; ++i) {
            this.pool.add(this.createObject(this));
        }
    }

    public T borrowObject() {
        Disposable object = (Disposable)this.pool.poll();
        if (object == null) {
            object = this.createObject(this);
        }
        object.setDisposed(false);
        return (T)object;
    }

    public void returnObject(T object) {
        if (object == null) {
            return;
        }
        if (object.isDisposed().get()) {
            this.logger.warning("Pool::borrowObject disposing already disposed object");
            return;
        }
        if (this.pool.size() >= this.maxObjects) {
            return;
        }
        this.pool.offer(object);
        object.setDisposed(true);
    }

    protected abstract T createObject(Pool<T> var1);
}

