/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussions_tab;

import io.olvid.windows.messenger.fx.custom_components.bubbles.BubbleUtils;
import io.olvid.windows.messenger.fx.generic_types.list_view.AbstractListCell;
import io.olvid.windows.messenger.fx.misc.BubbleAndDescription;
import io.olvid.windows.messenger.livedata.Diffable;
import io.olvid.windows.messenger.livedata.info.DiscussionInfo;
import java.util.Optional;
import java.util.function.Function;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;

public class SelectableDiscussionListCell<T extends Diffable>
extends AbstractListCell<T> {
    private final BubbleAndDescription bubbleAndDescription;
    public final Label sub_accessory = new Label();
    public StackPane cell_box = new StackPane();
    private final Function<T, DiscussionInfo> getInfo;
    private Optional<DiscussionInfo> lastKnownDiscussionInfo = Optional.empty();

    public SelectableDiscussionListCell(Function<T, DiscussionInfo> getInfo) {
        this.initListCell(true);
        this.getInfo = getInfo;
        this.bubbleAndDescription = new BubbleAndDescription();
        this.bubbleAndDescription.maxWidthProperty().bind((ObservableValue)this.widthProperty());
        this.sub_accessory.getStyleClass().add((Object)"body-3");
        this.bubbleAndDescription.rightVBox.maxHeightProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)this.bubbleAndDescription.title.heightProperty(), (ObservableNumberValue)this.bubbleAndDescription.subtitleHeightProperty()));
        this.bubbleAndDescription.rightVBox.getChildren().addAll((Object[])new Node[]{this.cell_box});
        this.bubbleAndDescription.setPadding(new Insets(12.0, 0.0, 12.0, 0.0));
    }

    @Override
    protected void updateItem(T t, boolean empty) {
        super.updateItem(t, empty);
        if (empty || t == null) {
            this.setGraphic(null);
            this.setText(null);
            BubbleUtils.resetBubbleData(this.bubbleAndDescription.bubble);
            this.bubbleAndDescription.setTitle(null);
            this.bubbleAndDescription.setSubtitle(Optional.empty());
            this.sub_accessory.setText(null);
            this.lastKnownDiscussionInfo = Optional.empty();
            return;
        }
        DiscussionInfo discussionInfo = this.getInfo.apply(t);
        this.update(discussionInfo);
        this.setGraphic((Node)this.bubbleAndDescription);
        this.lastKnownDiscussionInfo = Optional.of(discussionInfo);
    }

    private void update(DiscussionInfo discussionInfo) {
        DiscussionInfo lastDiscussionInfo;
        if (this.lastKnownDiscussionInfo.isPresent() && (lastDiscussionInfo = this.lastKnownDiscussionInfo.get()).equals(discussionInfo)) {
            return;
        }
        this.bubbleAndDescription.setTitle(discussionInfo.title().orElse(null));
        this.bubbleAndDescription.setSubtitle(discussionInfo.subtitle());
        BubbleUtils.setBubbleData(discussionInfo, this.bubbleAndDescription.bubble);
    }

    @Override
    protected Pane getCheckBoxParent() {
        return this.cell_box;
    }
}

