/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussions_tab;

import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.MediatorLiveData;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.notification_pattern.NotificationListener;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.DraftImportNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.UIActionNC;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RemainingAttachmentsToCreateLiveData
extends MediatorLiveData<Integer> {
    private Id<Discussion> selectedDiscussionId;
    private final Map<Id<Discussion>, Integer> remainingDraftAttachmentToCreatePerDiscussion = new ConcurrentHashMap<Id<Discussion>, Integer>();
    private final LiveDataListener<Discussion> selectedDiscussionLiveDataListener = this::selectedDiscussionListener;
    final NotificationListener<DraftImportNotification> draftAttachmentImportedListener = this::draftAttachmentImportedListener;

    public RemainingAttachmentsToCreateLiveData(LiveData<Discussion> selectedDiscussionLiveData) {
        super(0);
        NCRegistry.getUIActionNC().subscribe(UIActionNC.UserInteractionNotificationEnumType.DRAFT_ATTACHMENT_IMPORTED, this.draftAttachmentImportedListener);
        this.addSource(selectedDiscussionLiveData, this.selectedDiscussionLiveDataListener);
    }

    public Map<Id<Discussion>, Integer> getRemainingDraftAttachmentToCreatePerDiscussion() {
        return this.remainingDraftAttachmentToCreatePerDiscussion;
    }

    private void selectedDiscussionListener(Discussion newValue, Discussion oldValue) {
        this.updateValue(newValue);
    }

    private void updateValue(Discussion newValue) {
        if (newValue != null) {
            this.selectedDiscussionId = newValue.getItemId();
            this.postValue(this.remainingDraftAttachmentToCreatePerDiscussion.get(this.selectedDiscussionId) == null ? 0 : this.remainingDraftAttachmentToCreatePerDiscussion.get(this.selectedDiscussionId));
        }
    }

    private void draftAttachmentImportedListener(DraftImportNotification notification) {
        AppLogger.d("DiscussionSelectionModel::draftAttachmentImportedListener() type : " + String.valueOf(notification.getNotificationType()));
        Integer remainingDraftsToHandle = this.remainingDraftAttachmentToCreatePerDiscussion.get(notification.getDiscussionId());
        if (remainingDraftsToHandle != null && !remainingDraftsToHandle.equals(notification.getRemainingAttachementToImportCount())) {
            this.remainingDraftAttachmentToCreatePerDiscussion.put(notification.getDiscussionId(), notification.getRemainingAttachementToImportCount());
        } else if (remainingDraftsToHandle == null) {
            this.remainingDraftAttachmentToCreatePerDiscussion.remove(notification.getDiscussionId());
        }
        if (notification.getDiscussionId().equals(this.selectedDiscussionId)) {
            this.postValue(notification.getRemainingAttachementToImportCount() == null ? 0 : notification.getRemainingAttachementToImportCount());
        }
    }
}

