/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.view;

import io.olvid.windows.messenger.database.tables.gen.reaction.AbstractReactionGenerated;
import io.olvid.windows.messenger.database.tables.message.MessageEditionState;
import io.olvid.windows.messenger.fx.custom_components.file.FilePreview;
import io.olvid.windows.messenger.fx.custom_components.file.HighDefLinkPreview;
import io.olvid.windows.messenger.fx.custom_components.file.ImagePreview;
import io.olvid.windows.messenger.fx.custom_components.file.LowDefLinkPreview;
import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.discussions.discussion_view.DiscussionViewModel;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.MessageItem;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.view.EditMessageView;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.view.MessageView;
import io.olvid.windows.messenger.fx.discussions.discussion_view.reaction.ReactionsHBox;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.FancyTextArea;
import io.olvid.windows.messenger.fx.misc.richtextfx.utils.RichStyledConfiguration;
import io.olvid.windows.messenger.fx.misc.textflow.LineLimitedTextFlow;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.info.IdentityDetailsInfo;
import io.olvid.windows.messenger.livedata.mediator.ContactInfoLiveData;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.StringUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.SVGPath;
import javafx.scene.text.Text;

public abstract class UserMessageView
extends MessageView<FancyTextArea> {
    public static final int ARC_RADIUS = 16;
    public final GridPane imageGrid = new GridPane();
    public final VBox attachmentVBox = new VBox();
    private final VBox replyToBox = new VBox();
    protected final LineLimitedTextFlow replyToBody = new LineLimitedTextFlow();
    protected final Label replyToSenderName = new Label();
    protected final HBox forwarded = new HBox();
    private final FlowPane reactionFlowPane = new FlowPane(Orientation.HORIZONTAL);
    private final ReactionsHBox reactionsHBox = new ReactionsHBox();
    public final EditMessageView editMessageView = new EditMessageView();
    private final Text editedText = new Text();
    public final BooleanProperty isHighlighted = new SimpleBooleanProperty();
    public final StackPane linkPreviewContainer = new StackPane();
    public static final double highlightSpace = 6.0;
    public final LowDefLinkPreview lowDefLinkPreview;
    public final HighDefLinkPreview highDefLinkPreview;

    protected UserMessageView(Pos alignment, LiveData<Long> tickerLiveData, StringProperty searchText, DoubleExpression maxWidthBinding, DoubleExpression heightBinding, LowDefLinkPreview lowDefLinkPreview, HighDefLinkPreview highDefLinkPreview) {
        super(alignment, tickerLiveData, maxWidthBinding, heightBinding);
        this.lowDefLinkPreview = lowDefLinkPreview;
        this.highDefLinkPreview = highDefLinkPreview;
        this.linkPreviewContainer.getChildren().addAll((Object[])new Node[]{lowDefLinkPreview, highDefLinkPreview});
        SvgSizeable forwardImage = new SvgSizeable();
        forwardImage.getStyleClass().addAll((Object[])new String[]{"svg-forwarded", "icon-medium", "icon-grey"});
        Label forwardLabel = new Label();
        forwardLabel.setText(ViewControllerHelper.RESOURCE_BUNDLE.getString("label_forwarded"));
        forwardLabel.getStyleClass().add((Object)"forwarded-label");
        this.forwarded.setAlignment(Pos.BOTTOM_CENTER);
        this.forwarded.setId("forwarded");
        this.setMargin((Node)this.forwarded);
        this.forwarded.getChildren().addAll((Object[])new Node[]{forwardImage, forwardLabel});
        ViewControllerHelper.hideNode((Node)this.forwarded);
        this.addBefore((Pane)this, (Node)this.forwarded, (Node)this.messageActionableHBox);
        this.editedText.setText(ViewControllerHelper.getString("message_content_edited"));
        this.editedText.getStyleClass().add((Object)"edited");
        ViewControllerHelper.hideNode((Node)this.editedText);
        VBox.setMargin((Node)this.editedText, (Insets)new Insets(8.0, 0.0, 0.0, 0.0));
        this.messageBubbleVBox.getChildren().add((Object)this.editedText);
        this.replyToBox.getStyleClass().add((Object)"reply-to");
        this.replyToBox.setId("replyToBox");
        this.replyToBox.maxWidthProperty().bind((ObservableValue)this.messageHoverableVBox.maxWidthProperty());
        this.replyToBox.setAlignment(Pos.CENTER_LEFT);
        this.setMargin((Node)this.replyToBox, -10.0);
        this.replyToBox.getChildren().add((Object)this.replyToSenderName);
        this.replyToSenderName.getStyleClass().add((Object)"sender-name");
        this.replyToSenderName.setId("replyToSenderName");
        this.replyToBox.getChildren().add((Object)this.replyToBody);
        this.replyToBody.setId("replyToBody");
        this.replyToBody.getStyleClass().addAll((Object[])new String[]{"body-2"});
        this.replyToBody.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, null, null)}));
        DoubleBinding leftRightPadding = Bindings.createDoubleBinding(() -> this.replyToBox.getInsets().getLeft() + this.replyToBox.getInsets().getRight(), (Observable[])new Observable[]{this.replyToBox.insetsProperty()});
        DoubleBinding replyToBoxChildrenMaxWidth = this.replyToBox.maxWidthProperty().subtract((ObservableNumberValue)leftRightPadding);
        this.replyToBody.maxWidthProperty().bind((ObservableValue)replyToBoxChildrenMaxWidth);
        this.addBefore((Pane)this.messageHoverableVBox, (Node)this.replyToBox, (Node)this.messageBubbleVBox);
        ViewControllerHelper.hideNode((Node)this.replyToSenderName);
        ViewControllerHelper.hideNode((Node)this.replyToBody);
        ViewControllerHelper.hideNode((Node)this.replyToBox);
        this.imageGrid.setId("imageGrid");
        this.setMargin((Node)this.imageGrid);
        this.imageGrid.setFocusTraversable(true);
        this.imageGrid.setHgap(this.space);
        this.imageGrid.setVgap(this.space);
        this.imageGrid.getStyleClass().add((Object)"attachment-container");
        this.imageGrid.setAlignment(alignment);
        DoubleBinding imageGridPaneMaxWidth = Bindings.createDoubleBinding(() -> Math.min(maxWidthBinding.get(), 400.0), (Observable[])new Observable[]{maxWidthBinding});
        this.imageGrid.minWidthProperty().bind((ObservableValue)imageGridPaneMaxWidth);
        this.imageGrid.maxWidthProperty().bind((ObservableValue)imageGridPaneMaxWidth);
        this.imageGrid.prefWidthProperty().bind((ObservableValue)imageGridPaneMaxWidth);
        this.imageGrid.minHeightProperty().bind((ObservableValue)imageGridPaneMaxWidth.divide(2));
        this.imageGrid.prefHeightProperty().bind((ObservableValue)imageGridPaneMaxWidth.divide(2));
        this.imageGrid.maxHeightProperty().bind((ObservableValue)imageGridPaneMaxWidth.divide(2));
        ViewControllerHelper.hideNode((Node)this.imageGrid);
        this.addBefore((Pane)this.messageHoverableVBox, (Node)this.imageGrid, (Node)this.messageBubbleVBox);
        this.attachmentVBox.setId("attachmentVBox");
        this.attachmentVBox.setFillWidth(false);
        this.attachmentVBox.setSpacing(this.space);
        this.attachmentVBox.setAlignment(alignment);
        this.setMargin((Node)this.attachmentVBox);
        this.addBefore((Pane)this.messageHoverableVBox, (Node)this.attachmentVBox, (Node)this.messageBubbleVBox);
        ViewControllerHelper.hideNode((Node)this.attachmentVBox);
        this.linkPreviewContainer.maxWidthProperty().bind((ObservableValue)maxWidthBinding);
        this.setMargin((Node)this.linkPreviewContainer);
        this.linkPreviewContainer.setId("linkPreviewContainer");
        this.linkPreviewContainer.setAlignment(alignment);
        this.addBefore((Pane)this.messageHoverableVBox, (Node)this.linkPreviewContainer, (Node)this.messageBubbleVBox);
        ViewControllerHelper.hideNode((Node)this.linkPreviewContainer);
        this.editMessageView.maxHeightProperty().bind((ObservableValue)heightBinding);
        ViewControllerHelper.hideNode((Node)this.editMessageView);
        this.addAfter((Pane)this.messageHoverableVBox, (Node)this.editMessageView, (Node)this.messageBubbleVBox);
        this.editMessageView.minWidthProperty().bind((ObservableValue)this.messageHoverableVBox.maxWidthProperty());
        this.reactionFlowPane.setId("reactionFlowPane");
        this.reactionFlowPane.prefWrapLengthProperty().bind((ObservableValue)this.maxWidthProperty());
        this.reactionFlowPane.setAlignment(alignment);
        this.reactionFlowPane.setPadding(new Insets(-8.0, 0.0, 0.0, 0.0));
        this.reactionFlowPane.getChildren().add((Object)this.reactionsHBox);
        this.reactionFlowPane.maxWidthProperty().bind((ObservableValue)this.reactionsHBox.widthProperty());
        switch (alignment.getHpos()) {
            case LEFT: {
                this.addAfter((Pane)this.statusHBox, (Node)this.reactionFlowPane, (Node)this.statusLabel);
                break;
            }
            case CENTER: {
                break;
            }
            case RIGHT: {
                this.addBefore((Pane)this.statusHBox, (Node)this.reactionFlowPane, (Node)this.timestamp);
            }
        }
        ViewControllerHelper.hideNode((Node)this.reactionFlowPane);
        ((FancyTextArea)this.textArea).bindSearchProperty(searchText);
        Rectangle highlightRectangle = new Rectangle();
        highlightRectangle.setManaged(false);
        highlightRectangle.setMouseTransparent(true);
        highlightRectangle.visibleProperty().bind((ObservableValue)this.isHighlighted);
        highlightRectangle.setId("highlightRectangle");
        this.messageBubbleVBox.getChildren().add((Object)highlightRectangle);
        highlightRectangle.setStroke((Paint)Color.web((String)"2F65F5"));
        highlightRectangle.setStrokeWidth(2.0);
        highlightRectangle.setFill((Paint)Color.TRANSPARENT);
        highlightRectangle.setArcHeight(16.0);
        highlightRectangle.setArcWidth(16.0);
        highlightRectangle.widthProperty().bind((ObservableValue)this.messageBubbleVBox.widthProperty().add(6.0));
        highlightRectangle.heightProperty().bind((ObservableValue)this.messageBubbleVBox.heightProperty().add(6.0));
        highlightRectangle.setLayoutX(-3.0);
        highlightRectangle.setLayoutY(-3.0);
    }

    @Override
    protected FancyTextArea makeTextArea() {
        FancyTextArea fancyTextArea = new FancyTextArea(RichStyledConfiguration.style());
        fancyTextArea.setEditable(false);
        fancyTextArea.setMouseTransparent(false);
        return fancyTextArea;
    }

    private void addAfter(Pane parent, Node nodeToAdd, Node node) {
        int indexOf = parent.getChildren().indexOf((Object)node);
        if (indexOf != -1) {
            parent.getChildren().add(indexOf + 1, (Object)nodeToAdd);
        } else {
            AppLogger.e(String.format("Cannot add %s: cannot find %s in %s", nodeToAdd.getId(), node.getId(), parent.getId()));
        }
    }

    private void addBefore(Pane parent, Node nodeToAdd, Node node) {
        int indexOf = parent.getChildren().indexOf((Object)node);
        if (indexOf != -1) {
            parent.getChildren().add(indexOf, (Object)nodeToAdd);
        } else {
            AppLogger.e(String.format("Cannot add %s: cannot find %s in %s", nodeToAdd.getId(), node.getId(), parent.getId()));
        }
    }

    private static String getRoundRectangleSvgContent(double r, double w, double h, boolean topRight, boolean bottomRight, boolean bottomLeft, boolean topLeft) {
        return "M" + r + ",0 h" + w + " " + (topRight ? "a" + r + "," + r + " 0 0 1 " + r + "," + r + " " : "h" + r + " v" + r + " ") + "v" + h + " " + (bottomRight ? "a" + r + "," + r + " 0 0 1 " + -r + "," + r + " " : "v" + r + " h" + -r + " ") + "h" + -w + " " + (bottomLeft ? "a" + r + "," + r + " 0 0 1 " + -r + "," + -r + " " : "h" + -r + " v" + -r + " ") + "v" + -h + " " + (topLeft ? "a" + r + "," + r + " 0 0 1 " + r + "," + -r + " " : "v" + -r + " h" + r + " ") + "z";
    }

    public void showAttachmentFlowPane(boolean show) {
        if (show) {
            ViewControllerHelper.showNode((Node)this.attachmentVBox);
        } else {
            ViewControllerHelper.hideNode((Node)this.attachmentVBox);
            this.attachmentVBox.getChildren().clear();
        }
    }

    public void configureImagePreviews(int totalImageCount) {
        ObservableList children = this.imageGrid.getChildren();
        if (children.isEmpty()) {
            ViewControllerHelper.hideNode((Node)this.imageGrid);
            this.updateCorners();
            return;
        }
        int count = children.size();
        RowConstraints rowConstraints = new RowConstraints();
        rowConstraints.setFillHeight(true);
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setFillWidth(true);
        this.imageGrid.getRowConstraints().setAll((Object[])new RowConstraints[]{rowConstraints});
        this.imageGrid.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{columnConstraints});
        for (int i = 0; i < count; ++i) {
            Object object = children.get(i);
            if (!(object instanceof ImagePreview)) continue;
            ImagePreview imagePreview = (ImagePreview)object;
            GridPane.setColumnIndex((Node)imagePreview, (Integer)(i % 2));
            int rowIndex = i / 2;
            GridPane.setRowIndex((Node)imagePreview, (Integer)rowIndex);
            boolean moreThanOneColumns = count == 1 ? false : (count == 3 ? rowIndex == 0 : true);
            GridPane.setColumnSpan((Node)imagePreview, (Integer)(moreThanOneColumns ? 1 : 2));
            if (moreThanOneColumns) {
                imagePreview.width.bind((ObservableValue)this.imageGrid.widthProperty().subtract(this.imageGrid.getHgap()).divide(2));
            } else {
                imagePreview.width.bind((ObservableValue)this.imageGrid.widthProperty());
            }
            if (i == 3 && totalImageCount > 4) {
                imagePreview.moreAttachmentsCount.set((Object)(totalImageCount - 3 + "+"));
            } else {
                imagePreview.moreAttachmentsCount.set((Object)"");
            }
            if (count > 2) {
                imagePreview.height.bind((ObservableValue)this.imageGrid.heightProperty().subtract(this.imageGrid.getVgap()).divide(2));
                continue;
            }
            imagePreview.height.bind((ObservableValue)this.imageGrid.heightProperty());
        }
        ViewControllerHelper.showNode((Node)this.imageGrid);
        this.updateCorners();
    }

    public void showReplyToOwnedIdentityName() {
        ViewControllerHelper.checkUIThread();
        this.replyToSenderName.setText(ViewControllerHelper.getString("you"));
        ViewControllerHelper.showNode((Node)this.replyToSenderName);
    }

    public void showReplyToContactName(ContactInfoLiveData.ContactInfoState senderState) {
        ContactInfoLiveData.ContactInfoState contactInfoState = senderState;
        Objects.requireNonNull(contactInfoState);
        ContactInfoLiveData.ContactInfoState contactInfoState2 = contactInfoState;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ContactInfoLiveData.ContactInfoState.Computing.class, ContactInfoLiveData.ContactInfoState.Deleted.class, ContactInfoLiveData.ContactInfoState.Present.class}, (Object)contactInfoState2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                ContactInfoLiveData.ContactInfoState.Computing c = (ContactInfoLiveData.ContactInfoState.Computing)contactInfoState2;
                this.replyToSenderName.setText(" ");
                break;
            }
            case 1: {
                ContactInfoLiveData.ContactInfoState.Deleted d = (ContactInfoLiveData.ContactInfoState.Deleted)contactInfoState2;
                this.replyToSenderName.setText(ViewControllerHelper.getString("deleted_contact"));
                break;
            }
            case 2: {
                ContactInfoLiveData.ContactInfoState.Present info = (ContactInfoLiveData.ContactInfoState.Present)contactInfoState2;
                this.replyToSenderName.setText(info.info().getCustomOrDisplayName(IdentityDetailsInfo.Format.FIRST_LAST));
            }
        }
        ViewControllerHelper.showNode((Node)this.replyToSenderName);
    }

    public void hideReplyToSenderName() {
        ViewControllerHelper.checkUIThread();
        this.replyToSenderName.setText(null);
        ViewControllerHelper.hideNode((Node)this.replyToSenderName);
    }

    public void showEmptyReplyTo() {
        ViewControllerHelper.checkUIThread();
        this.replyToSenderName.setText(" ");
        this.replyToBody.replaceText(" ");
        ViewControllerHelper.showNode((Node)this.replyToSenderName);
        ViewControllerHelper.showNode((Node)this.replyToBody);
        this.updateReplyToBoxVisibility();
    }

    public void updateReplyToBody(Optional<String> content) {
        if (content.isEmpty() || StringUtils.isEmpty(content.get())) {
            this.replyToBody.clear();
            ViewControllerHelper.hideNode((Node)this.replyToBody);
        } else {
            this.replyToBody.replaceText(content.get());
            ViewControllerHelper.showNode((Node)this.replyToBody);
        }
        this.updateReplyToBoxVisibility();
    }

    public void updateReplyToToDeletedOrNotReceived(boolean isDeleted) {
        this.hideReplyToSenderName();
        if (isDeleted) {
            this.replyToBody.replaceText(ViewControllerHelper.getString("deleted_message"));
        } else {
            this.replyToBody.replaceText(ViewControllerHelper.getString("not_found_message"));
        }
        ViewControllerHelper.showNode((Node)this.replyToBody);
        this.updateReplyToBoxVisibility();
    }

    public void removeReplyTo() {
        ViewControllerHelper.hideNode((Node)this.replyToBody);
        this.updateReplyToBoxVisibility();
    }

    protected void updateReplyToBoxVisibility() {
        if (this.replyToBody.isVisible()) {
            ViewControllerHelper.showNode((Node)this.replyToBox);
        } else {
            ViewControllerHelper.hideNode((Node)this.replyToBox);
        }
    }

    @Override
    protected void updateMessageBubbleVBoxVisibility() {
        if (this.isEditionActive()) {
            return;
        }
        super.updateMessageBubbleVBoxVisibility();
        this.updateCorners();
    }

    public void setForwarded(boolean value) {
        if (value) {
            ViewControllerHelper.showNode((Node)this.forwarded);
        } else {
            ViewControllerHelper.hideNode((Node)this.forwarded);
        }
    }

    public void setEdited(boolean value) {
        if (value) {
            ViewControllerHelper.showNode((Node)this.editedText);
        } else {
            ViewControllerHelper.hideNode((Node)this.editedText);
        }
    }

    public <Reaction extends AbstractReactionGenerated<?>> void updateReaction(List<Reaction> reactions) {
        this.reactionsHBox.update(reactions);
        if (reactions.isEmpty()) {
            ViewControllerHelper.hideNode((Node)this.reactionFlowPane);
        } else {
            ViewControllerHelper.showNode((Node)this.reactionFlowPane);
        }
        this.updateStatusHBoxVisibility();
    }

    public void setReactionsClickAction(MessageItem messageItem, DiscussionViewModel viewModel) {
        this.reactionsHBox.setOnClickCallback(() -> viewModel.showReactionsDetails(messageItem));
    }

    public void disableHover(boolean value) {
        this.disableHoverProperty.set(value);
    }

    public void cancelEdition() {
        ViewControllerHelper.hideNode((Node)this.editMessageView);
        this.updateMessageBubbleVBoxVisibility();
    }

    public void activateEdition(String original, Optional<String> modified, MessageEditionState editionState, Consumer<MessageEditionState> doEdit) {
        ViewControllerHelper.checkUIThread();
        this.editMessageView.setSaveAction(() -> {
            Optional<String> newBody = this.editMessageView.getText();
            if (newBody.isEmpty()) {
                return;
            }
            editionState.setModifyBody(newBody.get());
            doEdit.accept(editionState);
        });
        this.editMessageView.setContentPrefHeight(Math.max(this.messageBubbleVBox.getHeight(), 100.0));
        this.editMessageView.setEditedText(original, modified);
        ViewControllerHelper.hideNode((Node)this.messageBubbleVBox);
        ViewControllerHelper.showNode((Node)this.editMessageView);
    }

    public boolean isEditionActive() {
        return this.editMessageView.isVisible();
    }

    protected void updateClip(Region node, boolean corner) {
        SVGPath clip = new SVGPath();
        clip.contentProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
            double h = node.heightProperty().get() - 32.0;
            double w = node.widthProperty().get() - 32.0;
            return UserMessageView.getRoundRectangleSvgContent(16.0, w, h, true, !corner || this.alignment.getHpos() != HPos.RIGHT, !corner || this.alignment.getHpos() == HPos.RIGHT, true);
        }, (Observable[])new Observable[]{node.widthProperty(), node.heightProperty()}));
        node.setClip((Node)clip);
    }

    public void updateCorners() {
        ArrayList<Node> visibleNodes = new ArrayList<Node>();
        for (Node node : this.messageHoverableVBox.getChildren()) {
            if (!node.isVisible()) continue;
            visibleNodes.add(node);
        }
        for (int i = 0; i < visibleNodes.size(); ++i) {
            boolean showCorner;
            Node node;
            node = (Node)visibleNodes.get(i);
            if (node == this.messageBubbleVBox) continue;
            boolean bl = showCorner = this.hasCorner && i == visibleNodes.size() - 1;
            if (node == this.imageGrid) {
                this.updateClip((Region)this.imageGrid, showCorner);
                continue;
            }
            if (node == this.attachmentVBox) {
                for (int j = 0; j < this.attachmentVBox.getChildren().size(); ++j) {
                    boolean isLast;
                    Node attachment = (Node)this.attachmentVBox.getChildren().get(j);
                    boolean bl2 = isLast = j == this.attachmentVBox.getChildren().size() - 1;
                    if (!(attachment instanceof FilePreview.FileAttachmentPreview)) continue;
                    FilePreview.FileAttachmentPreview previewAttachment = (FilePreview.FileAttachmentPreview)attachment;
                    this.updateClip((Region)previewAttachment, showCorner && isLast);
                }
                continue;
            }
            if (node != this.linkPreviewContainer) continue;
            this.updateClip((Region)this.linkPreviewContainer, showCorner);
        }
    }

    public void setDisableSearch(boolean value) {
        ((FancyTextArea)this.textArea).setDisableSearch(value);
    }
}

