/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.view;

import io.olvid.windows.messenger.database.tables.gen.message.SystemMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.SystemMessage;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.view.MessageView;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.textflow.SearchableTextFlow;
import io.olvid.windows.messenger.livedata.MutableLiveData;
import io.olvid.windows.messenger.livedata.info.IdentityInfo;
import java.util.Optional;
import javafx.beans.binding.DoubleExpression;
import javafx.geometry.Pos;
import javafx.scene.text.TextAlignment;

public class SystemMessageView
extends MessageView<SearchableTextFlow> {
    public SystemMessageView(DoubleExpression maxWidthBinding, DoubleExpression heightBinding) {
        super(Pos.TOP_CENTER, new MutableLiveData<Long>(0L), maxWidthBinding, heightBinding);
        this.getStyleClass().add((Object)"message-content-system");
        ViewControllerHelper.checkUIThread();
        this.actionsHBox.setManaged(false);
        this.hideSenderView();
        this.setTimestamp(Optional.empty());
        this.setStatusLabel(Optional.empty(), Optional.empty());
    }

    @Override
    protected SearchableTextFlow makeTextArea() {
        SearchableTextFlow textFlow = new SearchableTextFlow();
        textFlow.setMouseTransparent(true);
        textFlow.setTextAlignment(TextAlignment.CENTER);
        return textFlow;
    }

    public void setSystemLabel(SystemMessageGenerated.Interface message, Optional<IdentityInfo> identityInfo) {
        ViewControllerHelper.checkUIThread();
        if (message == null) {
            return;
        }
        this.setText(Optional.of(SystemMessage.getStringContent(message, identityInfo, message.getTimestamp())));
    }
}

