/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.view;

import io.olvid.windows.messenger.database.tables.gen.ephemerality.AbstractMessageEphemeralInfoGenerated;
import io.olvid.windows.messenger.fx.custom_components.bubbles.BubbleUtils;
import io.olvid.windows.messenger.fx.custom_components.bubbles.IdentityBubble;
import io.olvid.windows.messenger.fx.custom_components.ephemerality.EphemeralInfoView;
import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.action.MessageActionEvent;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.SearchableTextArea;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.info.ContactInfo;
import io.olvid.windows.messenger.livedata.info.IdentityDetailsInfo;
import io.olvid.windows.messenger.livedata.mediator.ContactInfoLiveData;
import io.olvid.windows.messenger.misc.DateUtils;
import io.olvid.windows.messenger.misc.StringUtils;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.UIActionNC;
import java.lang.runtime.SwitchBootstraps;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleablePropertyFactory;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.TextAlignment;
import javafx.util.Duration;

public abstract class MessageView<TextArea extends SearchableTextArea>
extends VBox {
    public final Label missingMessageCount = new Label();
    public final HBox messageActionableHBox = new HBox();
    public final VBox messageHoverableVBox = new VBox();
    public final VBox messageBubbleVBox = new VBox();
    protected final TextArea textArea;
    public static final String messageBubbleVBoxId = "messageBubbleVBox";
    protected final HBox statusHBox = new HBox(4.0);
    protected final Label statusLabel = new Label();
    protected final Label timestamp = new Label();
    private final EventHandler<ScrollEvent> scrollEventEventHandler = arg_0 -> ((VBox)this.messageBubbleVBox).fireEvent(arg_0);
    private static final double messageContentVBoxLeftRightPadding = 16.0;
    private static final double messageContentVBoxTopBottomPadding = 8.0;
    private static final Insets messageBubbleVBoxInset = new Insets(8.0, 16.0, 8.0, 16.0);
    protected final DoubleBinding messageBubbleVBoxChildrenMaxWidth;
    protected final DoubleExpression maxWidthBinding;
    protected final DoubleExpression heightBinding;
    public EphemeralInfoView ephemeralInfoView;
    private final IdentityBubble senderBubble = new IdentityBubble(12.0);
    private final Label senderName = new Label();
    protected final HBox senderContainer = new HBox(new Node[]{this.senderBubble, this.senderName});
    protected final Pos alignment;
    protected BooleanProperty disableHoverProperty = new SimpleBooleanProperty(false);
    protected final HBox actionsHBox = new HBox(8.0);
    protected boolean hasCorner = true;
    protected double space = 4.0;
    private static final StyleablePropertyFactory<MessageView<?>> FACTORY = new StyleablePropertyFactory(MessageView.getClassCssMetaData());
    static final CssMetaData<MessageView<?>, Paint> BUBBLE_COLOR = FACTORY.createPaintCssMetaData("-bubble-color", s -> s.bubbleColorProperty, (Paint)Color.TRANSPARENT, false);
    public final SimpleStyleableObjectProperty<Paint> bubbleColorProperty = new SimpleStyleableObjectProperty(BUBBLE_COLOR, (Object)this, "bubble-color");

    protected MessageView(Pos alignment, LiveData<Long> tickerLiveData, DoubleExpression maxWidthBinding, DoubleExpression heightBinding) {
        ViewControllerHelper.checkUIThread();
        this.alignment = alignment;
        this.maxWidthBinding = maxWidthBinding;
        this.heightBinding = heightBinding;
        this.setAlignment(alignment);
        this.setId("MessageView");
        this.setFillWidth(false);
        this.senderName.getStyleClass().add((Object)"body-1-bold");
        this.senderContainer.setId("senderContainer");
        this.senderContainer.setSpacing(8.0);
        this.setMargin((Node)this.senderContainer);
        this.getChildren().add((Object)this.senderContainer);
        this.updateSenderView(new ContactInfoLiveData.ContactInfoState.Computing());
        this.missingMessageCount.setId("missingMessageCount");
        this.missingMessageCount.getStyleClass().add((Object)"missing-message-count");
        Tooltip tooltipMissingMessageCount = new Tooltip(ViewControllerHelper.getString("tooltip_missing_message_count"));
        tooltipMissingMessageCount.setWrapText(true);
        tooltipMissingMessageCount.setMaxWidth(300.0);
        this.missingMessageCount.setTooltip(tooltipMissingMessageCount);
        this.setMargin((Node)this.missingMessageCount);
        this.getChildren().add((Object)this.missingMessageCount);
        this.messageActionableHBox.setId("messageActionableHBox");
        this.messageActionableHBox.setSpacing(8.0);
        this.getChildren().add((Object)this.messageActionableHBox);
        this.messageHoverableVBox.setAlignment(alignment);
        this.messageHoverableVBox.setId("messageHoverableVBox");
        this.messageHoverableVBox.maxWidthProperty().bind((ObservableValue)maxWidthBinding);
        this.messageHoverableVBox.setFillWidth(false);
        this.messageActionableHBox.getChildren().add((Object)this.messageHoverableVBox);
        this.messageBubbleVBox.setPadding(messageBubbleVBoxInset);
        this.messageBubbleVBox.setId(messageBubbleVBoxId);
        this.messageBubbleVBox.setAlignment(alignment);
        this.messageBubbleVBox.setFillWidth(false);
        this.setMargin((Node)this.messageBubbleVBox);
        this.messageBubbleVBox.maxWidthProperty().bind((ObservableValue)this.messageHoverableVBox.maxWidthProperty());
        this.messageHoverableVBox.getChildren().add((Object)this.messageBubbleVBox);
        DoubleBinding leftRightPadding = Bindings.createDoubleBinding(() -> this.messageBubbleVBox.getInsets().getLeft() + this.messageBubbleVBox.getInsets().getRight() + VBox.getMargin((Node)this.messageBubbleVBox).getLeft() + VBox.getMargin((Node)this.messageBubbleVBox).getRight(), (Observable[])new Observable[]{this.messageBubbleVBox.insetsProperty()});
        this.messageBubbleVBoxChildrenMaxWidth = this.messageBubbleVBox.maxWidthProperty().subtract((ObservableNumberValue)leftRightPadding);
        this.textArea = this.makeTextArea();
        this.textArea.setStyleClass("body");
        this.textArea.configure((List<Node>)this.messageBubbleVBox.getChildren());
        this.textArea.bindMaxWidthProperty((DoubleExpression)this.messageBubbleVBoxChildrenMaxWidth);
        this.textArea.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, null, null)}));
        this.textArea.addEventFilter((EventType<ScrollEvent>)ScrollEvent.ANY, this.scrollEventEventHandler);
        this.statusHBox.setId("statusHBox");
        this.setMargin((Node)this.statusHBox);
        this.statusHBox.setAlignment(Pos.TOP_CENTER);
        this.getChildren().add((Object)this.statusHBox);
        this.timestamp.getStyleClass().add((Object)"body-3");
        this.timestamp.setId("timestamp");
        this.timestamp.setAlignment(alignment);
        ViewControllerHelper.hideNode((Node)this.timestamp);
        this.statusLabel.setId("statusLabel");
        this.statusHBox.getChildren().addAll((Object[])new Node[]{this.timestamp, this.statusLabel});
        switch (alignment.getHpos()) {
            case LEFT: {
                this.ephemeralInfoView = new EphemeralInfoView(tickerLiveData);
                this.messageActionableHBox.getChildren().addAll((Object[])new Node[]{this.ephemeralInfoView, this.actionsHBox});
                this.ephemeralInfoView.setAlignment(Pos.CENTER_LEFT);
                this.messageActionableHBox.setAlignment(Pos.CENTER_LEFT);
                this.actionsHBox.setAlignment(Pos.CENTER_LEFT);
                break;
            }
            case RIGHT: {
                this.ephemeralInfoView = new EphemeralInfoView(tickerLiveData);
                this.messageActionableHBox.getChildren().addAll(0, List.of(this.actionsHBox, this.ephemeralInfoView));
                this.ephemeralInfoView.setAlignment(Pos.CENTER_RIGHT);
                this.messageActionableHBox.setAlignment(Pos.CENTER_RIGHT);
                this.actionsHBox.setAlignment(Pos.CENTER_RIGHT);
                break;
            }
            case CENTER: {
                this.messageActionableHBox.getChildren().addAll((Object[])new Node[]{this.actionsHBox});
            }
        }
        this.actionsHBox.setId("actionsHBox");
        this.actionsHBox.visibleProperty().bind((ObservableValue)Bindings.and((ObservableBooleanValue)this.hoverProperty(), (ObservableBooleanValue)this.disableHoverProperty.not()));
        List<Action> actions = Arrays.asList(Action.values());
        switch (alignment.getHpos()) {
            case LEFT: {
                break;
            }
            case RIGHT: 
            case CENTER: {
                Collections.reverse(actions);
            }
        }
        for (Action action : actions) {
            Button button = action.buildButton();
            this.actionsHBox.getChildren().add((Object)button);
            ViewControllerHelper.hideNode((Node)button);
        }
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return FACTORY.getCssMetaData();
    }

    protected void setMargin(Node node, double space) {
        switch (this.alignment.getHpos()) {
            case LEFT: {
                VBox.setMargin((Node)node, (Insets)new Insets(0.0, 0.0, space, 4.0));
                break;
            }
            case CENTER: {
                VBox.setMargin((Node)node, (Insets)new Insets(0.0, 0.0, space, 0.0));
                break;
            }
            case RIGHT: {
                VBox.setMargin((Node)node, (Insets)new Insets(0.0, 4.0, space, 0.0));
            }
        }
    }

    protected void setMargin(Node node) {
        this.setMargin(node, this.space);
    }

    protected CornerRadii getCorner(boolean corner) {
        if (corner) {
            return switch (this.alignment.getHpos()) {
                default -> throw new MatchException(null, null);
                case HPos.LEFT -> new CornerRadii(16.0, 16.0, 16.0, 2.0, false);
                case HPos.RIGHT -> new CornerRadii(16.0, 16.0, 2.0, 16.0, false);
                case HPos.CENTER -> new CornerRadii(16.0);
            };
        }
        return new CornerRadii(16.0);
    }

    public void setCorner(boolean corner) {
        this.hasCorner = corner;
        CornerRadii cornerRadii = this.getCorner(corner);
        this.messageBubbleVBox.backgroundProperty().unbind();
        this.messageBubbleVBox.backgroundProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> {
            Paint backgroundColor = (Paint)this.bubbleColorProperty.get();
            return new Background(new BackgroundFill[]{new BackgroundFill(backgroundColor, cornerRadii, Insets.EMPTY)});
        }, (Observable[])new Observable[]{this.bubbleColorProperty}));
    }

    protected abstract TextArea makeTextArea();

    public void setAvailableActions(Set<Action> actions) {
        Set availableIds = actions.stream().map(Enum::name).collect(Collectors.toSet());
        for (Node child : this.actionsHBox.getChildren()) {
            if (!(child instanceof Button)) continue;
            Button button = (Button)child;
            boolean available = availableIds.contains(button.getId());
            button.setVisible(available);
            button.setManaged(availableIds.contains(button.getId()));
        }
    }

    public void setText(Optional<String> value) {
        ViewControllerHelper.checkUIThread();
        if (value.isEmpty()) {
            this.textArea.clear();
            this.textArea.hide();
            this.updateMessageBubbleVBoxVisibility();
            return;
        }
        String body = value.get();
        this.textArea.replaceText(body);
        this.textArea.show();
        this.updateMessageBubbleVBoxVisibility();
    }

    protected boolean showMessageBubbleVBox() {
        return this.textArea.isVisible();
    }

    protected void updateMessageBubbleVBoxVisibility() {
        ViewControllerHelper.checkUIThread();
        if (this.showMessageBubbleVBox()) {
            ViewControllerHelper.showNode((Node)this.messageBubbleVBox);
        } else {
            ViewControllerHelper.hideNode((Node)this.messageBubbleVBox);
        }
    }

    public void setStatusLabel(Optional<String> value, Optional<String> style) {
        ViewControllerHelper.checkUIThread();
        if (value.isPresent()) {
            String s = value.get();
            this.statusLabel.setText(s);
            ObservableList styleClass = this.statusLabel.getStyleClass();
            if (style.isPresent()) {
                if (!styleClass.contains((Object)style.get())) {
                    styleClass.setAll((Object[])new String[]{style.get()});
                }
            } else {
                styleClass.clear();
            }
            ViewControllerHelper.showNode((Node)this.statusLabel);
        } else {
            ViewControllerHelper.hideNode((Node)this.statusLabel);
        }
        this.updateStatusHBoxVisibility();
    }

    protected void updateStatusHBoxVisibility() {
        ViewControllerHelper.checkUIThread();
        for (Node node : this.statusHBox.getChildren()) {
            if (!node.isVisible()) continue;
            ViewControllerHelper.showNode((Node)this.statusHBox);
            return;
        }
        ViewControllerHelper.hideNode((Node)this.statusHBox);
    }

    public void setTimestamp(Optional<Long> timestampMs) {
        ViewControllerHelper.checkUIThread();
        if (timestampMs.isEmpty()) {
            ViewControllerHelper.hideNode((Node)this.timestamp);
        } else {
            LocalDateTime time = DateUtils.of(timestampMs.get());
            String date = DateUtils.formatTime(time);
            this.timestamp.setText(date);
            ViewControllerHelper.showNode((Node)this.timestamp);
        }
        this.updateStatusHBoxVisibility();
    }

    public void updateEphemeralInfo(long currentTimeMillis, Optional<? extends AbstractMessageEphemeralInfoGenerated<?>> messageEphemeralInfo) {
        this.ephemeralInfoView.updateEphemeralInfo(currentTimeMillis, messageEphemeralInfo);
    }

    public void hideSenderView() {
        ViewControllerHelper.checkUIThread();
        this.senderName.setText(null);
        this.senderBubble.setOnMouseClicked(null);
        BubbleUtils.resetBubbleData(this.senderBubble);
        ViewControllerHelper.hideNode((Node)this.senderContainer);
    }

    public void updateSenderView(ContactInfoLiveData.ContactInfoState senderState) {
        ViewControllerHelper.checkUIThread();
        ContactInfoLiveData.ContactInfoState contactInfoState = senderState;
        Objects.requireNonNull(contactInfoState);
        ContactInfoLiveData.ContactInfoState contactInfoState2 = contactInfoState;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ContactInfoLiveData.ContactInfoState.Computing.class, ContactInfoLiveData.ContactInfoState.Deleted.class, ContactInfoLiveData.ContactInfoState.Present.class}, (Object)contactInfoState2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                ContactInfoLiveData.ContactInfoState.Computing v = (ContactInfoLiveData.ContactInfoState.Computing)contactInfoState2;
                this.senderName.setText(" ");
                break;
            }
            case 1: {
                ContactInfoLiveData.ContactInfoState.Deleted v = (ContactInfoLiveData.ContactInfoState.Deleted)contactInfoState2;
                this.senderName.setText(ViewControllerHelper.getString("deleted_contact"));
                this.senderBubble.setOnMouseClicked(null);
                BubbleUtils.resetBubbleData(this.senderBubble);
                break;
            }
            case 2: {
                ContactInfoLiveData.ContactInfoState.Present p = (ContactInfoLiveData.ContactInfoState.Present)contactInfoState2;
                ContactInfo contactInfo = p.info();
                this.senderName.setText(contactInfo.getDisplayName(IdentityDetailsInfo.Format.FIRST_LAST));
                BubbleUtils.setBubbleData(contactInfo, this.senderBubble);
                this.senderBubble.setOnMouseClicked(e -> UIActionNC.fireContactSelectedNotification(Optional.of(contactInfo.genId()), true));
            }
        }
        ViewControllerHelper.showNode((Node)this.senderContainer);
    }

    public void showMissedMessageCount(long count) {
        ViewControllerHelper.showNode((Node)this.missingMessageCount);
        this.missingMessageCount.setText(StringUtils.localizePlurals("one_missed_message_count", "one_missed_message_count", "many_missed_message_count", count));
    }

    public void hideMissedMessageCount() {
        ViewControllerHelper.hideNode((Node)this.missingMessageCount);
    }

    public void setContentMouseTransparent(boolean value) {
        this.textArea.setMouseTransparent(value);
    }

    public void setTextAlignment(TextAlignment alignment) {
        this.textArea.setTextAlignment(alignment);
    }

    public static enum Action {
        OPEN_INFO("svg-info", MessageActionEvent.OPEN_INFO),
        REPLY_TO("svg-reply", MessageActionEvent.REPLY),
        EDIT("svg-edit", MessageActionEvent.EDIT),
        FORWARD("svg-forwarded", MessageActionEvent.FORWARD),
        COPY("svg-copy", MessageActionEvent.COPY),
        REACTIONS_DETAILS("svg-face", MessageActionEvent.REACTIONS_DETAILS),
        DELETE("svg-trash1", MessageActionEvent.DELETE);

        public final String svg;
        private final EventType<MessageActionEvent> event;

        private Action(String svg, EventType<MessageActionEvent> event) {
            this.svg = svg;
            this.event = event;
        }

        public String labelKey() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 6 -> "delete_action";
                case 1 -> "reply_to_action";
                case 2 -> "edit_action";
                case 3 -> "forward_action";
                case 0 -> "open_info_action";
                case 4 -> "copy_action";
                case 5 -> "reactions_details_action";
            };
        }

        public String sizeClass() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 1, 3, 4, 5, 6 -> "icon-tiny";
                case 2 -> "icon-xxsmall";
            };
        }

        Button buildButton() {
            Button button = new Button();
            button.setId(this.name());
            button.getStyleClass().add((Object)"action-button");
            SvgSizeable icon = new SvgSizeable();
            icon.getStyleClass().addAll((Object[])new String[]{this.sizeClass(), "icon-white", this.svg});
            button.setOnAction(e -> button.fireEvent((Event)new MessageActionEvent(this.event)));
            button.setGraphic((Node)icon);
            Tooltip tooltip = new Tooltip(ViewControllerHelper.getString(this.labelKey()));
            tooltip.setShowDelay(Duration.ZERO);
            button.setTooltip(tooltip);
            return button;
        }

        public EventType<MessageActionEvent> toEventType() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 6 -> MessageActionEvent.DELETE;
                case 1 -> MessageActionEvent.REPLY;
                case 2 -> MessageActionEvent.EDIT;
                case 3 -> MessageActionEvent.FORWARD;
                case 0 -> MessageActionEvent.OPEN_INFO;
                case 4 -> MessageActionEvent.COPY;
                case 5 -> MessageActionEvent.REACTIONS_DETAILS;
            };
        }

        public Optional<String> labelStyle() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 6 -> Optional.of("danger-text");
                case 0, 1, 2, 3, 4, 5 -> Optional.empty();
            };
        }

        public boolean showButtonInOutboundMessages() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 2 -> true;
                case 0, 1, 3, 4, 5, 6 -> false;
            };
        }

        public boolean showButtonInInboundMessages() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1 -> true;
                case 0, 2, 3, 4, 5, 6 -> false;
            };
        }

        public static Optional<Action> of(EventType<?> event) {
            for (Action action : Action.values()) {
                if (action.toEventType() != event) continue;
                return Optional.of(action);
            }
            return Optional.empty();
        }
    }
}

