/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.view;

import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.action.MessageActionEvent;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.richtextfx.EditableStyledArea;
import io.olvid.windows.messenger.fx.misc.richtextfx.ScrollableEditableStyledArea;
import io.olvid.windows.messenger.fx.misc.richtextfx.utils.RichStyledConfiguration;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class EditMessageView
extends StackPane
implements RichStyledConfiguration {
    private final ScrollableEditableStyledArea messageInput;
    private final SimpleStringProperty originalText = new SimpleStringProperty();
    public final VBox mainVBox = new VBox();
    public final HBox buttonHBox = new HBox();
    public final Button cancel = new Button();
    public final Button save = new Button();
    private Runnable saveAction;

    public EditMessageView() {
        this.getStylesheets().addAll((Object[])new String[]{"fx/design_system/pane.css", "fx/discussions/discussion_view/messages/message_composer/message_composer.css"});
        this.getStyleClass().addAll((Object[])new String[]{"edit-message-pane", "white-pane"});
        this.messageInput = new ScrollableEditableStyledArea(this);
        this.messageInput.addEventFilter(KeyEvent.KEY_PRESSED, this::handleSpecialKeys);
        ((EditableStyledArea)this.messageInput.getContent()).prefHeightProperty().bind((ObservableValue)this.heightProperty());
        ((EditableStyledArea)this.messageInput.getContent()).setPadding(new Insets(8.0));
        this.cancel.setText(ViewControllerHelper.getString("cancel"));
        this.cancel.getStyleClass().addAll((Object[])new String[]{"secondary-button", "medium-button"});
        this.cancel.setCancelButton(true);
        this.cancel.setOnAction(e -> this.cancel.fireEvent((Event)new MessageActionEvent(MessageActionEvent.EDIT)));
        this.save.setText(ViewControllerHelper.getString("message_view_message_action_edit_save"));
        this.save.getStyleClass().addAll((Object[])new String[]{"primary-button", "medium-button"});
        this.save.setDefaultButton(true);
        this.save.setOnAction(event -> this.save());
        BooleanBinding hasModifications = this.originalText.isNotEqualTo((ObservableStringValue)this.messageInput.plainTextProperty());
        this.save.disableProperty().bind((ObservableValue)this.messageInput.isEmpty().or((ObservableBooleanValue)hasModifications.not()));
        this.buttonHBox.getChildren().addAll((Object[])new Node[]{this.cancel, this.save});
        this.buttonHBox.setAlignment(Pos.CENTER_RIGHT);
        this.buttonHBox.setSpacing(8.0);
        this.buttonHBox.setPadding(new Insets(12.0, 8.0, 12.0, 0.0));
        this.mainVBox.getStyleClass().addAll((Object[])new String[]{"round-pane", "light-grey-bordered-container"});
        this.mainVBox.getChildren().addAll((Object[])new Node[]{this.messageInput, this.buttonHBox});
        VBox.setVgrow((Node)this.messageInput, (Priority)Priority.ALWAYS);
        this.setPadding(new Insets(12.0));
        this.getChildren().add((Object)this.mainVBox);
    }

    private void handleSpecialKeys(KeyEvent event) {
        if (event.getCode() == KeyCode.ESCAPE) {
            this.cancel.fire();
        }
        this.messageInput.requestFocus();
    }

    public void setSaveAction(Runnable saveAction) {
        this.saveAction = saveAction;
    }

    public void save() {
        if (this.saveAction != null) {
            this.saveAction.run();
        }
    }

    public Optional<String> getText() {
        if (Objects.equals(this.originalText.get(), this.messageInput.getText())) {
            return Optional.empty();
        }
        return Optional.of(this.messageInput.getText());
    }

    public void setEditedText(String original, Optional<String> modified) {
        this.originalText.set(original);
        if (modified.isPresent()) {
            this.messageInput.setText(modified.get());
        } else {
            this.messageInput.setText(original);
        }
    }

    public void setContentPrefHeight(double value) {
        this.messageInput.setPrefHeight(value);
    }

    @Override
    public RichStyledConfiguration.DelimiterProcessing processDelimiter() {
        return RichStyledConfiguration.DelimiterProcessing.STYLE;
    }

    @Override
    public boolean applyStyle() {
        return true;
    }

    @Override
    public boolean applyBlockCodeStyle() {
        return true;
    }

    @Override
    public boolean enableLinkDetection() {
        return false;
    }

    @Override
    public boolean clickableLinks() {
        return false;
    }

    @Override
    public void linkFound(Optional<String> url) {
    }

    @Override
    public void handleEnter() {
        this.save();
    }
}

