/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.controller;

import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.ReceivedMessageGenerated;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.view.MessageView;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.MapLiveData;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.Objects;
import java.util.Optional;

public abstract class MessageViewUpdater<Message extends AbstractMessageGenerated<Message>, MessageInterface extends AbstractMessageGenerated.Interface<Message>, Sender, SenderInfo, View extends MessageView<?>> {
    protected AppLogger logger = new AppLogger(this.getClass());
    protected LiveDataListener<SenderInfo> senderInfoChangeListener = null;
    protected final View view;
    protected final MapLiveData<Id<Sender>, SenderInfo> senderObserver;
    protected Optional<Id<Sender>> senderId = Optional.empty();
    protected boolean consecutiveWithPrevious = false;
    protected boolean consecutiveWithNext = false;
    protected MessageInterface currentMessage;

    protected MessageViewUpdater(View view, MapLiveData<Id<Sender>, SenderInfo> senderObserver) {
        this.view = view;
        this.senderObserver = senderObserver;
    }

    public final void clean() {
        if (this.currentMessage == null) {
            return;
        }
        if (this.senderId.isPresent()) {
            if (this.senderInfoChangeListener != null) {
                this.senderObserver.removeListener(this.senderId.get(), this.senderInfoChangeListener);
                this.senderInfoChangeListener = null;
            }
            this.senderId = Optional.empty();
        }
        this.clean(this.currentMessage);
        this.currentMessage = null;
    }

    protected void clean(MessageInterface lastMessage) {
    }

    public final void update(MessageInterface message, boolean consecutiveWithPrevious, boolean consecutiveWithNext, Optional<Id<Sender>> senderRef) {
        ViewControllerHelper.checkUIThread();
        if (this.currentMessage != null && !((Id)message.getItemId()).equals(this.currentMessage.getItemId())) {
            this.clean();
        }
        this.currentMessage = message;
        this.consecutiveWithPrevious = consecutiveWithPrevious;
        this.consecutiveWithNext = consecutiveWithNext;
        this.doUpdate(senderRef);
    }

    protected void doUpdate(Optional<Id<Sender>> senderRef) {
        ViewControllerHelper.checkUIThread();
        if (this.consecutiveWithPrevious || senderRef.isEmpty()) {
            this.hideSenderView();
        } else if (this.senderId.isEmpty()) {
            Id<Sender> senderRefId = senderRef.get();
            this.senderInfoChangeListener = (oldValue, newValue) -> this.senderInfoChangeListener(senderRefId, oldValue, newValue);
            this.senderObserver.addListener(senderRefId, this.senderInfoChangeListener);
            this.senderId = Optional.of(senderRefId);
        }
        ((MessageView)((Object)this.view)).setCorner(!this.consecutiveWithNext);
        this.updateMissedMessageCount();
    }

    protected void senderInfoChangeListener(Id<Sender> senderRefId, SenderInfo newValue, SenderInfo oldValue) {
        ViewControllerHelper.checkNotUIThread();
        if (Objects.equals(newValue, oldValue)) {
            return;
        }
        ViewControllerHelper.smartUIUpdate(() -> {
            if (this.senderId.isEmpty()) {
                this.hideSenderView();
            } else if (this.senderId.get().equals(senderRefId)) {
                this.updateSenderView(newValue);
            } else {
                this.logger.error("!!!!!!! Would have bound wrong sender: expected Id " + String.valueOf(this.senderId.get()) + " - got Id " + String.valueOf(senderRefId));
            }
        });
    }

    protected void hideSenderView() {
        ((MessageView)((Object)this.view)).hideSenderView();
    }

    protected abstract void updateSenderView(SenderInfo var1);

    private void updateMissedMessageCount() {
        MessageInterface MessageInterface = this.currentMessage;
        if (MessageInterface instanceof ReceivedMessageGenerated.Interface) {
            ReceivedMessageGenerated.Interface receivedMessage = (ReceivedMessageGenerated.Interface)MessageInterface;
            long missedMessageCount = receivedMessage.getMissedMessageCount();
            if (missedMessageCount > 0L) {
                ((MessageView)((Object)this.view)).showMissedMessageCount(missedMessageCount);
            } else {
                ((MessageView)((Object)this.view)).hideMissedMessageCount();
            }
        } else {
            ((MessageView)((Object)this.view)).hideMissedMessageCount();
        }
    }
}

