/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.controller;

import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.ephemerality.InboundMessageEphemeralInfo;
import io.olvid.windows.messenger.database.tables.gen.ephemerality.AbstractMessageEphemeralInfoGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.InboundMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.controller.EphemerableMessageUpdater;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.view.InboundMessageView;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.view.MessageView;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.livedata.MapLiveData;
import io.olvid.windows.messenger.livedata.cache.DbCache;
import io.olvid.windows.messenger.livedata.mediator.ContactInfoLiveData;
import io.olvid.windows.messenger.misc.DateUtils;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.Optional;
import javafx.scene.text.TextAlignment;

public class InboundEphemeralUpdater
extends EphemerableMessageUpdater<InboundMessage, InboundMessageGenerated.Interface, InboundMessageEphemeralInfo, ContactRef, ContactInfoLiveData.ContactInfoState, InboundMessageView> {
    public InboundEphemeralUpdater(InboundMessageView view, MapLiveData<Id<InboundMessageEphemeralInfo>, Optional<InboundMessageEphemeralInfo>> ephemeralInfoDispatcher) {
        super(view, DbCache.getInstance().contactRefInfoMapLiveData, Optional.of(ephemeralInfoDispatcher));
    }

    @Override
    protected EnumSet<MessageView.Action> getAvailableActions(Optional<InboundMessageEphemeralInfo> inboundMessageEphemeralInfo) {
        return EnumSet.of(MessageView.Action.DELETE);
    }

    @Override
    protected Optional<Id<InboundMessageEphemeralInfo>> getEphemeralInfoId() {
        return ((InboundMessageGenerated.Interface)this.currentMessage).getInboundMessageEphemeralInfoId();
    }

    @Override
    protected void updateSenderView(ContactInfoLiveData.ContactInfoState contactInfoState) {
        ViewControllerHelper.checkUIThread();
        ((InboundMessageView)this.view).updateSenderView(contactInfoState);
    }

    @Override
    protected void updateEphemeralInfo(Optional<InboundMessageEphemeralInfo> inboundMessageEphemeralInfo) {
        if (this.currentMessage == null) {
            return;
        }
        this.updateAvailableActions(inboundMessageEphemeralInfo);
        if (((InboundMessageGenerated.Interface)this.currentMessage).isBoxed()) {
            this.updateTextAndLabel(inboundMessageEphemeralInfo);
        }
        super.updateEphemeralInfo(inboundMessageEphemeralInfo);
    }

    @Override
    protected void doUpdate(Optional<Id<ContactRef>> senderRef) {
        if (((InboundMessageGenerated.Interface)this.currentMessage).isBoxed()) {
            Optional<Id<InboundMessageEphemeralInfo>> messageEphemeralInfoId = this.getEphemeralInfoId();
            if (this.ephemeralInfoDispatcher.isPresent() && messageEphemeralInfoId.isPresent() && this.ephemeralInfoId.isEmpty()) {
                this.updateEphemeralInfo(Optional.empty());
            }
            ((InboundMessageView)this.view).setDisableSearch(true);
        } else {
            ((InboundMessageView)this.view).setDisableSearch(false);
            ((InboundMessageView)this.view).setTextAlignment(TextAlignment.LEFT);
        }
        super.doUpdate(senderRef);
        ((InboundMessageView)this.view).setContentMouseTransparent(true);
        ((InboundMessageView)this.view).ephemeralInfoView.setShowReadOnceStatus(false);
        if (this.consecutiveWithNext) {
            ((InboundMessageView)this.view).setTimestamp(Optional.empty());
        } else {
            ((InboundMessageView)this.view).setTimestamp(Optional.of(((InboundMessageGenerated.Interface)this.currentMessage).getTimestamp()));
        }
    }

    private void updateTextAndLabel(Optional<? extends AbstractMessageEphemeralInfoGenerated<?>> messageEphemeralInfoOpt) {
        if (messageEphemeralInfoOpt.isEmpty()) {
            ((InboundMessageView)this.view).setStatusLabel(Optional.of(""), Optional.empty());
            ((InboundMessageView)this.view).setText(Optional.of(ViewControllerHelper.getString("message_content_boxed_with_unbox_action_label")));
            ((InboundMessageView)this.view).setTextAlignment(TextAlignment.CENTER);
            return;
        }
        AbstractMessageEphemeralInfoGenerated<?> messageEphemeralInfo = messageEphemeralInfoOpt.get();
        boolean isReadOnce = messageEphemeralInfo.isReadOnce();
        Optional<Long> visibilityDuration = messageEphemeralInfo.getVisibilityDuration();
        if (isReadOnce && visibilityDuration.isPresent()) {
            MessageFormat messageFormat = new MessageFormat(ViewControllerHelper.getString("content_inbound_ephemeral_cell_visible_read_once"));
            String formatVisibilityDuration = DateUtils.formatDurationUnit(visibilityDuration.get());
            ((InboundMessageView)this.view).setStatusLabel(Optional.of(messageFormat.format(new String[]{formatVisibilityDuration})), Optional.of("read-once-explanation"));
        } else if (isReadOnce) {
            ((InboundMessageView)this.view).setStatusLabel(Optional.of(ViewControllerHelper.getString("content_inbound_ephemeral_cell_read_once")), Optional.of("read-once-explanation"));
        } else if (visibilityDuration.isPresent()) {
            MessageFormat messageFormat = new MessageFormat(ViewControllerHelper.getString("content_inbound_ephemeral_cell_visible"));
            String formatVisibilityDuration = DateUtils.formatDurationUnit(visibilityDuration.get());
            ((InboundMessageView)this.view).setStatusLabel(Optional.of(messageFormat.format(new String[]{formatVisibilityDuration})), Optional.of("danger-text"));
        } else {
            this.logger.warning("Cannot found boxed information for message: " + String.valueOf(((InboundMessageGenerated.Interface)this.currentMessage).getItemId()));
        }
        if (messageEphemeralInfo.getVisibilityTimestamp().isPresent()) {
            ((InboundMessageView)this.view).setText(Optional.of(ViewControllerHelper.getString("message_content_unbox_by_other_device_action_label")));
        } else {
            ((InboundMessageView)this.view).setText(Optional.of(ViewControllerHelper.getString("message_content_boxed_with_unbox_action_label")));
        }
        ((InboundMessageView)this.view).setTextAlignment(TextAlignment.CENTER);
    }
}

