/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.controller;

import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.database.tables.gen.ephemerality.AbstractMessageEphemeralInfoGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.metadata.AbstractMessageMetadataGenerated;
import io.olvid.windows.messenger.database.tables.metadata.InboundMessageMetadata;
import io.olvid.windows.messenger.database.tables.metadata.OutboundMessageMetadata;
import io.olvid.windows.messenger.database.tables.metadata.OwnedMessageMetadata;
import io.olvid.windows.messenger.engine.helpers.message.MessageHelper;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.controller.EphemerableMessageUpdater;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.view.UserMessageView;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.MapLiveData;
import io.olvid.windows.messenger.livedata.cache.DbCache;
import io.olvid.windows.messenger.livedata.info.IdentityInfo;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

abstract class ContentMessageViewUpdater<Message extends AbstractUserMessageGenerated<Message>, MessageInterface extends AbstractUserMessageGenerated.Interface<Message>, EphemeralInfo extends AbstractMessageEphemeralInfoGenerated<EphemeralInfo>, MessageMetadata extends AbstractMessageMetadataGenerated<MessageMetadata>, Sender, SenderInfo>
extends EphemerableMessageUpdater<Message, MessageInterface, EphemeralInfo, Sender, SenderInfo, UserMessageView> {
    private final MapLiveData<Id<Message>, List<MessageMetadata>> messageMetadataDispatcher;
    private Optional<Id<IdentityRef>> remoteDeleterId = Optional.empty();
    private boolean metadataListenerIsPlugged = false;
    private final LiveDataListener<Optional<IdentityInfo>> remoteDeleterChangeListener = this::remoteDeleterChangeListener;
    private final LiveDataListener<List<MessageMetadata>> metadataChangeListener = this::metadataChangeListener;

    ContentMessageViewUpdater(UserMessageView view, MapLiveData<Id<Sender>, SenderInfo> senderObserver, Optional<MapLiveData<Id<EphemeralInfo>, Optional<EphemeralInfo>>> ephemeralInfoDispatcher, MapLiveData<Id<Message>, List<MessageMetadata>> messageMetadataDispatcher) {
        super(view, senderObserver, ephemeralInfoDispatcher);
        this.messageMetadataDispatcher = messageMetadataDispatcher;
    }

    protected abstract void updateContentView(Optional<String> var1, boolean var2, boolean var3);

    @Override
    protected void clean(MessageInterface lastMessage) {
        super.clean(lastMessage);
        if (this.remoteDeleterId.isPresent()) {
            DbCache.getInstance().identityInfoMapLiveData.removeListener(this.remoteDeleterId.get(), this.remoteDeleterChangeListener);
            this.remoteDeleterId = Optional.empty();
        }
        if (this.metadataListenerIsPlugged && lastMessage != null && lastMessage.getWipeStatus() == AbstractUserMessageGenerated.WipeStatus.REMOTE_DELETED) {
            this.messageMetadataDispatcher.removeListener((Id<Message>)lastMessage.getItemId(), this.metadataChangeListener);
            this.metadataListenerIsPlugged = false;
        }
        this.updateContentView(Optional.empty(), false, false);
    }

    @Override
    protected void doUpdate(Optional<Id<Sender>> senderRef) {
        super.doUpdate(senderRef);
        this.updateMessageContent(Optional.empty());
        if (!this.metadataListenerIsPlugged && ((AbstractUserMessageGenerated.Interface)this.currentMessage).getWipeStatus() == AbstractUserMessageGenerated.WipeStatus.REMOTE_DELETED) {
            this.messageMetadataDispatcher.addListener((Id<Message>)((AbstractUserMessageGenerated.Interface)this.currentMessage).getItemId(), this.metadataChangeListener);
            this.metadataListenerIsPlugged = true;
        }
    }

    private boolean isRemoteDeleted(MessageMetadata metadata) {
        if (metadata instanceof InboundMessageMetadata) {
            InboundMessageMetadata inboundMessageMetadata = (InboundMessageMetadata)metadata;
            return inboundMessageMetadata.isRemoteDeleted();
        }
        if (metadata instanceof OutboundMessageMetadata) {
            OutboundMessageMetadata outboundMessageMetadata = (OutboundMessageMetadata)metadata;
            return outboundMessageMetadata.isRemoteDeleted();
        }
        if (metadata instanceof OwnedMessageMetadata) {
            OwnedMessageMetadata ownedMessageMetadata = (OwnedMessageMetadata)metadata;
            return ownedMessageMetadata.isRemoteDeleted();
        }
        throw new IllegalStateException();
    }

    private void metadataChangeListener(List<MessageMetadata> newValue, List<MessageMetadata> oldValue) {
        if (newValue == null) {
            return;
        }
        if (this.remoteDeleterId.isPresent()) {
            return;
        }
        Optional<AbstractMessageMetadataGenerated> newMetadataOpt = newValue.stream().filter(this::isRemoteDeleted).findFirst();
        if (newMetadataOpt.isEmpty()) {
            return;
        }
        AbstractMessageMetadataGenerated newMetadata = newMetadataOpt.get();
        Optional<Id<IdentityRef>> remoteDeleterIdOpt = newMetadata.getDeleterId();
        if (remoteDeleterIdOpt.isEmpty()) {
            AppLogger.e("Found a remote deleted message metadata without remote deleter");
            return;
        }
        Id<IdentityRef> remoteDeleterId = remoteDeleterIdOpt.get();
        DbCache.getInstance().identityInfoMapLiveData.addListener(remoteDeleterId, this.remoteDeleterChangeListener);
        this.remoteDeleterId = Optional.of(remoteDeleterId);
    }

    private void remoteDeleterChangeListener(Optional<IdentityInfo> newValue, Optional<IdentityInfo> oldValue) {
        if (Objects.equals(newValue, oldValue)) {
            return;
        }
        ViewControllerHelper.smartUIUpdate(() -> this.updateMessageContent(newValue));
    }

    protected void updateMessageContent(Optional<IdentityInfo> remoteDeleterOpt) {
        if (this.currentMessage == null) {
            return;
        }
        AbstractUserMessageGenerated.Interface message = (AbstractUserMessageGenerated.Interface)this.currentMessage;
        switch (message.getWipeStatus()) {
            case NONE: 
            case WIPE_ON_READ: 
            case WIPED: {
                Optional<String> stringContent = MessageHelper.getStringContent(message);
                this.updateContentView(stringContent, MessageHelper.isEdited((AbstractUserMessageGenerated.Interface)this.currentMessage), true);
                break;
            }
            case REMOTE_DELETED: {
                ((UserMessageView)this.view).setDisableSearch(true);
                ((UserMessageView)this.view).setContentMouseTransparent(true);
                this.updateContentView(Optional.of(MessageHelper.getRemoteDeletedString(remoteDeleterOpt)), false, false);
            }
        }
    }

    protected int getFileAttachmentCount() {
        int totalAttachmentCount = ((AbstractUserMessageGenerated.Interface)this.currentMessage).getTotalAttachmentCount();
        int imageCount = ((AbstractUserMessageGenerated.Interface)this.currentMessage).getImageCount();
        boolean hasLinkPreview = ((AbstractUserMessageGenerated.Interface)this.currentMessage).getLinkPreviewKind() != AbstractUserMessageGenerated.LinkPreviewKind.NONE;
        return totalAttachmentCount - imageCount - (hasLinkPreview ? 1 : 0);
    }
}

