/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.controller;

import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.gen.ephemerality.AbstractMessageEphemeralInfoGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.InboundMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.metadata.AbstractMessageMetadataGenerated;
import io.olvid.windows.messenger.engine.helpers.message.MessageHelper;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.controller.ContentMessageViewUpdater;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.view.MessageView;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.view.UserMessageView;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.livedata.MapLiveData;
import io.olvid.windows.messenger.livedata.info.IdentityInfo;
import io.olvid.windows.messenger.livedata.mediator.ContactInfoLiveData;
import io.olvid.windows.messenger.misc.StringUtils;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;

abstract class AbstractRepliedUserMessageRepliedToUpdater<Message extends AbstractUserMessageGenerated<Message>, MessageInterface extends AbstractUserMessageGenerated.Interface<Message>, EphemeralInfo extends AbstractMessageEphemeralInfoGenerated<EphemeralInfo>, MessageMetadata extends AbstractMessageMetadataGenerated<MessageMetadata>>
extends ContentMessageViewUpdater<Message, MessageInterface, EphemeralInfo, MessageMetadata, ContactRef, ContactInfoLiveData.ContactInfoState> {
    AbstractRepliedUserMessageRepliedToUpdater(UserMessageView view, MapLiveData<Id<ContactRef>, ContactInfoLiveData.ContactInfoState> senderObserver, MapLiveData<Id<Message>, List<MessageMetadata>> messageMetadataDispatcher) {
        super(view, senderObserver, Optional.empty(), messageMetadataDispatcher);
    }

    @Override
    protected void updateSenderView(ContactInfoLiveData.ContactInfoState senderState) {
    }

    @Override
    protected void updateContentView(Optional<String> content, boolean edited, boolean enableSearch) {
        ((UserMessageView)this.view).updateReplyToBody(content);
    }

    protected Optional<String> getAttachmentCountInfo() {
        int totalAttachmentCount = ((AbstractUserMessageGenerated.Interface)this.currentMessage).getTotalAttachmentCount();
        if (totalAttachmentCount == 0) {
            return Optional.empty();
        }
        int imageCount = ((AbstractUserMessageGenerated.Interface)this.currentMessage).getImageCount();
        int fileCount = this.getFileAttachmentCount();
        StringBuilder stringBuilder = new StringBuilder();
        if (imageCount == 0 && fileCount == 0) {
            stringBuilder.append(StringUtils.localizePlurals("no_attachments_count", "one_attachment_count", "multiple_attachment_count", 1L));
        }
        if (imageCount > 0) {
            stringBuilder.append(StringUtils.localizePlurals("no_images_count", "one_image_count", "multiple_images_count", imageCount));
        }
        if (imageCount > 0 && fileCount > 0) {
            stringBuilder.append(" + ");
        }
        if (fileCount > 0) {
            stringBuilder.append(StringUtils.localizePlurals("no_attachments_count", "one_attachment_count", "multiple_attachment_count", fileCount));
        }
        return Optional.of(stringBuilder.toString());
    }

    @Override
    protected void updateMessageContent(Optional<IdentityInfo> remoteDeleterOpt) {
        InboundMessageGenerated.Interface inboundMessage;
        AbstractMessageGenerated.Interface interface_ = this.currentMessage;
        if (interface_ instanceof InboundMessageGenerated.Interface && (inboundMessage = (InboundMessageGenerated.Interface)interface_).isBoxed()) {
            this.updateContentView(Optional.of(ViewControllerHelper.getString("message_content_boxed_label")), MessageHelper.isEdited((AbstractUserMessageGenerated.Interface)this.currentMessage), false);
            return;
        }
        if (((AbstractUserMessageGenerated.Interface)this.currentMessage).getWipeStatus() == AbstractUserMessageGenerated.WipeStatus.REMOTE_DELETED) {
            super.updateMessageContent(remoteDeleterOpt);
            return;
        }
        Optional<String> attachmentCountInfo = this.getAttachmentCountInfo();
        if (StringUtils.isEmpty(((AbstractUserMessageGenerated.Interface)this.currentMessage).getBody()) && attachmentCountInfo.isPresent()) {
            this.updateContentView(attachmentCountInfo, MessageHelper.isEdited((AbstractUserMessageGenerated.Interface)this.currentMessage), false);
            return;
        }
        super.updateMessageContent(remoteDeleterOpt);
    }

    @Override
    protected Optional<Id<EphemeralInfo>> getEphemeralInfoId() {
        return Optional.empty();
    }

    @Override
    protected EnumSet<MessageView.Action> getAvailableActions(Optional<EphemeralInfo> ephemeralInfo) {
        return EnumSet.noneOf(MessageView.Action.class);
    }
}

