/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list;

import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.tables.message.MessageKind;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.OwnedMessage;
import io.olvid.windows.messenger.database.tables.message.SystemMessage;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.ItemId;

public record SortableItemId(ItemId itemId, double sortIndex) implements Comparable<SortableItemId>
{
    public static SortableItemId ofInbound(Id<InboundMessage> id, double sortIndex) {
        return new SortableItemId(ItemId.ofInbound(id), sortIndex);
    }

    public static SortableItemId ofOutbound(Id<OutboundMessage> id, double sortIndex) {
        return new SortableItemId(ItemId.ofOutbound(id), sortIndex);
    }

    public static SortableItemId ofOwned(Id<OwnedMessage> id, double sortIndex) {
        return new SortableItemId(ItemId.ofOwned(id), sortIndex);
    }

    public static SortableItemId ofSystem(Id<SystemMessage> id, double sortIndex) {
        return new SortableItemId(ItemId.ofSystem(id), sortIndex);
    }

    public static SortableItemId ofDisclaimer() {
        return new SortableItemId(ItemId.ofDisclaimer(), 0.0);
    }

    public double getSortIndex() {
        return this.sortIndex;
    }

    public MessageKind getKind() {
        return this.itemId.getKind();
    }

    @Override
    public int compareTo(SortableItemId o) {
        return Double.compare(this.sortIndex, o.sortIndex);
    }
}

