/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list;

import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.database.tables.attachment.InboundAttachment;
import io.olvid.windows.messenger.database.tables.attachment.OutboundAttachment;
import io.olvid.windows.messenger.database.tables.attachment.OwnedAttachment;
import io.olvid.windows.messenger.database.tables.ephemerality.InboundMessageEphemeralInfo;
import io.olvid.windows.messenger.database.tables.ephemerality.OutboundMessageEphemeralInfo;
import io.olvid.windows.messenger.database.tables.ephemerality.OwnedMessageEphemeralInfo;
import io.olvid.windows.messenger.database.tables.gen.ephemerality.AbstractMessageEphemeralInfoGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.InboundMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.OutboundMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.OwnedMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.SystemMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.tables.message.MessageKind;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.OwnedMessage;
import io.olvid.windows.messenger.database.tables.message.SystemMessage;
import io.olvid.windows.messenger.database.tables.metadata.InboundMessageMetadata;
import io.olvid.windows.messenger.database.tables.metadata.OutboundMessageMetadata;
import io.olvid.windows.messenger.database.tables.metadata.OwnedMessageMetadata;
import io.olvid.windows.messenger.database.tables.reaction.InboundMessageReaction;
import io.olvid.windows.messenger.database.tables.reaction.OutboundMessageReaction;
import io.olvid.windows.messenger.database.tables.reaction.OwnedMessageReaction;
import io.olvid.windows.messenger.fx.custom_components.custom_context_menu.ContextMenuFactory;
import io.olvid.windows.messenger.fx.custom_components.custom_context_menu.ContextMenuItem;
import io.olvid.windows.messenger.fx.custom_components.file.FilePreview;
import io.olvid.windows.messenger.fx.custom_components.file.HighDefLinkPreview;
import io.olvid.windows.messenger.fx.custom_components.file.ImagePreview;
import io.olvid.windows.messenger.fx.custom_components.file.LowDefLinkPreview;
import io.olvid.windows.messenger.fx.custom_components.file.PreviewUtils;
import io.olvid.windows.messenger.fx.custom_components.loader.RingProgressIndicator;
import io.olvid.windows.messenger.fx.discussions.discussion_view.DiscussionViewController;
import io.olvid.windows.messenger.fx.discussions.discussion_view.DiscussionViewModel;
import io.olvid.windows.messenger.fx.discussions.discussion_view.attachments.preview.PreviewAttachmentController;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.MessageItem;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.MessageListCellModel;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.controller.EphemerableMessageUpdater;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.controller.InboundEphemeralUpdater;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.controller.MessageViewUpdater;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.controller.UserMessageViewUpdater;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.view.InboundMessageView;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.view.MessageView;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.view.OutboundMessageView;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.view.SystemMessageView;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.view.UserMessageView;
import io.olvid.windows.messenger.fx.discussions.discussion_view.search.DiscussionSearchModel;
import io.olvid.windows.messenger.fx.generic_types.flow_view.CellWithItem;
import io.olvid.windows.messenger.fx.generic_types.flow_view.FlowListViewController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.richtextfx.RichStyledArea;
import io.olvid.windows.messenger.fx.misc.richtextfx.utils.RichStyledConfiguration;
import io.olvid.windows.messenger.livedata.cache.DbCache;
import io.olvid.windows.messenger.livedata.info.DiscussionInfoWithState;
import io.olvid.windows.messenger.livedata.info.IdentityInfo;
import io.olvid.windows.messenger.livedata.mediator.ContactInfoLiveData;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.DateUtils;
import io.olvid.windows.messenger.misc.SimpleOptionalProperty;
import io.olvid.windows.messenger.misc.StringUtils;
import io.olvid.windows.messenger.misc.Watches;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventTarget;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;

public class MessageListCell
extends VBox
implements CellWithItem<MessageItem>,
ChangeListener<MessageItem> {
    private final AppLogger logger = new AppLogger(this.getClass());
    public final RingProgressIndicator ringProgressIndicator = new RingProgressIndicator();
    private final BorderPane borderPane = new BorderPane();
    private RichStyledArea disclaimer = null;
    private final Label date = new Label();
    private final Label unreadMessagesCount = new Label();
    private final InboundMessageView inboundMessageView;
    private final OutboundMessageView outboundMessageView;
    private final SystemMessageView systemMessageView;
    private final UserMessageViewUpdater<InboundMessage, InboundMessageGenerated.Interface, InboundMessageEphemeralInfo, InboundMessageMetadata, InboundAttachment, InboundMessageReaction> inboundMessageUpdater;
    private final InboundEphemeralUpdater inboundEphemeralUpdater;
    private final UserMessageViewUpdater<OutboundMessage, OutboundMessageGenerated.Interface, OutboundMessageEphemeralInfo, OutboundMessageMetadata, OutboundAttachment, OutboundMessageReaction> outboundMessageUpdater;
    private final UserMessageViewUpdater<OwnedMessage, OwnedMessageGenerated.Interface, OwnedMessageEphemeralInfo, OwnedMessageMetadata, OwnedAttachment, OwnedMessageReaction> ownedMessageUpdater;
    private final MessageViewUpdater<SystemMessage, SystemMessageGenerated.Interface, IdentityRef, Optional<IdentityInfo>, SystemMessageView> systemMessageBodyUpdater;
    private final DoubleBinding maxWidthBinding;
    private final DiscussionViewController.ScrollInfo scrollInfo;
    public final BooleanBinding isHighlighted;
    private final SimpleOptionalProperty<MessageItem> currentMessageItem = new SimpleOptionalProperty();
    private final MessageListCellModel model;
    private final DiscussionSearchModel searchModel;
    private ObjectProperty<MessageItem> currentMessageItemObservable;
    private final FlowListViewController<MessageItem> messagesListViewController;
    private final StringProperty effectiveSearchText = new SimpleStringProperty();

    public MessageListCell(DoubleExpression listWidth, DoubleExpression listHeight, final MessageListCellModel model, DiscussionSearchModel searchModel, DiscussionViewController.ScrollInfo scrollInfo, FlowListViewController<MessageItem> messagesListViewController) {
        ViewControllerHelper.checkUIThread();
        this.model = model;
        this.searchModel = searchModel;
        this.scrollInfo = scrollInfo;
        this.messagesListViewController = messagesListViewController;
        this.setAlignment(Pos.CENTER);
        this.getStylesheets().add((Object)"fx/discussions/discussion_view/messages/message_list/message_list_cell.css");
        this.searchModel.getSearchedItemsLiveData().addListener((newValue, oldValue) -> ViewControllerHelper.smartUIUpdate(() -> this.updateEffectiveSearchIfNeeded(newValue.searchedItems())));
        this.maxWidthBinding = Bindings.createDoubleBinding(() -> Math.max(listWidth.get() * 0.7, Math.min(listWidth.get() - 100.0, 150.0)), (Observable[])new Observable[]{listWidth});
        this.inboundMessageView = new InboundMessageView(model.getTickerLiveData(), this.effectiveSearchText, (DoubleExpression)this.maxWidthBinding, listHeight, new LowDefLinkPreview.Inbound(this.model.getOpenGraphLruCache(), (DoubleExpression)this.maxWidthBinding), new HighDefLinkPreview.Inbound(this.model.getOpenGraphLruCache(), (DoubleExpression)this.maxWidthBinding));
        this.outboundMessageView = new OutboundMessageView(model.getTickerLiveData(), this.effectiveSearchText, (DoubleExpression)this.maxWidthBinding, listHeight, new LowDefLinkPreview.Outbound(model.getOpenGraphLruCache(), (DoubleExpression)this.maxWidthBinding), new HighDefLinkPreview.Outbound(model.getOpenGraphLruCache(), (DoubleExpression)this.maxWidthBinding));
        this.systemMessageView = new SystemMessageView((DoubleExpression)this.maxWidthBinding, listHeight);
        this.getChildren().add((Object)this.ringProgressIndicator);
        MessageListCell.setMargin((Node)this.ringProgressIndicator, (Insets)new Insets(16.0, 0.0, 8.0, 0.0));
        this.ringProgressIndicator.managedProperty().bind((ObservableValue)this.ringProgressIndicator.visibleProperty());
        this.ringProgressIndicator.makeIndeterminate();
        this.getChildren().add((Object)this.date);
        this.date.setId("date");
        this.date.setPadding(new Insets(8.0, 0.0, 8.0, 0.0));
        this.date.managedProperty().bind((ObservableValue)this.date.visibleProperty());
        MessageListCell.setMargin((Node)this.date, (Insets)new Insets(8.0, 0.0, 8.0, 0.0));
        this.date.getStyleClass().addAll((Object[])new String[]{"message-content-system"});
        this.getChildren().add((Object)this.unreadMessagesCount);
        this.unreadMessagesCount.setId("unreadMessagesCount");
        this.unreadMessagesCount.setPadding(new Insets(8.0, 0.0, 8.0, 0.0));
        MessageListCell.setMargin((Node)this.unreadMessagesCount, (Insets)new Insets(8.0, 0.0, 8.0, 0.0));
        this.unreadMessagesCount.managedProperty().bind((ObservableValue)this.unreadMessagesCount.visibleProperty());
        this.unreadMessagesCount.getStyleClass().addAll((Object[])new String[]{"unread-messages"});
        this.getChildren().add((Object)this.borderPane);
        this.borderPane.visibleProperty().bind((ObservableValue)Bindings.isEmpty((ObservableList)this.borderPane.getChildren()).not());
        this.borderPane.managedProperty().bind((ObservableValue)this.borderPane.visibleProperty());
        this.setPadding(new Insets(0.0, 8.0, 0.0, 8.0));
        this.isHighlighted = Bindings.createBooleanBinding(() -> {
            if (((Optional)this.searchModel.getCurrentSearchedItem().get()).isEmpty() || ((Optional)this.currentMessageItem.get()).isEmpty()) {
                return false;
            }
            DiscussionViewModel.SearchedItem searchedItem = (DiscussionViewModel.SearchedItem)((Optional)this.searchModel.getCurrentSearchedItem().get()).get();
            MessageItem messageItem = (MessageItem)((Optional)this.currentMessageItem.get()).get();
            return messageItem.getItemId().itemId().equals(searchedItem.id().itemId());
        }, (Observable[])new Observable[]{searchModel.getCurrentSearchedItem(), this.currentMessageItem});
        this.inboundMessageView.isHighlighted.bind((ObservableValue)this.isHighlighted.and((ObservableBooleanValue)this.inboundMessageView.visibleProperty()));
        this.outboundMessageView.isHighlighted.bind((ObservableValue)this.isHighlighted.and((ObservableBooleanValue)this.outboundMessageView.visibleProperty()));
        this.inboundMessageUpdater = new UserMessageViewUpdater<InboundMessage, InboundMessageGenerated.Interface, InboundMessageEphemeralInfo, InboundMessageMetadata, InboundAttachment, InboundMessageReaction>(this.model, (UserMessageView)this.inboundMessageView, DbCache.getInstance().contactRefInfoMapLiveData, this.model.getInboundMessageEphemeralInfoPerMessageId(), this.model.getInboundMessageMetadataLiveDataPerMessage(), this.model.getInboundAttachmentLiveDataPerMessage(), this.model.getReactionsLiveDataPerInboundMessage()){

            @Override
            protected EnumSet<MessageView.Action> getAvailableActions(Optional<InboundMessageEphemeralInfo> ephemeralInfo) {
                return MessageListCell.this.getAvailableActions((AbstractUserMessageGenerated.Interface)this.currentMessage, ephemeralInfo);
            }

            @Override
            protected <P extends PreviewUtils.Preview> PreviewAttachmentController<InboundAttachment, P, ?> makePreviewAttachment(P preview) {
                return new PreviewAttachmentController.Inbound<P>(preview);
            }

            @Override
            protected ImagePreview makeImagePreview() {
                return model.getImagePreview();
            }

            @Override
            protected FilePreview.FileAttachmentPreview makeFileAttachmentPreview() {
                return model.getInboundFilePreview();
            }

            @Override
            protected Id<InboundMessage> getMessageId(InboundAttachment inboundAttachment) {
                return inboundAttachment.getMessageId();
            }

            @Override
            protected Class<InboundMessage> getClazz() {
                return InboundMessage.class;
            }

            @Override
            protected Optional<Id<InboundMessageEphemeralInfo>> getEphemeralInfoId() {
                return ((InboundMessageGenerated.Interface)this.currentMessage).getInboundMessageEphemeralInfoId();
            }

            @Override
            protected void updateSenderView(ContactInfoLiveData.ContactInfoState senderState) {
                ViewControllerHelper.checkUIThread();
                super.updateSenderView(senderState);
                MessageListCell.this.inboundMessageView.updateSenderView(senderState);
            }
        };
        this.inboundEphemeralUpdater = new InboundEphemeralUpdater(this.inboundMessageView, model.getInboundMessageEphemeralInfoPerMessageId());
        this.ownedMessageUpdater = new UserMessageViewUpdater<OwnedMessage, OwnedMessageGenerated.Interface, OwnedMessageEphemeralInfo, OwnedMessageMetadata, OwnedAttachment, OwnedMessageReaction>(model, (UserMessageView)this.outboundMessageView, DbCache.getInstance().contactRefInfoMapLiveData, this.model.getOwnedMessageEphemeralInfoPerMessageId(), this.model.getOwnedMessageMetadataLiveDataPerMessage(), this.model.getOwnedAttachmentLiveDataPerMessage(), this.model.getReactionsLiveDataPerOwnedMessage()){

            @Override
            protected <P extends PreviewUtils.Preview> PreviewAttachmentController<OwnedAttachment, P, ?> makePreviewAttachment(P preview) {
                return new PreviewAttachmentController.Owned<P>(preview);
            }

            @Override
            protected ImagePreview makeImagePreview() {
                return model.getImagePreview();
            }

            @Override
            protected FilePreview.FileAttachmentPreview makeFileAttachmentPreview() {
                return model.getOutboundFilePreview();
            }

            @Override
            protected Optional<Id<OwnedMessageEphemeralInfo>> getEphemeralInfoId() {
                return Optional.empty();
            }

            @Override
            protected Id<OwnedMessage> getMessageId(OwnedAttachment attachment) {
                return attachment.getMessageId();
            }

            @Override
            protected Class<OwnedMessage> getClazz() {
                return OwnedMessage.class;
            }

            @Override
            protected EnumSet<MessageView.Action> getAvailableActions(Optional<OwnedMessageEphemeralInfo> ephemeralInfo) {
                return MessageListCell.this.getAvailableActions((AbstractUserMessageGenerated.Interface)this.currentMessage, ephemeralInfo);
            }
        };
        this.outboundMessageUpdater = new UserMessageViewUpdater<OutboundMessage, OutboundMessageGenerated.Interface, OutboundMessageEphemeralInfo, OutboundMessageMetadata, OutboundAttachment, OutboundMessageReaction>(this.model, (UserMessageView)this.outboundMessageView, DbCache.getInstance().contactRefInfoMapLiveData, this.model.getOutboundMessageEphemeralInfoPerMessageId(), this.model.getOutboundMessageMetadataLiveDataPerMessage(), this.model.getOutboundAttachmentLiveDataPerMessage(), this.model.getReactionsLiveDataPerOutboundMessage()){

            @Override
            protected <P extends PreviewUtils.Preview> PreviewAttachmentController<OutboundAttachment, P, ?> makePreviewAttachment(P preview) {
                return new PreviewAttachmentController.Outbound<P>(preview);
            }

            @Override
            protected ImagePreview makeImagePreview() {
                return model.getImagePreview();
            }

            @Override
            protected FilePreview.FileAttachmentPreview makeFileAttachmentPreview() {
                return model.getOutboundFilePreview();
            }

            @Override
            protected Id<OutboundMessage> getMessageId(OutboundAttachment outboundAttachment) {
                return outboundAttachment.getMessageId();
            }

            @Override
            protected Class<OutboundMessage> getClazz() {
                return OutboundMessage.class;
            }

            @Override
            protected Optional<Id<OutboundMessageEphemeralInfo>> getEphemeralInfoId() {
                return ((OutboundMessageGenerated.Interface)this.currentMessage).getOutboundMessageEphemeralInfoId();
            }

            @Override
            protected EnumSet<MessageView.Action> getAvailableActions(Optional<OutboundMessageEphemeralInfo> ephemeralInfo) {
                return MessageListCell.this.getAvailableActions((AbstractUserMessageGenerated.Interface)this.currentMessage, ephemeralInfo);
            }
        };
        this.systemMessageBodyUpdater = new MessageViewUpdater<SystemMessage, SystemMessageGenerated.Interface, IdentityRef, Optional<IdentityInfo>, SystemMessageView>(this, this.systemMessageView, DbCache.getInstance().identityInfoMapLiveData){

            @Override
            protected void updateSenderView(Optional<IdentityInfo> identityInfo) {
                ((SystemMessageView)this.view).setSystemLabel((SystemMessageGenerated.Interface)this.currentMessage, identityInfo);
            }
        };
    }

    private EnumSet<MessageView.Action> getAvailableActions(AbstractUserMessageGenerated.Interface<?> message, Optional<? extends AbstractMessageEphemeralInfoGenerated<?>> ephemeralInfoOpt) {
        Optional<DiscussionInfoWithState> discussionOpt = this.model.getDbSelectedDiscussion().getValue();
        if (discussionOpt == null || discussionOpt.isEmpty()) {
            this.logger.error("Cannot find selected discussion");
            return EnumSet.noneOf(MessageView.Action.class);
        }
        DiscussionInfoWithState discussion = discussionOpt.get();
        EnumSet<MessageView.Action> actions = EnumSet.of(MessageView.Action.DELETE);
        actions.add(MessageView.Action.OPEN_INFO);
        switch (message.getWipeStatus()) {
            case WIPED: 
            case REMOTE_DELETED: {
                return actions;
            }
        }
        boolean hasLimitedVisibility = false;
        if (ephemeralInfoOpt.isPresent()) {
            AbstractMessageEphemeralInfoGenerated<?> ephemeralInfo = ephemeralInfoOpt.get();
            boolean bl = hasLimitedVisibility = ephemeralInfo.isReadOnce() || ephemeralInfo.getVisibilityDuration().isPresent();
        }
        if (discussion.canPostMessage()) {
            actions.add(MessageView.Action.REPLY_TO);
        }
        if (!hasLimitedVisibility) {
            actions.add(MessageView.Action.FORWARD);
            actions.add(MessageView.Action.COPY);
        }
        if (!(message instanceof InboundMessageGenerated.Interface) && discussion.canEditOwnedMessage() && message.getLocationId().isEmpty()) {
            actions.add(MessageView.Action.EDIT);
        }
        if (this.haveReactions(message)) {
            actions.add(MessageView.Action.REACTIONS_DETAILS);
        }
        return actions;
    }

    public Node getNode() {
        return this;
    }

    public void reset() {
        this.clean();
        CellWithItem.super.reset();
    }

    @Override
    public Optional<MessageItem> getItem() {
        return (Optional)this.currentMessageItem.getValue();
    }

    public boolean isReusable() {
        return true;
    }

    public void updateItem(ObjectProperty<MessageItem> messageItemObservable) {
        this.currentMessageItemObservable = messageItemObservable;
        this.updateItem((MessageItem)messageItemObservable.get());
        this.currentMessageItemObservable.addListener((ChangeListener)this);
    }

    public void changed(ObservableValue<? extends MessageItem> observableValue, MessageItem oldValue, MessageItem newValue) {
        ViewControllerHelper.smartUIUpdate(() -> this.updateItem(newValue));
    }

    private void buildDisclaimer() {
        this.disclaimer = new RichStyledArea(RichStyledConfiguration.empty());
        this.getChildren().addFirst((Object)this.disclaimer);
        MessageListCell.setMargin((Node)this.disclaimer, (Insets)new Insets(8.0, 0.0, 8.0, 0.0));
        this.disclaimer.setPadding(new Insets(8.0));
        this.disclaimer.setEditable(false);
        this.disclaimer.setMouseTransparent(true);
        this.disclaimer.replaceText(ViewControllerHelper.getString("message_content_disclaimer_label"));
        this.disclaimer.managedProperty().bind((ObservableValue)this.disclaimer.visibleProperty());
        this.disclaimer.getStyleClass().setAll((Object[])new String[]{"message-content-system", "disclaimer-message"});
        this.disclaimer.maxWidthProperty().bind((ObservableValue)this.maxWidthBinding);
    }

    private void updateDisclaimer(boolean visible) {
        if (visible) {
            if (this.disclaimer == null) {
                this.buildDisclaimer();
            }
            this.disclaimer.setVisible(true);
        } else if (this.disclaimer != null) {
            this.disclaimer.setVisible(false);
        }
    }

    private void updateDate(MessageItem messageItem) {
        if (messageItem.getKind() == MessageKind.DISCLAIMER) {
            this.date.setVisible(false);
            return;
        }
        if (messageItem.getPrevious().isPresent()) {
            MessageItem previous = messageItem.getPrevious().get();
            LocalDateTime currentDays = messageItem.getLocalDateTime().truncatedTo(ChronoUnit.DAYS);
            LocalDateTime previousDays = previous.getLocalDateTime().truncatedTo(ChronoUnit.DAYS);
            if (previousDays.equals(currentDays)) {
                this.date.setVisible(false);
                return;
            }
        }
        this.date.setText(DateUtils.formatRelativeDate(messageItem.getLocalDateTime()));
        this.date.setVisible(true);
    }

    private void updateUnreadMessagesCount(MessageItem messageItem) {
        if (messageItem.getKind() == MessageKind.DISCLAIMER) {
            this.unreadMessagesCount.setVisible(false);
            return;
        }
        if (messageItem.getUnreadCount() > 0) {
            this.unreadMessagesCount.setText(StringUtils.localizePlurals("one_unread_message_count", "one_unread_message_count", "many_unread_messages_count", messageItem.getUnreadCount()));
            this.unreadMessagesCount.setVisible(true);
        } else {
            this.unreadMessagesCount.setVisible(false);
        }
    }

    private boolean haveSameSender(InboundMessageGenerated.Interface inboundMessage, MessageItem otherMessageItem) {
        if (otherMessageItem.getKind() != MessageKind.INBOUND) {
            return false;
        }
        InboundMessageGenerated.Interface otherInboundMessage = otherMessageItem.getInboundMessage();
        return otherInboundMessage.getSenderId().equals(inboundMessage.getSenderId());
    }

    private boolean consecutiveWithPrevious(Optional<MessageItem> previousOpt, InboundMessageGenerated.Interface inboundMessage) {
        Optional<DiscussionInfoWithState> discussion = this.model.getDbSelectedDiscussion().getValue();
        if (discussion == null) {
            this.logger.error("MessageListCell::updateItem Cannot find selected discussion");
            return false;
        }
        if (discussion.isPresent() && discussion.get().info().kind() != Discussion.Kind.GROUP) {
            return true;
        }
        if (this.date.isVisible()) {
            return false;
        }
        if (this.unreadMessagesCount.isVisible()) {
            return false;
        }
        if (previousOpt.isEmpty()) {
            return false;
        }
        return this.haveSameSender(inboundMessage, previousOpt.get());
    }

    private boolean consecutiveWithNext(InboundMessageGenerated.Interface inboundMessage, Optional<MessageItem> nextOpt) {
        if (nextOpt.isEmpty()) {
            return false;
        }
        MessageItem next = nextOpt.get();
        if (!this.haveSameSender(inboundMessage, next)) {
            return false;
        }
        LocalDateTime nextMinute = next.getLocalDateTime().truncatedTo(ChronoUnit.MINUTES);
        LocalDateTime currentMinute = DateUtils.of(inboundMessage.getTimestamp()).truncatedTo(ChronoUnit.MINUTES);
        return nextMinute.equals(currentMinute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateItem(MessageItem messageItem) {
        ViewControllerHelper.checkUIThread();
        Watches.Watch watch = Watches.getInstance().start("MessageListCell::updateItem");
        try {
            this.ringProgressIndicator.setVisible(messageItem.showSpinner());
            this.updateDate(messageItem);
            this.updateUnreadMessagesCount(messageItem);
            switch (messageItem.getKind()) {
                case INBOUND: {
                    this.borderPane.setLeft((Node)this.inboundMessageView);
                    this.borderPane.setRight(null);
                    this.borderPane.setCenter(null);
                    InboundMessageGenerated.Interface inboundMessage = messageItem.getInboundMessage();
                    Optional contactRef = Optional.of(inboundMessage.getSenderId());
                    boolean consecutiveWithPrevious = this.consecutiveWithPrevious(messageItem.getPrevious(), inboundMessage);
                    boolean consecutiveWithNext = this.consecutiveWithNext(inboundMessage, messageItem.getNext());
                    if (inboundMessage.isBoxed()) {
                        this.inboundMessageUpdater.updateFileAttachmentsView(List.of());
                        this.inboundMessageUpdater.updateImagesAttachmentsView(List.of());
                        this.inboundMessageUpdater.cleanLinkPreview();
                        this.inboundMessageView.updateReaction(List.of());
                        this.inboundMessageView.setForwarded(false);
                        this.inboundEphemeralUpdater.update(inboundMessage, consecutiveWithPrevious, consecutiveWithNext, contactRef);
                        this.logger.debug("updateItem ALIGNMENT CENTER");
                        this.inboundMessageView.setTextAlignment(TextAlignment.CENTER);
                        this.setContextMenu(messageItem, this.inboundEphemeralUpdater);
                    } else {
                        boolean wasAlignmentHandled = false;
                        if (inboundMessage.getInboundMessageEphemeralInfoId().isPresent()) {
                            this.inboundEphemeralUpdater.update(inboundMessage, consecutiveWithPrevious, consecutiveWithNext, contactRef);
                            wasAlignmentHandled = true;
                        }
                        if (!wasAlignmentHandled) {
                            this.inboundMessageView.setTextAlignment(TextAlignment.LEFT);
                        }
                        this.inboundMessageView.setDisableSearch(false);
                        this.inboundMessageView.setContentMouseTransparent(false);
                        this.inboundMessageView.setStatusLabel(Optional.empty(), Optional.empty());
                        this.inboundMessageUpdater.update(inboundMessage, consecutiveWithPrevious, consecutiveWithNext, contactRef);
                        this.inboundMessageView.setReactionsClickAction(messageItem, this.model.getDiscussionViewModel());
                        this.setContextMenu(messageItem, this.inboundMessageUpdater);
                    }
                    if (inboundMessage.getWipeStatus() == AbstractUserMessageGenerated.WipeStatus.WIPE_ON_READ) {
                        this.model.getReadInboundMessagesToAnnihilate().add((Id<InboundMessage>)inboundMessage.getItemId());
                    }
                    if (inboundMessage.getStatus() != InboundMessageGenerated.Status.UNREAD) break;
                    this.scrollInfo.update(inboundMessage.getTimestamp());
                    break;
                }
                case OUTBOUND: {
                    this.borderPane.setLeft(null);
                    this.borderPane.setRight((Node)this.outboundMessageView);
                    this.borderPane.setCenter(null);
                    OutboundMessageGenerated.Interface outboundMessage = messageItem.getOutboundMessage();
                    this.outboundMessageUpdater.update(outboundMessage, false, false, Optional.empty());
                    this.outboundMessageView.setStatus(outboundMessage.getStatus());
                    this.outboundMessageView.setReactionsClickAction(messageItem, this.model.getDiscussionViewModel());
                    if (outboundMessage.getWipeStatus() == AbstractUserMessageGenerated.WipeStatus.WIPE_ON_READ) {
                        this.model.getReadOutboundMessagesToAnnihilate().add((Id<OutboundMessage>)outboundMessage.getItemId());
                    }
                    this.setContextMenu(messageItem, this.outboundMessageUpdater);
                    break;
                }
                case OWNED: {
                    this.borderPane.setLeft(null);
                    this.borderPane.setRight((Node)this.outboundMessageView);
                    this.borderPane.setCenter(null);
                    OwnedMessageGenerated.Interface ownedMessage = messageItem.getOwnedMessage();
                    this.ownedMessageUpdater.update(ownedMessage, false, false, Optional.empty());
                    this.outboundMessageView.setStatus(ownedMessage.getStatus());
                    this.outboundMessageView.setReactionsClickAction(messageItem, this.model.getDiscussionViewModel());
                    if (ownedMessage.getWipeStatus() == AbstractUserMessageGenerated.WipeStatus.WIPE_ON_READ) {
                        this.model.getReadOwnedMessagesToAnnihilate().add((Id<OwnedMessage>)ownedMessage.getItemId());
                    }
                    this.setContextMenu(messageItem, this.ownedMessageUpdater);
                    break;
                }
                case SYSTEM: {
                    this.borderPane.setLeft(null);
                    this.borderPane.setRight(null);
                    this.borderPane.setCenter((Node)this.systemMessageView);
                    SystemMessageGenerated.Interface systemMessage = messageItem.getSystemMessage();
                    Optional identityRefId = systemMessage.getIdentityRefId();
                    this.systemMessageView.setSystemLabel(systemMessage, Optional.empty());
                    this.systemMessageBodyUpdater.update(systemMessage, false, false, identityRefId);
                    this.setOnContextMenuRequested(null);
                    break;
                }
                case DISCLAIMER: {
                    this.borderPane.getChildren().clear();
                    this.setOnContextMenuRequested(null);
                }
            }
            this.updateDisclaimer(messageItem.getKind() == MessageKind.DISCLAIMER);
            this.currentMessageItem.set(Optional.of(messageItem));
            this.updateEffectiveSearchIfNeeded(this.searchModel.getSearchedItemsLiveData().getSearchedItems());
            AppLogger.t("MessageListCell::updateItem end --> " + String.valueOf(messageItem.getItemId()));
        }
        finally {
            watch.stop();
        }
    }

    private void updateEffectiveSearchIfNeeded(List<DiscussionViewModel.SearchedItem> searchedItems) {
        ViewControllerHelper.checkUIThread();
        Watches.Watch searchItemGoThrough = Watches.getInstance().start("searchedItemGoThrough");
        boolean toto = searchedItems.stream().anyMatch(searchedItem -> ((Optional)this.currentMessageItem.getValue()).isPresent() && ((MessageItem)((Optional)this.currentMessageItem.getValue()).get()).getItemId().equals(searchedItem.id()));
        searchItemGoThrough.stop();
        if (toto) {
            this.effectiveSearchText.set((Object)((String)this.searchModel.getSearchTextProperty().get()));
        } else {
            this.effectiveSearchText.set(null);
        }
    }

    private void setContextMenu(MessageItem messageItem, EphemerableMessageUpdater<?, ?, ?, ?, ?, ?> updater) {
        this.setOnContextMenuRequested(event -> ContextMenuFactory.loadContextMenuWithScreenCoordinates(event.getScreenX(), event.getScreenY(), this.getMenuItems(messageItem, event.getTarget(), updater.availableActions)));
    }

    private List<MenuItem> getMenuItems(MessageItem messageItem, EventTarget eventTarget, EnumSet<MessageView.Action> availableActions) {
        AbstractMessageGenerated.Interface<?> msgInterface;
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        if ((messageItem.getKind() == MessageKind.INBOUND || messageItem.getKind() == MessageKind.OUTBOUND || messageItem.getKind() == MessageKind.OWNED) && (msgInterface = messageItem.getWeakenedMessageInterface()) instanceof AbstractUserMessageGenerated.Interface) {
            AbstractUserMessageGenerated.Interface userMessage = (AbstractUserMessageGenerated.Interface)msgInterface;
            availableActions = EnumSet.copyOf(availableActions);
            if (this.haveReactions(userMessage)) {
                availableActions.add(MessageView.Action.REACTIONS_DETAILS);
            } else {
                availableActions.remove((Object)MessageView.Action.REACTIONS_DETAILS);
            }
        }
        for (MessageView.Action action : availableActions) {
            items.add((MenuItem)new ContextMenuItem(ViewControllerHelper.getString(action.labelKey()), action.labelStyle(), () -> this.model.runAction(action, messageItem, eventTarget, this.messagesListViewController), List.of(action.svg, action.sizeClass(), "icon-grey"), 250.0));
        }
        return items;
    }

    private void clean() {
        if (((Optional)this.currentMessageItem.getValue()).isEmpty()) {
            return;
        }
        if (this.currentMessageItemObservable != null) {
            this.currentMessageItemObservable.removeListener((ChangeListener)this);
            this.currentMessageItemObservable = null;
        }
        MessageItem item = (MessageItem)((Optional)this.currentMessageItem.getValue()).get();
        switch (item.getKind()) {
            case INBOUND: {
                if (item.getInboundMessage().isBoxed()) {
                    this.inboundEphemeralUpdater.clean();
                    break;
                }
                this.inboundMessageUpdater.clean();
                break;
            }
            case OUTBOUND: {
                this.outboundMessageUpdater.clean();
                break;
            }
            case OWNED: {
                this.ownedMessageUpdater.clean();
                break;
            }
            case SYSTEM: {
                this.systemMessageBodyUpdater.clean();
                break;
            }
        }
        this.currentMessageItem.set(Optional.empty());
    }

    public String toString() {
        return "MessageListCell:" + String.valueOf(this.getItem());
    }

    private boolean haveReactions(AbstractUserMessageGenerated.Interface<?> message) {
        if (message instanceof InboundMessageGenerated.Interface) {
            InboundMessageGenerated.Interface inbound = (InboundMessageGenerated.Interface)message;
            List<InboundMessageReaction> reactions = this.model.getReactionsLiveDataPerInboundMessage().getCurrentValue((Id<InboundMessage>)inbound.getItemId());
            return reactions != null && !reactions.isEmpty();
        }
        if (message instanceof OutboundMessageGenerated.Interface) {
            OutboundMessageGenerated.Interface outbound = (OutboundMessageGenerated.Interface)message;
            List<OutboundMessageReaction> reactions = this.model.getReactionsLiveDataPerOutboundMessage().getCurrentValue((Id<OutboundMessage>)outbound.getItemId());
            return reactions != null && !reactions.isEmpty();
        }
        if (message instanceof OwnedMessageGenerated.Interface) {
            OwnedMessageGenerated.Interface owned = (OwnedMessageGenerated.Interface)message;
            List<OwnedMessageReaction> reactions = this.model.getReactionsLiveDataPerOwnedMessage().getCurrentValue((Id<OwnedMessage>)owned.getItemId());
            return reactions != null && !reactions.isEmpty();
        }
        return false;
    }
}

