/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.InboundMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.OutboundMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.OwnedMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.SystemMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.tables.message.MessageChoice;
import io.olvid.windows.messenger.database.tables.message.MessageKind;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.OwnedMessage;
import io.olvid.windows.messenger.database.tables.message.SystemMessage;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.SortableItemId;
import io.olvid.windows.messenger.fx.generic_types.DiffUtils;
import io.olvid.windows.messenger.livedata.Diffable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Objects;
import java.util.Optional;

public final class MessageItem
extends MessageChoice<InboundMessageGenerated.Interface, OutboundMessageGenerated.Interface, OwnedMessageGenerated.Interface, SystemMessageGenerated.Interface>
implements Diffable,
Comparable<MessageItem>,
Cloneable {
    private final Id<Discussion> discussionId;
    private final SortableItemId itemId;
    private int unreadCount = 0;
    private MessageItem previous = null;
    private MessageItem next = null;
    private boolean showSpinner = false;
    private LocalDateTime localDateTime = null;

    private MessageItem(Id<Discussion> discussionId, SortableItemId itemId, InboundMessageGenerated.Interface inboundMessage, OutboundMessageGenerated.Interface outboundMessage, OwnedMessageGenerated.Interface ownedMessage, SystemMessageGenerated.Interface systemMessage) {
        super(inboundMessage, outboundMessage, ownedMessage, systemMessage);
        this.discussionId = discussionId;
        this.itemId = itemId;
    }

    public static MessageItem of(InboundMessageGenerated.Interface inboundMessage) {
        Objects.requireNonNull(inboundMessage);
        return new MessageItem(inboundMessage.getDiscussionId(), SortableItemId.ofInbound((Id<InboundMessage>)inboundMessage.getItemId(), inboundMessage.getSortIndex()), inboundMessage, null, null, null);
    }

    public static MessageItem of(OutboundMessageGenerated.Interface outboundMessage) {
        Objects.requireNonNull(outboundMessage);
        return new MessageItem(outboundMessage.getDiscussionId(), SortableItemId.ofOutbound((Id<OutboundMessage>)outboundMessage.getItemId(), outboundMessage.getSortIndex()), null, outboundMessage, null, null);
    }

    public static MessageItem of(OwnedMessageGenerated.Interface ownedMessage) {
        Objects.requireNonNull(ownedMessage);
        return new MessageItem(ownedMessage.getDiscussionId(), SortableItemId.ofOwned((Id<OwnedMessage>)ownedMessage.getItemId(), ownedMessage.getSortIndex()), null, null, ownedMessage, null);
    }

    public static MessageItem of(SystemMessageGenerated.Interface systemMessage) {
        Objects.requireNonNull(systemMessage);
        return new MessageItem(systemMessage.getDiscussionId(), SortableItemId.ofSystem((Id<SystemMessage>)systemMessage.getItemId(), systemMessage.getSortIndex()), null, null, null, systemMessage);
    }

    public static MessageItem disclaimer(Id<Discussion> discussionId) {
        return new MessageItem(discussionId, SortableItemId.ofDisclaimer(), null, null, null, null);
    }

    public int getUnreadCount() {
        return this.unreadCount;
    }

    public void setUnreadCount(int unreadCount) {
        this.unreadCount = unreadCount;
    }

    public InboundMessageGenerated.Interface getInboundMessage() {
        return (InboundMessageGenerated.Interface)this.inbound;
    }

    public OutboundMessageGenerated.Interface getOutboundMessage() {
        return (OutboundMessageGenerated.Interface)this.outbound;
    }

    public OwnedMessageGenerated.Interface getOwnedMessage() {
        return (OwnedMessageGenerated.Interface)this.owned;
    }

    public SystemMessageGenerated.Interface getSystemMessage() {
        return (SystemMessageGenerated.Interface)this.system;
    }

    public boolean isDraft() {
        if (this.outbound == null) {
            return false;
        }
        return ((OutboundMessageGenerated.Interface)this.outbound).getStatus() == OutboundMessageGenerated.Status.DRAFT;
    }

    public boolean isBoxed() {
        if (this.inbound == null) {
            return false;
        }
        return ((InboundMessageGenerated.Interface)this.inbound).isBoxed();
    }

    public synchronized LocalDateTime getLocalDateTime() {
        if (this.localDateTime != null) {
            return this.localDateTime;
        }
        long timestamp = switch (this.kind) {
            default -> throw new MatchException(null, null);
            case MessageKind.INBOUND -> ((InboundMessageGenerated.Interface)this.inbound).getTimestamp();
            case MessageKind.OUTBOUND -> ((OutboundMessageGenerated.Interface)this.outbound).getTimestamp();
            case MessageKind.OWNED -> ((OwnedMessageGenerated.Interface)this.owned).getTimestamp();
            case MessageKind.SYSTEM -> ((SystemMessageGenerated.Interface)this.system).getTimestamp();
            case MessageKind.DISCLAIMER -> 0L;
        };
        Instant instant = Instant.ofEpochMilli(timestamp);
        this.localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        return this.localDateTime;
    }

    public double getSortIndex() {
        return switch (this.kind) {
            default -> throw new MatchException(null, null);
            case MessageKind.INBOUND -> ((InboundMessageGenerated.Interface)this.inbound).getSortIndex();
            case MessageKind.OUTBOUND -> ((OutboundMessageGenerated.Interface)this.outbound).getSortIndex();
            case MessageKind.OWNED -> ((OwnedMessageGenerated.Interface)this.owned).getSortIndex();
            case MessageKind.SYSTEM -> ((SystemMessageGenerated.Interface)this.system).getSortIndex();
            case MessageKind.DISCLAIMER -> 0.0;
        };
    }

    @Override
    public int compareTo(MessageItem o) {
        return Double.compare(this.getSortIndex(), o.getSortIndex());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageItem other = (MessageItem)o;
        if (!this.getItemId().equals(other.getItemId())) {
            return false;
        }
        if (this.unreadCount != other.unreadCount) {
            return false;
        }
        if (this.showSpinner != other.showSpinner) {
            return false;
        }
        if (!this.getPrevious().map(MessageItem::getItemId).equals(other.getPrevious().map(MessageItem::getItemId))) {
            return false;
        }
        if (!this.getNext().map(MessageItem::getItemId).equals(other.getNext().map(MessageItem::getItemId))) {
            return false;
        }
        return DiffUtils.areContentTheSame((InboundMessageGenerated.Interface)this.inbound, (InboundMessageGenerated.Interface)other.inbound) && DiffUtils.areContentTheSame((OutboundMessageGenerated.Interface)this.outbound, (OutboundMessageGenerated.Interface)other.outbound) && DiffUtils.areContentTheSame((OwnedMessageGenerated.Interface)this.owned, (OwnedMessageGenerated.Interface)other.owned) && DiffUtils.areContentTheSame((SystemMessageGenerated.Interface)this.system, (SystemMessageGenerated.Interface)other.system);
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        return this.equals(obj);
    }

    public boolean wasRemotelyDeleted() {
        switch (this.kind) {
            case INBOUND: {
                return ((InboundMessageGenerated.Interface)this.inbound).getWipeStatus() == AbstractUserMessageGenerated.WipeStatus.REMOTE_DELETED;
            }
            case OUTBOUND: {
                return ((OutboundMessageGenerated.Interface)this.outbound).getWipeStatus() == AbstractUserMessageGenerated.WipeStatus.REMOTE_DELETED;
            }
            case OWNED: {
                return ((OwnedMessageGenerated.Interface)this.owned).getWipeStatus() == AbstractUserMessageGenerated.WipeStatus.REMOTE_DELETED;
            }
        }
        return false;
    }

    public Optional<MessageItem> getPrevious() {
        return Optional.ofNullable(this.previous);
    }

    public Optional<MessageItem> getNext() {
        return Optional.ofNullable(this.next);
    }

    public void setPrevious(MessageItem previous) {
        this.previous = previous;
    }

    public void setNext(MessageItem next) {
        this.next = next;
    }

    public boolean showSpinner() {
        return this.showSpinner;
    }

    public void setShowSpinner(boolean showSpinner) {
        this.showSpinner = showSpinner;
    }

    public boolean wasSentByMe() {
        return this.kind == MessageKind.OUTBOUND || this.kind == MessageKind.OWNED;
    }

    @Override
    public SortableItemId getItemId() {
        return this.itemId;
    }

    public AbstractMessageGenerated.Interface<?> getWeakenedMessageInterface() {
        return switch (this.kind) {
            default -> throw new MatchException(null, null);
            case MessageKind.INBOUND -> (InboundMessageGenerated.Interface)this.inbound;
            case MessageKind.OUTBOUND -> (OutboundMessageGenerated.Interface)this.outbound;
            case MessageKind.OWNED -> (OwnedMessageGenerated.Interface)this.owned;
            case MessageKind.SYSTEM -> (SystemMessageGenerated.Interface)this.system;
            case MessageKind.DISCLAIMER -> throw new IllegalStateException();
        };
    }

    public AbstractMessageGenerated<?> getWeakenedMessage() {
        return switch (this.kind) {
            default -> throw new MatchException(null, null);
            case MessageKind.INBOUND -> (InboundMessage)DbManager.getInstance().getInboundMessageDao().get(((InboundMessageGenerated.Interface)this.inbound).getItemId());
            case MessageKind.OUTBOUND -> (OutboundMessage)DbManager.getInstance().getOutboundMessageDao().get(((OutboundMessageGenerated.Interface)this.outbound).getItemId());
            case MessageKind.OWNED -> (OwnedMessage)DbManager.getInstance().getOwnedMessageDao().get(((OwnedMessageGenerated.Interface)this.owned).getItemId());
            case MessageKind.SYSTEM -> (SystemMessage)DbManager.getInstance().getSystemMessageDao().get(((SystemMessageGenerated.Interface)this.system).getItemId());
            case MessageKind.DISCLAIMER -> throw new IllegalStateException();
        };
    }

    public Optional<String> getBodyForSearch() {
        InboundMessageGenerated.Interface inboundMessage;
        if (this.kind == MessageKind.DISCLAIMER || this.kind == MessageKind.SYSTEM) {
            return Optional.empty();
        }
        AbstractMessageGenerated.Interface<?> weakenedMessage = this.getWeakenedMessageInterface();
        if (!(weakenedMessage instanceof AbstractUserMessageGenerated.Interface)) {
            return Optional.empty();
        }
        AbstractUserMessageGenerated.Interface userMessage = (AbstractUserMessageGenerated.Interface)weakenedMessage;
        switch (userMessage.getWipeStatus()) {
            case NONE: 
            case WIPE_ON_READ: {
                break;
            }
            case WIPED: 
            case REMOTE_DELETED: {
                return Optional.empty();
            }
        }
        if (userMessage instanceof InboundMessageGenerated.Interface && (inboundMessage = (InboundMessageGenerated.Interface)userMessage).isBoxed()) {
            return Optional.empty();
        }
        return userMessage.getBody();
    }

    public Id<Discussion> getDiscussionId() {
        return this.discussionId;
    }

    public String toString() {
        return String.format("MessageItem[%s]", this.getItemId());
    }

    public MessageItem clone() {
        try {
            return (MessageItem)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }
}

