/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list;

import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.tables.message.MessageChoice;
import io.olvid.windows.messenger.database.tables.message.MessageKind;
import io.olvid.windows.messenger.database.tables.message.MessageRef;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.OwnedMessage;
import io.olvid.windows.messenger.database.tables.message.SystemMessage;
import java.util.Optional;

public class ItemId
extends MessageChoice<Id<InboundMessage>, Id<OutboundMessage>, Id<OwnedMessage>, Id<SystemMessage>> {
    protected ItemId(Id<InboundMessage> inboundMessageId, Id<OutboundMessage> outboundMessageId, Id<OwnedMessage> ownedMessageId, Id<SystemMessage> systemMessageId) {
        super(inboundMessageId, outboundMessageId, ownedMessageId, systemMessageId);
    }

    public static ItemId ofInbound(Id<InboundMessage> id) {
        return new ItemId(id, null, null, null);
    }

    public static ItemId ofOutbound(Id<OutboundMessage> id) {
        return new ItemId(null, id, null, null);
    }

    public static ItemId ofOwned(Id<OwnedMessage> id) {
        return new ItemId(null, null, id, null);
    }

    public static ItemId ofSystem(Id<SystemMessage> id) {
        return new ItemId(null, null, null, id);
    }

    public static ItemId ofDisclaimer() {
        return new ItemId(null, null, null, null);
    }

    public static Optional<ItemId> ofRef(MessageRef messageRef) {
        return switch (messageRef.getKind()) {
            default -> throw new MatchException(null, null);
            case MessageRef.Kind.NOT_RECEIVED, MessageRef.Kind.DELETED -> Optional.empty();
            case MessageRef.Kind.INBOUND -> {
                if (!$assertionsDisabled && !messageRef.getInboundMessageId().isPresent()) {
                    throw new AssertionError();
                }
                yield Optional.of(ItemId.ofInbound(messageRef.getInboundMessageId().get()));
            }
            case MessageRef.Kind.OUTBOUND -> {
                if (!$assertionsDisabled && !messageRef.getOutboundMessageId().isPresent()) {
                    throw new AssertionError();
                }
                yield Optional.of(ItemId.ofOutbound(messageRef.getOutboundMessageId().get()));
            }
            case MessageRef.Kind.OWNED -> {
                if (!$assertionsDisabled && !messageRef.getOwnedMessageId().isPresent()) {
                    throw new AssertionError();
                }
                yield Optional.of(ItemId.ofOwned(messageRef.getOwnedMessageId().get()));
            }
        };
    }

    public String toString() {
        return switch (this.kind) {
            default -> throw new MatchException(null, null);
            case MessageKind.INBOUND -> String.format("inbound[%s]", ((Id)this.inbound).toString());
            case MessageKind.OUTBOUND -> String.format("outbound[%s]", ((Id)this.outbound).toString());
            case MessageKind.OWNED -> String.format("owned[%s]", ((Id)this.owned).toString());
            case MessageKind.SYSTEM -> String.format("system[%s]", ((Id)this.system).toString());
            case MessageKind.DISCLAIMER -> "disclaimer";
        };
    }
}

