/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_composer.reply;

import io.olvid.windows.messenger.fx.framework.annotations.FXMLView;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.livedata.info.ContactInfo;
import io.olvid.windows.messenger.livedata.info.IdentityDetailsInfo;
import io.olvid.windows.messenger.livedata.info.MessageRefInfo;
import io.olvid.windows.messenger.livedata.mediator.ContactInfoLiveData;
import java.lang.runtime.SwitchBootstraps;
import java.text.MessageFormat;
import java.util.Objects;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;

@FXMLView(path="fx/discussions/discussion_view/messages/message_composer/reply/reply.fxml")
public class ReplyController
extends BaseViewController {
    @FXML
    private HBox root;
    @FXML
    private Label contact_name;
    @FXML
    private Label body;
    @FXML
    private Label attachments;
    @FXML
    private Button close_button;

    public ReplyController(Runnable close) {
        this.loadFxml();
        this.close_button.setOnAction(event -> close.run());
        this.attachments.managedProperty().bind((ObservableValue)this.attachments.visibleProperty());
        this.attachments.visibleProperty().bind((ObservableValue)this.attachments.textProperty().isNotEmpty());
        this.body.maxHeightProperty().bind((ObservableValue)new SimpleLongProperty(25L));
        this.body.prefHeightProperty().bind((ObservableValue)this.body.maxHeightProperty());
        this.body.minHeightProperty().bind((ObservableValue)this.body.maxHeightProperty());
        this.body.managedProperty().bind((ObservableValue)this.body.visibleProperty());
        this.body.visibleProperty().bind((ObservableValue)Bindings.isNotEmpty((ObservableStringValue)this.body.textProperty()));
    }

    @Override
    public Region getLayout() {
        return this.root;
    }

    @Override
    public void onLayoutAttached() {
    }

    @Override
    public void onLayoutDetached() {
    }

    public void set(MessageRefInfo messageRefInfo) {
        String body = messageRefInfo.getBody().orElse("");
        int totalAttachmentCount = messageRefInfo.getTotalAttachmentCount();
        String attachmentText = switch (totalAttachmentCount) {
            case 0 -> "";
            case 1 -> ViewControllerHelper.getString("one_attachment_count");
            default -> MessageFormat.format(ViewControllerHelper.getString("multiple_attachment_count"), totalAttachmentCount);
        };
        ViewControllerHelper.smartUIUpdate(() -> {
            this.body.setText(body);
            this.attachments.setText(attachmentText);
        });
    }

    public void set(ContactInfoLiveData.ContactInfoState contactInfoState) {
        ContactInfoLiveData.ContactInfoState contactInfoState2 = contactInfoState;
        Objects.requireNonNull(contactInfoState2);
        ContactInfoLiveData.ContactInfoState contactInfoState3 = contactInfoState2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ContactInfoLiveData.ContactInfoState.Computing.class, ContactInfoLiveData.ContactInfoState.Deleted.class, ContactInfoLiveData.ContactInfoState.Present.class}, (Object)contactInfoState3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                ContactInfoLiveData.ContactInfoState.Computing computing = (ContactInfoLiveData.ContactInfoState.Computing)contactInfoState3;
                ViewControllerHelper.smartUIUpdate(() -> this.contact_name.setText(null));
                break;
            }
            case 1: {
                ContactInfoLiveData.ContactInfoState.Deleted deleted = (ContactInfoLiveData.ContactInfoState.Deleted)contactInfoState3;
                ViewControllerHelper.smartUIUpdate(() -> this.contact_name.setText(ViewControllerHelper.getString("deleted_contact")));
                break;
            }
            case 2: {
                ContactInfoLiveData.ContactInfoState.Present present = (ContactInfoLiveData.ContactInfoState.Present)contactInfoState3;
                ContactInfo contactInfo = present.info();
                String name = contactInfo.getCustomOrDisplayName(IdentityDetailsInfo.Format.FIRST_LAST);
                ViewControllerHelper.smartUIUpdate(() -> this.contact_name.setText(name));
            }
        }
    }

    public void setOwnedIdentity() {
        ViewControllerHelper.smartUIUpdate(() -> this.contact_name.setText(ViewControllerHelper.getString("you")));
    }
}

