/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_composer.preview;

import io.olvid.windows.messenger.fx.custom_components.file.LowDefLinkPreview;
import io.olvid.windows.messenger.fx.custom_components.file.PreviewUtils;
import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.misc.OpenGraphLruCache;
import io.olvid.windows.messenger.fx.misc.textflow.EmojiTextFlow;
import io.olvid.windows.messenger.fx.misc.textflow.LineLimitedTextFlow;
import io.olvid.windows.messenger.misc.Either;
import java.util.Optional;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;

public class DraftLinkPreview
extends LowDefLinkPreview {
    final Button closeButton = new Button();

    public DraftLinkPreview(OpenGraphLruCache openGraphLruCache, DoubleExpression maxWidthBinding) {
        super(openGraphLruCache, maxWidthBinding);
        this.closeButton.getStyleClass().add((Object)"action-button");
        Region spacer = new Region();
        this.getChildren().add((Object)spacer);
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        SvgSizeable icon = new SvgSizeable();
        icon.getStyleClass().addAll((Object[])new String[]{"icon-large", "icon-white", "svg-filled-close"});
        this.closeButton.setGraphic((Node)icon);
        DraftLinkPreview.setAlignment((Node)this.closeButton, (Pos)Pos.CENTER);
        this.setRight((Node)this.closeButton);
        this.getStyleClass().addAll((Object[])new String[]{"light-grey-pane", "round-pane"});
        this.setPadding(new Insets(8.0));
        this.configureStyle();
    }

    @Override
    protected void bindMaxWidth(DoubleExpression maxWidthBinding) {
        this.maxWidthProperty().bind((ObservableValue)maxWidthBinding);
    }

    @Override
    protected Either<EmojiTextFlow, Label> makeSubtitle() {
        return Either.left(new LineLimitedTextFlow());
    }

    public void setCloseAction(Runnable closeAction) {
        this.closeButton.setOnMouseClicked(mouseEvent -> closeAction.run());
    }

    public void configureStyle() {
        PreviewUtils.setStyleOnNode((Node)this.title, "body-1-bold", "black-text");
        this.getSubtitleStyleClass().setAll((Object[])new String[]{"body-2", "black-text"});
        PreviewUtils.setStyleOnNode((Node)this.defaultLinkIcon, "svg-link", "icon-xxxlarge", "icon-grey");
    }

    @Override
    public void updateLinkPreview(Optional<OpenGraphLruCache.OpenGraphWrapper> openGraphOptional) {
        super.updateLinkPreview(openGraphOptional);
        openGraphOptional.ifPresentOrElse(openGraph1 -> {
            if (openGraph1.getDescription() == null || openGraph1.getDescription().isEmpty()) {
                this.setDescription(openGraph1.getUrl());
            } else {
                this.setDescription(openGraph1.getDescription());
            }
        }, () -> this.setDescription(null));
    }
}

