/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_composer;

import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.fx.contacts.contacts_list.IntroduceContactModalController;
import io.olvid.windows.messenger.fx.custom_components.custom_controls.popup.CustomPopup;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_composer.MessageComposerController;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_composer.MoreModel;
import io.olvid.windows.messenger.fx.discussions.discussions_tab.DiscussionSelectionModel;
import io.olvid.windows.messenger.fx.framework.annotations.FXMLView;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.cache.DbCache;
import io.olvid.windows.messenger.livedata.info.ContactInfo;
import io.olvid.windows.messenger.livedata.info.DiscussionInfo;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.ModalNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import io.olvid.windows.messenger.start_up.AppRuntimeHelper;
import java.io.File;
import java.util.List;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.PopupControl;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.stage.FileChooser;
import javafx.stage.Window;

@FXMLView(path="fx/discussions/discussion_view/messages/message_composer/more_option.fxml")
public class MoreOptionController
extends BaseViewController {
    private final Button moreButton;
    private final MessageComposerController messageComposerController;
    private LiveDataListener<Optional<DiscussionInfo>> discussionLiveDataListener;
    @FXML
    private Pane root;
    @FXML
    private Button personalize_button;
    @FXML
    private Button present_button;
    @FXML
    private Button add_attachment_button;
    @FXML
    private Label present_label;
    private final MoreModel moreModel = new MoreModel();
    private PopupControl popup;

    public MoreOptionController(Button more_button, MessageComposerController messageComposerController) {
        this.moreButton = more_button;
        this.messageComposerController = messageComposerController;
        this.loadFxml();
        this.bind();
        this.add_attachment_button.setOnAction(this::attachmentsIconHandler);
        this.present_button.setOnAction(this::presentIconHandler);
        this.discussionLiveDataListener = (newValue, oldValue) -> this.setModel((Optional<DiscussionInfo>)newValue);
        DiscussionSelectionModel.getInstance().getSelectedDiscussionInfoLiveData().addListener(this.discussionLiveDataListener);
    }

    public void attachmentsIconHandler(ActionEvent actionEvent) {
        File homeFile;
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(ViewControllerHelper.getString("discussion_typing_zone_more_file_chooser_title"));
        String homePath = AppRuntimeHelper.USER_HOME_DIR_ABSOLUTE_PATH;
        File file = homeFile = homePath == null ? null : new File(homePath);
        if (homeFile != null) {
            fileChooser.setInitialDirectory(homeFile);
        }
        List files = fileChooser.showOpenMultipleDialog((Window)ViewControllerHelper.MAIN_STAGE);
        this.messageComposerController.handleNewFiles(files);
        this.closePopup();
    }

    private void presentIconHandler(ActionEvent actionEvent) {
        DiscussionSelectionModel.getInstance().getSelectedDiscussionLiveData().getValue().getContactId().ifPresent(contactId -> {
            Optional<ContactInfo> optionalContactInfo = DbCache.getInstance().getContactInfo((Id<Contact>)contactId);
            optionalContactInfo.ifPresent(contactInfo -> NCRegistry.getUIActionNC().postNotification(new ModalNotification(new IntroduceContactModalController((ContactInfo)contactInfo))));
        });
        this.closePopup();
    }

    private void closePopup() {
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
    }

    private void bind() {
        this.present_button.managedProperty().bind((ObservableValue)this.present_button.visibleProperty());
        this.present_button.visibleProperty().bind((ObservableValue)this.moreModel.contactNameProperty().isEmptyProperty().not());
        this.personalize_button.managedProperty().bind((ObservableValue)this.personalize_button.visibleProperty());
        this.personalize_button.visibleProperty().set(false);
        String presentTemplate = ViewControllerHelper.getString("discussion_typing_zone_more_present");
        this.moreModel.contactNameProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.isPresent()) {
                this.present_label.setText(String.format(presentTemplate, newValue.get()));
            } else {
                this.present_label.setText(null);
            }
        });
    }

    private void setModel(Optional<DiscussionInfo> newValue) {
        if (newValue.isPresent()) {
            DiscussionInfo discussionInfo = newValue.get();
            ViewControllerHelper.smartUIUpdate(() -> {
                switch (discussionInfo.kind()) {
                    case CONTACT: {
                        this.moreModel.setContactName(discussionInfo.title());
                        break;
                    }
                    case PRE_CONTACT: 
                    case GROUP: 
                    case PRE_GROUP: 
                    case LOCKED: {
                        this.moreModel.setContactName(Optional.empty());
                    }
                }
            });
        }
    }

    public void display() {
        this.popup = CustomPopup.loadPopupOnNodeWithPos((Region)this.root, (Region)this.moreButton, Pos.TOP_RIGHT);
    }

    @Override
    public Region getLayout() {
        return this.root;
    }

    @Override
    public void onLayoutAttached() {
    }

    @Override
    public void onLayoutDetached() {
        this.discussionLiveDataListener = null;
    }
}

