/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_composer;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Fyle;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.attachment.OutboundAttachment;
import io.olvid.windows.messenger.database.tables.gen.attachment.OutboundAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.MessageRef;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.engine.attachment.tasks.DeleteDraftAttachmentsDbTask;
import io.olvid.windows.messenger.engine.helpers.discussion.DiscussionApi;
import io.olvid.windows.messenger.engine.helpers.message.tasks.DraftsBackupTask;
import io.olvid.windows.messenger.fx.custom_components.custom_controls.popup.CustomPopup;
import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.discussions.discussion_view.DiscussionViewModel;
import io.olvid.windows.messenger.fx.discussions.discussion_view.attachments.preview.DraftPreviewAttachment;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_composer.DraftAttachmentsViewModel;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_composer.EphemeralSettingsPopupController;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_composer.MessageComposerModel;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_composer.MoreOptionController;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_composer.preview.DraftLinkPreview;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_composer.reply.ReplyController;
import io.olvid.windows.messenger.fx.discussions.discussions_tab.DiscussionSelectionModel;
import io.olvid.windows.messenger.fx.framework.animation.ScrollTransition;
import io.olvid.windows.messenger.fx.framework.annotations.FXMLView;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.generic_types.DiffUtils;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.ClipboardDelegate;
import io.olvid.windows.messenger.fx.misc.ImageHelper;
import io.olvid.windows.messenger.fx.misc.richtextfx.EditableStyledArea;
import io.olvid.windows.messenger.fx.misc.richtextfx.RichToolBarController;
import io.olvid.windows.messenger.fx.misc.richtextfx.ScrollableEditableStyledArea;
import io.olvid.windows.messenger.fx.misc.richtextfx.utils.RichStyledConfiguration;
import io.olvid.windows.messenger.fx.misc.richtextfx.utils.ToggleableArea;
import io.olvid.windows.messenger.fx.modal.message_infos.view.HBoxList;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.cache.DbCache;
import io.olvid.windows.messenger.livedata.info.DiscussionInfoWithState;
import io.olvid.windows.messenger.livedata.info.MessageRefInfo;
import io.olvid.windows.messenger.livedata.mediator.ContactInfoLiveData;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.ImageUtils;
import io.olvid.windows.messenger.misc.Pair;
import io.olvid.windows.messenger.misc.ThrottledConsumer;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.UIActionNC;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.embed.swing.SwingFXUtils;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.image.Image;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import javax.imageio.ImageIO;

@FXMLView(path="fx/discussions/discussion_view/messages/message_composer/message_composer.fxml")
public class MessageComposerController
extends BaseViewController
implements ClipboardDelegate.MultiFilesAndImage,
RichStyledConfiguration {
    private final LiveDataListener<List<OutboundAttachment>> attachmentsListener;
    private final LiveDataListener<Integer> remainingDraftAttachmentToCreateListener;
    private final DiscussionViewModel discussionViewModel;
    private final BooleanProperty allDraftAttachmentsReady = new SimpleBooleanProperty(true);
    @FXML
    public VBox root;
    @FXML
    private StackPane toolbar_container;
    @FXML
    private StackPane reply_container;
    @FXML
    private StackPane link_preview_container;
    @FXML
    public StackPane message_input_container;
    @FXML
    private ToggleButton ephemeral_settings_button;
    @FXML
    public ScrollPane attachment_scrollpane;
    @FXML
    private StackPane attachment_container;
    @FXML
    private Button attachment_previous;
    @FXML
    private Button attachment_next;
    @FXML
    private Button send_button;
    @FXML
    private Button more_button;
    public final HBoxList<OutboundAttachment, DraftPreviewAttachment> attachment_hbox;
    private final MessageComposerModel messageComposerModel = new MessageComposerModel();
    private ScrollableEditableStyledArea messageInput;
    private final DraftAttachmentsViewModel draftAttachmentsViewModel;
    private ReplyController replyController;
    private Optional<Id<MessageRef>> messageRefListenerKey = Optional.empty();
    private Optional<Id<ContactRef>> contactListenerKey = Optional.empty();
    private final LiveDataListener<ContactInfoLiveData.ContactInfoState> contactListener = (newValue, oldValue) -> this.replyController.set((ContactInfoLiveData.ContactInfoState)newValue);
    private ThrottledConsumer runnable;
    private DraftLinkPreview draftLinkPreview;
    private final LiveDataListener<Optional<OutboundAttachment>> draftLinkPreviewListener = this::onDraftLinkPreviewChanged;
    private final BooleanProperty extendedComposer = new SimpleBooleanProperty(false);
    private static final double MIN_HEIGHT = 20.0;
    private static final double REDUCE_MAX_HEIGHT = 100.0;
    private static final double EXTENDED_MAX_HEIGHT = 240.0;
    private final LiveDataListener<Optional<MessageRefInfo>> messageRefListener = (newMsg, oldMsg) -> {
        if (newMsg.isEmpty()) {
            ViewControllerHelper.smartUIUpdate(() -> ViewControllerHelper.hideNode((Node)this.reply_container));
            return;
        }
        if (DiffUtils.areContentTheSame(newMsg, oldMsg)) {
            return;
        }
        MessageRefInfo messageRefInfo = (MessageRefInfo)newMsg.get();
        this.replyController.set(messageRefInfo);
        if (messageRefInfo.inboundMessage().isPresent()) {
            Id<ContactRef> senderId = messageRefInfo.inboundMessage().get().getSenderId();
            if (this.contactListenerKey.isPresent() && !this.contactListenerKey.get().equals(senderId)) {
                DbCache.getInstance().contactRefInfoMapLiveData.removeListener(this.contactListenerKey.get(), this.contactListener);
            }
            DbCache.getInstance().contactRefInfoMapLiveData.addListener(senderId, this.contactListener);
            this.contactListenerKey = Optional.of(senderId);
        } else if (messageRefInfo.outboundMessage().isPresent() || messageRefInfo.ownedMessage().isPresent()) {
            if (this.contactListenerKey.isPresent()) {
                DbCache.getInstance().contactRefInfoMapLiveData.removeListener(this.contactListenerKey.get(), this.contactListener);
                this.contactListenerKey = Optional.empty();
            }
            this.replyController.setOwnedIdentity();
        }
        ViewControllerHelper.smartUIUpdate(() -> {
            ViewControllerHelper.showNode((Node)this.reply_container);
            this.messageInput.requestFocus();
        });
    };

    public MessageComposerController(DiscussionViewModel discussionViewModel) {
        this.discussionViewModel = discussionViewModel;
        this.attachmentsListener = (newValue, oldValue) -> ViewControllerHelper.smartUIUpdate(() -> {
            if (newValue == null) {
                this.allDraftAttachmentsReady.set(true);
            } else {
                this.allDraftAttachmentsReady.set(newValue.stream().allMatch(attachment -> attachment.getStatus() == OutboundAttachmentGenerated.Status.DRAFT_READY));
            }
        });
        this.loadFxml();
        this.draftAttachmentsViewModel = new DraftAttachmentsViewModel();
        this.attachment_hbox = new HBoxList<OutboundAttachment, DraftPreviewAttachment>(DraftPreviewAttachment.class, discussionViewModel::getDraftPreview);
        this.attachment_hbox.setPadding(new Insets(7.0, 16.0, 2.0, 16.0));
        this.attachment_hbox.setSpacing(12.0);
        this.attachment_scrollpane.setContent(this.attachment_hbox);
        this.attachment_hbox.plug(this.draftAttachmentsViewModel.getPureDraftAttachment());
        this.remainingDraftAttachmentToCreateListener = (newValue, oldValue) -> ViewControllerHelper.smartUIUpdate(() -> {
            this.draftAttachmentsViewModel.setAttachmentCountProperty((int)newValue);
            if (newValue == 0) {
                this.draftAttachmentsViewModel.setMaxAttachmentToDownload(0);
            }
            int old = Objects.requireNonNullElse(oldValue, 0);
            if (newValue > old) {
                this.draftAttachmentsViewModel.setMaxAttachmentToDownload((int)newValue);
            }
        });
        DiscussionSelectionModel.getInstance().getRemainingDraftAttachmentToCreate().addListener(this.remainingDraftAttachmentToCreateListener);
        this.initToolBar();
        this.initAttachmentContainer();
        this.handleScrollButton();
        this.initSendButton();
        this.initMoreButton();
        this.initReply();
        this.initDraftLinkPreview();
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        super.initialize(location, resources);
        this.initMessageInput();
        this.ephemeral_settings_button.setOnMouseClicked(event -> {
            Point2D point2D = this.ephemeral_settings_button.localToScreen(0.0, 0.0);
            Pair<Double, Double> position = new Pair<Double, Double>(point2D.getX(), point2D.getY());
            CustomPopup.loadCustomPopupWithNodeCoordinates(new EphemeralSettingsPopupController().getContainer(), position.getFirst(), position.getSecond());
        });
        DiscussionSelectionModel.getInstance().getSelectedDiscussionLiveData().addListener(this::onCurrentDiscussionChanged);
    }

    public void handleNewFiles(List<File> files) {
        if (files == null || files.isEmpty()) {
            return;
        }
        files = files.stream().filter(file -> !file.isDirectory()).toList();
        Discussion discussion = DiscussionSelectionModel.getInstance().getSelectedDiscussionLiveData().getValue();
        AsyncTaskExecutor.submitTask(new DraftsBackupTask((Id<Discussion>)discussion.getItemId(), this.getTrimmedMsgInput(), files));
    }

    @Override
    public void importFiles(List<File> files) {
        this.handleNewFiles(files);
    }

    @Override
    public void importImage(Image image) {
        try {
            BufferedImage bufferedImage = SwingFXUtils.fromFXImage((Image)image, null);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "png", baos);
            this.importImage(ImageUtils.MimeType.PNG, baos.toByteArray());
        }
        catch (IOException e) {
            this.logger.error("Cannot copy pasted image", e);
        }
    }

    @Override
    public void importImage(ImageUtils.MimeType mimeType, byte[] bytes) {
        Optional<DiscussionInfoWithState> discussionInfoWithState = this.discussionViewModel.getDbSelectedDiscussion().getValue();
        if (discussionInfoWithState.isEmpty()) {
            return;
        }
        Id<Discussion> id = discussionInfoWithState.get().info().id();
        AsyncTaskExecutor.submitTask(new DraftsBackupTask(id, this.getTrimmedMsgInput(), new DraftsBackupTask.DataInputStruct(bytes, mimeType.value)));
    }

    @Override
    public Region getLayout() {
        return this.root;
    }

    @Override
    public void onLayoutAttached() {
        this.draftAttachmentsViewModel.getLinkPreviewDraftAttachment().addListener(this.draftLinkPreviewListener);
    }

    @Override
    public void onLayoutDetached() {
        this.draftAttachmentsViewModel.getLinkPreviewDraftAttachment().removeListener(this.draftLinkPreviewListener);
    }

    public String getTrimmedMsgInput() {
        String text = this.messageInput.getText();
        if (text != null) {
            return text.trim();
        }
        return "";
    }

    private void initDraftLinkPreview() {
        this.draftLinkPreview = new DraftLinkPreview(this.discussionViewModel.getOpenGraphLruCache(), (DoubleExpression)this.root.widthProperty());
        this.draftLinkPreview.setCloseAction(() -> AsyncTaskExecutor.submitTask(() -> {
            if (this.draftAttachmentsViewModel.getLinkPreviewDraftAttachment().getValue().isPresent()) {
                new DeleteDraftAttachmentsDbTask(this.draftAttachmentsViewModel.getLinkPreviewDraftAttachment().getValue().get()).run();
            }
        }));
        this.link_preview_container.getChildren().add((Object)this.draftLinkPreview);
        this.runnable = new ThrottledConsumer(last -> this.draftAttachmentsViewModel.fetchOpenGraph(this.getTrimmedMsgInput(), (Optional<String>)last), "app-link-preview-fetcher", 300L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCurrentDiscussionChanged(Discussion newDiscussion, Discussion oldDiscussion) {
        if (newDiscussion == null || newDiscussion.equals(oldDiscussion)) {
            return;
        }
        if (oldDiscussion != null) {
            AsyncTaskExecutor.submitTask(new DraftsBackupTask((Id<Discussion>)oldDiscussion.getItemId(), this.getTrimmedMsgInput(), Collections.emptyList()));
        }
        if (newDiscussion.getContactId().isPresent() || newDiscussion.getGroupId().isPresent()) {
            Map<Id<Discussion>, Optional<String>> map = DraftsBackupTask.draftPerDiscussion;
            synchronized (map) {
                Optional<String> body;
                if (DraftsBackupTask.draftPerDiscussion.containsKey(newDiscussion.getItemId())) {
                    body = DraftsBackupTask.draftPerDiscussion.get(newDiscussion.getItemId());
                } else {
                    Optional<OutboundMessage> outboundMessage = DbManager.getInstance().getOutboundMessageDao().getDiscussionDraftMessage((Id<Discussion>)newDiscussion.getItemId());
                    if (outboundMessage.isPresent()) {
                        DraftsBackupTask.draftPerDiscussion.put((Id<Discussion>)newDiscussion.getItemId(), outboundMessage.get().getBody());
                    }
                    body = outboundMessage.flatMap(AbstractUserMessageGenerated::getBody);
                }
                ViewControllerHelper.smartUIUpdate(() -> this.messageInput.setText(body.orElse(null)));
            }
        }
    }

    private void onDraftLinkPreviewChanged(Optional<OutboundAttachment> newValue, Optional<OutboundAttachment> oldValue) {
        if (newValue == null || newValue.isEmpty()) {
            ViewControllerHelper.smartUIUpdate(() -> {
                this.draftLinkPreview.dispose();
                ViewControllerHelper.hideNode((Node)this.link_preview_container);
            });
            return;
        }
        if (newValue.get().equals(oldValue.orElse(null))) {
            return;
        }
        Fyle fyle = DbManager.getInstance().getFyleDao().get(newValue.get().getFyleId());
        if (fyle.getSha256().isEmpty()) {
            ViewControllerHelper.smartUIUpdate(() -> {
                this.draftLinkPreview.dispose();
                ViewControllerHelper.hideNode((Node)this.link_preview_container);
            });
            return;
        }
        ViewControllerHelper.smartUIUpdate(() -> {
            this.draftLinkPreview.setImageData(ImageHelper.ImageData.of((Id<Fyle>)fyle.getItemId(), fyle.getFilePath(), fyle.getSha256().get(), ((OutboundAttachment)newValue.get()).getMimeType()));
            ViewControllerHelper.showNode((Node)this.link_preview_container);
        });
    }

    private void initMessageInput() {
        this.messageInput = new ScrollableEditableStyledArea(this);
        ((EditableStyledArea)this.messageInput.getContent()).setMinHeight(20.0);
        ((EditableStyledArea)this.messageInput.getContent()).setMaxHeight(100.0);
        ((EditableStyledArea)this.messageInput.getContent()).maxWidthProperty().bind((ObservableValue)this.message_input_container.widthProperty());
        this.message_input_container.getChildren().add((Object)this.messageInput);
        this.root.setOnMouseClicked(event -> this.messageInput.requestFocus());
        this.messageInput.setClipboardDelegate(this);
        this.messageInput.setAccessibleRole(AccessibleRole.BUTTON);
        this.messageInput.setAccessibleRoleDescription("Zone de composition");
        this.messageInput.setAccessibleText("Accessibility Text");
    }

    private void initReply() {
        this.replyController = new ReplyController(() -> AsyncTaskExecutor.submitTask(() -> {
            Optional<DiscussionInfoWithState> discussionInfoOpt = this.discussionViewModel.getDbSelectedDiscussion().getValue();
            if (discussionInfoOpt.isEmpty()) {
                return;
            }
            DiscussionInfoWithState discussionInfo = discussionInfoOpt.get();
            Discussion discussion = DbManager.getInstance().getDiscussionDao().get(discussionInfo.id());
            Optional<OutboundMessage> outboundMessageOptional = this.messageComposerModel.getDraftMessage().getValue();
            if (outboundMessageOptional.isPresent() && outboundMessageOptional.get().getReplyToId().isPresent() && !discussion.getLastUserMessageRefId().equals(Optional.of(outboundMessageOptional.get().getReplyToId().get()))) {
                DbManager.getInstance().getMessageRefDao().customDeleteById(outboundMessageOptional.get().getReplyToId().get());
            }
            DiscussionApi.updateDraftReplyTo((Id<Discussion>)discussion.getItemId(), Optional.empty());
        }));
        this.reply_container.getChildren().add((Object)this.replyController.getLayout());
        ViewControllerHelper.hideNode((Node)this.reply_container);
        this.messageComposerModel.getDraftMessage().addListener((newValue, oldValue) -> {
            if (newValue == null) {
                return;
            }
            if (DiffUtils.areContentTheSame(oldValue, newValue)) {
                return;
            }
            if (newValue.isEmpty() || ((OutboundMessage)newValue.get()).getReplyToId().isEmpty()) {
                this.removeMessageRefListener();
                if (this.contactListenerKey.isPresent()) {
                    DbCache.getInstance().contactRefInfoMapLiveData.removeListener(this.contactListenerKey.get(), this.contactListener);
                    this.contactListenerKey = Optional.empty();
                }
                ViewControllerHelper.smartUIUpdate(() -> ViewControllerHelper.hideNode((Node)this.reply_container));
                return;
            }
            Id<MessageRef> replyToId = ((OutboundMessage)newValue.get()).getReplyToId().get();
            this.addMessageRefListener(replyToId);
        });
    }

    private void initAttachmentContainer() {
        this.attachment_container.managedProperty().bind((ObservableValue)this.attachment_container.visibleProperty());
        this.attachment_container.visibleProperty().bind((ObservableValue)Bindings.isEmpty((ObservableList)this.attachment_hbox.getChildren()).not());
        this.attachment_scrollpane.prefViewportHeightProperty().bind((ObservableValue)this.attachment_hbox.heightProperty());
        this.attachment_hbox.widthProperty().addListener((observable, oldValue, newValue) -> {
            if (Math.abs(this.attachment_scrollpane.getHvalue() * (newValue.doubleValue() - this.attachment_scrollpane.widthProperty().get()) - (oldValue.doubleValue() - this.attachment_scrollpane.widthProperty().get())) < 0.01) {
                this.attachment_scrollpane.setHvalue(1.0);
            }
        });
        Rectangle loadBar = new Rectangle(0.0, 1.0);
        loadBar.getStyleClass().add((Object)"blue-shape");
        StackPane.setAlignment((Node)loadBar, (Pos)Pos.BOTTOM_LEFT);
        loadBar.widthProperty().bind((ObservableValue)this.attachment_container.widthProperty().multiply((ObservableNumberValue)Bindings.when((ObservableBooleanValue)this.draftAttachmentsViewModel.maxAttachmentToDownloadProperty().isEqualTo(0)).then(0).otherwise((ObservableNumberValue)this.draftAttachmentsViewModel.attachmentCountPropertyProperty().divide((ObservableNumberValue)this.draftAttachmentsViewModel.maxAttachmentToDownloadProperty().add(0.01)))));
        loadBar.visibleProperty().bind((ObservableValue)this.draftAttachmentsViewModel.maxAttachmentToDownloadProperty().greaterThan(5));
        this.attachment_container.getChildren().add((Object)loadBar);
    }

    private void initMoreButton() {
        MoreOptionController moreOptionController = new MoreOptionController(this.more_button, this);
        this.more_button.setOnAction(event -> moreOptionController.display());
    }

    private void initToolBar() {
        RichToolBarController richToolBarController = new RichToolBarController((ToggleableArea)this.messageInput.getContent());
        this.toolbar_container.getChildren().add((Object)richToolBarController.toolBar);
        Button fullScreenButton = new Button();
        fullScreenButton.getStyleClass().add((Object)"transparent-icon-button");
        SvgSizeable svgSizeable = new SvgSizeable();
        svgSizeable.getStyleClass().addAll((Object[])new String[]{"svg-fullscreen", "icon-xsmall"});
        fullScreenButton.setGraphic((Node)svgSizeable);
        fullScreenButton.setOnAction(event -> {
            this.extendedComposer.set(!this.extendedComposer.get());
            boolean extended = this.extendedComposer.get();
            if (extended) {
                if (!fullScreenButton.getStyleClass().contains((Object)"active-button")) {
                    fullScreenButton.getStyleClass().add((Object)"active-button");
                }
                ((EditableStyledArea)this.messageInput.getContent()).setMaxHeight(240.0);
                ((EditableStyledArea)this.messageInput.getContent()).setPrefHeight(240.0);
            } else {
                fullScreenButton.getStyleClass().remove((Object)"active-button");
                ((EditableStyledArea)this.messageInput.getContent()).setMaxHeight(100.0);
                ((EditableStyledArea)this.messageInput.getContent()).setPrefHeight(-1.0);
            }
        });
        richToolBarController.toolBar.getItems().add((Object)fullScreenButton);
    }

    private void initSendButton() {
        BooleanBinding noAttachments = Bindings.isEmpty((ObservableList)this.attachment_hbox.getChildren());
        this.send_button.disableProperty().bind((ObservableValue)this.messageInput.isEmpty().and((ObservableBooleanValue)noAttachments).or((ObservableBooleanValue)this.draftAttachmentsViewModel.attachmentCountPropertyProperty().greaterThan(0)).or((ObservableBooleanValue)this.allDraftAttachmentsReady.not()));
        this.send_button.setOnAction(event -> this.scheduleOrSend());
        this.send_button.setAccessibleRole(AccessibleRole.BUTTON);
        this.send_button.setAccessibleRoleDescription("send button role description");
        this.send_button.setAccessibleText("Send button access text");
    }

    private void handleScrollButton() {
        this.attachment_scrollpane.setOnScroll(event -> {
            if (event.getDeltaX() == 0.0 && event.getDeltaY() != 0.0) {
                this.attachment_scrollpane.setHvalue(this.attachment_scrollpane.getHvalue() - event.getDeltaY() / this.attachment_hbox.getWidth());
            }
        });
        this.attachment_previous.setOnAction(event -> new ScrollTransition(this, false).play());
        this.attachment_next.setOnAction(event -> new ScrollTransition(this, true).play());
        this.attachment_next.visibleProperty().bind((ObservableValue)this.attachment_scrollpane.hvalueProperty().isNotEqualTo(1L).and((ObservableBooleanValue)this.attachment_hbox.widthProperty().greaterThan((ObservableNumberValue)this.attachment_scrollpane.widthProperty())));
        this.attachment_previous.visibleProperty().bind((ObservableValue)this.attachment_scrollpane.hvalueProperty().isNotEqualTo(0L).and((ObservableBooleanValue)this.attachment_hbox.widthProperty().greaterThan((ObservableNumberValue)this.attachment_scrollpane.widthProperty())));
    }

    private void scheduleOrSend() {
        this.logger.debug("Call scheduleOrSend");
        AsyncTaskExecutor.submitTask(() -> {
            if (this.runnable.getScheduledTask().isPresent()) {
                try {
                    this.logger.debug("Call wait for last link preview to be computed");
                    this.runnable.getScheduledTask().get().get(2000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    AppLogger.e("MessageComposerController::scheduleOrSend blocking get threw an exception", e);
                }
            }
            this.sendMessageHandler();
        });
    }

    private void sendMessageHandler() {
        String body = this.messageInput.getText().trim();
        if (body.isEmpty() && this.draftAttachmentsViewModel.getPureDraftAttachmentsList().isEmpty()) {
            return;
        }
        Discussion discussion = DiscussionSelectionModel.getInstance().getSelectedDiscussionLiveData().getValue();
        if (discussion != null) {
            Optional<MessageRef> replyTo;
            Optional<OutboundMessage> draftMessageOpt = this.messageComposerModel.getDraftMessage().getValue();
            boolean markDiscussionAsRead = false;
            if (draftMessageOpt.isEmpty()) {
                replyTo = Optional.empty();
                markDiscussionAsRead = true;
            } else {
                Optional<Id<MessageRef>> replyToId = draftMessageOpt.get().getReplyToId();
                if (replyToId.isEmpty()) {
                    replyTo = Optional.empty();
                    markDiscussionAsRead = true;
                } else {
                    replyTo = Optional.ofNullable(DbManager.getInstance().getMessageRefDao().get(replyToId.get()));
                }
            }
            Api.getMessageApi().sendMessageDbTask(Optional.of(body), (Id<Discussion>)discussion.getItemId(), replyTo);
            Optional<String> removeRet = DraftsBackupTask.draftPerDiscussion.remove(discussion.getItemId());
            if (removeRet == null || removeRet.isEmpty()) {
                AppLogger.w("sendMessageHandler::sendMessageDbTask draft message was null...");
            }
            this.draftAttachmentsViewModel.updateOpenGraph(Optional.empty());
            ViewControllerHelper.smartUIUpdate(() -> {
                this.messageInput.clearWithoutDetections();
                this.messageInput.requestFocus();
            });
            if (markDiscussionAsRead) {
                DiscussionApi.markDiscussionMessagesAsReadUpTo((Id<Discussion>)discussion.getItemId(), Optional.empty());
                if (this.discussionViewModel.getSearchMode().not().get()) {
                    UIActionNC.fireScrollToBottom((Id<Discussion>)discussion.getItemId());
                }
            }
        } else {
            AppLogger.e("Unable to send message, no current discussion");
        }
    }

    private void addMessageRefListener(Id<MessageRef> messageRefId) {
        if (this.messageRefListenerKey.isPresent() && !this.messageRefListenerKey.get().equals(messageRefId)) {
            this.removeMessageRefListener();
        }
        if (this.messageRefListenerKey.isEmpty()) {
            this.discussionViewModel.addMessageRefListener(messageRefId, this.messageRefListener);
            this.messageRefListenerKey = Optional.of(messageRefId);
        }
    }

    private void removeMessageRefListener() {
        if (this.messageRefListenerKey.isPresent()) {
            this.discussionViewModel.removeMessageRefListener(this.messageRefListenerKey.get(), this.messageRefListener);
            this.messageRefListenerKey = Optional.empty();
        }
    }

    @Override
    public RichStyledConfiguration.DelimiterProcessing processDelimiter() {
        if (this.messageInput == null) {
            return RichStyledConfiguration.DelimiterProcessing.NONE;
        }
        return switch ((EditableStyledArea.Mode)((Object)this.messageInput.mode().get())) {
            default -> throw new MatchException(null, null);
            case EditableStyledArea.Mode.PLAIN -> RichStyledConfiguration.DelimiterProcessing.STYLE;
            case EditableStyledArea.Mode.PLAIN_TO_RICH -> RichStyledConfiguration.DelimiterProcessing.DELETE_AND_RICH_REPLACE;
            case EditableStyledArea.Mode.RICH -> RichStyledConfiguration.DelimiterProcessing.TOGGLEABLE;
        };
    }

    @Override
    public boolean applyStyle() {
        if (this.messageInput == null) {
            return false;
        }
        return switch ((EditableStyledArea.Mode)((Object)this.messageInput.mode().get())) {
            default -> throw new MatchException(null, null);
            case EditableStyledArea.Mode.PLAIN, EditableStyledArea.Mode.PLAIN_TO_RICH -> true;
            case EditableStyledArea.Mode.RICH -> false;
        };
    }

    @Override
    public boolean applyBlockCodeStyle() {
        if (this.messageInput == null) {
            return false;
        }
        return switch ((EditableStyledArea.Mode)((Object)this.messageInput.mode().get())) {
            default -> throw new MatchException(null, null);
            case EditableStyledArea.Mode.PLAIN -> true;
            case EditableStyledArea.Mode.PLAIN_TO_RICH, EditableStyledArea.Mode.RICH -> false;
        };
    }

    @Override
    public boolean enableLinkDetection() {
        return true;
    }

    @Override
    public boolean clickableLinks() {
        return false;
    }

    @Override
    public void linkFound(Optional<String> url) {
        this.logger.trace("MessageComposer::urlDetectionListener url detected");
        this.runnable.run(url.orElse(null));
    }

    @Override
    public void handleEnter() {
        this.scheduleOrSend();
    }
}

